/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.transformations.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrTraitField;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrTraitMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GrClassImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.transformations.AstTransformationSupport;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;

public class TraitTransformationSupport
implements AstTransformationSupport {
    private static final Logger LOG = Logger.getInstance(TraitTransformationSupport.class);

    @Override
    public void applyTransformation(@NotNull TransformationContext context) {
        List<PsiClassType.ClassResolveResult> traits;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/transformations/impl/TraitTransformationSupport", "applyTransformation"));
        }
        if (context.getCodeClass().isInterface() && !context.getCodeClass().isTrait()) {
            return;
        }
        if (context.getCodeClass().isTrait()) {
            for (GrField field : context.getCodeClass().getCodeFields()) {
                context.addField(new GrTraitField(field, context.getCodeClass(), PsiSubstitutor.EMPTY));
            }
        }
        if ((traits = TraitTransformationSupport.getSuperTraitsByCorrectOrder(context.getImplementsTypes())).isEmpty()) {
            return;
        }
        for (PsiClassType.ClassResolveResult resolveResult : traits) {
            PsiClass superTrait = resolveResult.getElement();
            LOG.assertTrue(superTrait != null);
            TraitTransformationSupport.process(superTrait, resolveResult.getSubstitutor(), ContainerUtil.newHashSet(), (PairConsumer<PsiClass, PsiSubstitutor>)((PairConsumer)(trait, substitutor) -> {
                block6: {
                    block5: {
                        if (context == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/transformations/impl/TraitTransformationSupport", "lambda$applyTransformation$0"));
                        }
                        if (!(trait instanceof GrTypeDefinition)) break block5;
                        for (PsiMethod psiMethod : trait.getMethods()) {
                            if (psiMethod.getModifierList().hasExplicitModifier("abstract")) continue;
                            context.addMethods(TraitTransformationSupport.getExpandingMethods(context.getCodeClass(), psiMethod, substitutor));
                        }
                        for (GrField grField : ((GrTypeDefinition)trait).getCodeFields()) {
                            context.addField(new GrTraitField(grField, context.getCodeClass(), (PsiSubstitutor)substitutor));
                        }
                        break block6;
                    }
                    if (!(trait instanceof ClsClassImpl)) break block6;
                    for (PsiMethod method : GrTraitUtil.getCompiledTraitConcreteMethods((ClsClassImpl)trait)) {
                        context.addMethods(TraitTransformationSupport.getExpandingMethods(context.getCodeClass(), method, substitutor));
                    }
                    for (GrField field : GrTraitUtil.getCompiledTraitFields((ClsClassImpl)trait)) {
                        context.addField(new GrTraitField(field, context.getCodeClass(), (PsiSubstitutor)substitutor));
                    }
                }
            }));
        }
    }

    private static void process(@NotNull PsiClass trait, @NotNull PsiSubstitutor substitutor, @NotNull Set<PsiClass> visited, @NotNull PairConsumer<PsiClass, PsiSubstitutor> consumer) {
        if (trait == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trait", "org/jetbrains/plugins/groovy/transformations/impl/TraitTransformationSupport", "process"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/plugins/groovy/transformations/impl/TraitTransformationSupport", "process"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "org/jetbrains/plugins/groovy/transformations/impl/TraitTransformationSupport", "process"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/plugins/groovy/transformations/impl/TraitTransformationSupport", "process"));
        }
        consumer.consume((Object)trait, (Object)substitutor);
        List<PsiClassType.ClassResolveResult> traits = TraitTransformationSupport.getSuperTraitsByCorrectOrder(Arrays.asList(trait.getSuperTypes()));
        for (PsiClassType.ClassResolveResult resolveResult : traits) {
            PsiClass superClass = resolveResult.getElement();
            if (superClass == null || !visited.add(superClass)) continue;
            PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)trait, (PsiSubstitutor)substitutor);
            TraitTransformationSupport.process(superClass, superSubstitutor, visited, consumer);
        }
    }

    @NotNull
    private static List<PsiClassType.ClassResolveResult> getSuperTraitsByCorrectOrder(@NotNull List<PsiClassType> types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/plugins/groovy/transformations/impl/TraitTransformationSupport", "getSuperTraitsByCorrectOrder"));
        }
        List traits = ContainerUtil.newSmartList();
        for (int i = types.size() - 1; i >= 0; --i) {
            PsiClassType.ClassResolveResult resolveResult = types.get(i).resolveGenerics();
            PsiClass superClass = resolveResult.getElement();
            if (!GrTraitUtil.isTrait(superClass)) continue;
            traits.add(resolveResult);
        }
        List list = traits;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/transformations/impl/TraitTransformationSupport", "getSuperTraitsByCorrectOrder"));
        }
        return list;
    }

    @NotNull
    private static List<PsiMethod> getExpandingMethods(@NotNull PsiClass containingClass, @NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor) {
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "org/jetbrains/plugins/groovy/transformations/impl/TraitTransformationSupport", "getExpandingMethods"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/transformations/impl/TraitTransformationSupport", "getExpandingMethods"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/plugins/groovy/transformations/impl/TraitTransformationSupport", "getExpandingMethods"));
        }
        List result = ContainerUtil.newSmartList();
        for (PsiMethod psiMethod : GrClassImplUtil.expandReflectedMethods(method)) {
            result.add(new GrTraitMethod(containingClass, psiMethod, substitutor));
        }
        List list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/transformations/impl/TraitTransformationSupport", "getExpandingMethods"));
        }
        return list;
    }
}

