/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.config.CompilerSettings;

public class JpsKotlinCompilerSettings
extends JpsElementBase<JpsKotlinCompilerSettings> {
    static final JpsElementChildRole<JpsKotlinCompilerSettings> ROLE = JpsElementChildRoleBase.create((String)"Kotlin Compiler Settings");
    @NotNull
    private CommonCompilerArguments commonCompilerArguments = new CommonCompilerArguments.DummyImpl();
    @NotNull
    private K2JVMCompilerArguments k2JvmCompilerArguments = new K2JVMCompilerArguments();
    @NotNull
    private K2JSCompilerArguments k2JsCompilerArguments = new K2JSCompilerArguments();
    @NotNull
    private CompilerSettings compilerSettings = new CompilerSettings();

    @NotNull
    public JpsKotlinCompilerSettings createCopy() {
        JpsKotlinCompilerSettings copy = new JpsKotlinCompilerSettings();
        copy.commonCompilerArguments = this.commonCompilerArguments;
        copy.k2JvmCompilerArguments = this.k2JvmCompilerArguments;
        copy.k2JsCompilerArguments = this.k2JsCompilerArguments;
        copy.compilerSettings = this.compilerSettings;
        JpsKotlinCompilerSettings jpsKotlinCompilerSettings = copy;
        if (jpsKotlinCompilerSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/jps/JpsKotlinCompilerSettings", "createCopy"));
        }
        return jpsKotlinCompilerSettings;
    }

    public void applyChanges(@NotNull JpsKotlinCompilerSettings modified) {
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modified", "org/jetbrains/kotlin/jps/JpsKotlinCompilerSettings", "applyChanges"));
        }
    }

    @NotNull
    public static JpsKotlinCompilerSettings getSettings(@NotNull JpsProject project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/jps/JpsKotlinCompilerSettings", "getSettings"));
        }
        JpsKotlinCompilerSettings settings = (JpsKotlinCompilerSettings)project.getContainer().getChild(ROLE);
        if (settings == null) {
            settings = new JpsKotlinCompilerSettings();
        }
        JpsKotlinCompilerSettings jpsKotlinCompilerSettings = settings;
        if (jpsKotlinCompilerSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/jps/JpsKotlinCompilerSettings", "getSettings"));
        }
        return jpsKotlinCompilerSettings;
    }

    @NotNull
    public static JpsKotlinCompilerSettings getOrCreateSettings(@NotNull JpsProject project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/jps/JpsKotlinCompilerSettings", "getOrCreateSettings"));
        }
        JpsKotlinCompilerSettings settings = (JpsKotlinCompilerSettings)project.getContainer().getChild(ROLE);
        if (settings == null) {
            settings = new JpsKotlinCompilerSettings();
            project.getContainer().setChild(ROLE, (JpsElement)settings);
        }
        JpsKotlinCompilerSettings jpsKotlinCompilerSettings = settings;
        if (jpsKotlinCompilerSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/jps/JpsKotlinCompilerSettings", "getOrCreateSettings"));
        }
        return jpsKotlinCompilerSettings;
    }

    @NotNull
    public static CommonCompilerArguments getCommonCompilerArguments(@NotNull JpsProject project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/jps/JpsKotlinCompilerSettings", "getCommonCompilerArguments"));
        }
        CommonCompilerArguments commonCompilerArguments = JpsKotlinCompilerSettings.getSettings((JpsProject)project).commonCompilerArguments;
        if (commonCompilerArguments == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/jps/JpsKotlinCompilerSettings", "getCommonCompilerArguments"));
        }
        return commonCompilerArguments;
    }

    public static void setCommonCompilerArguments(@NotNull JpsProject project, @NotNull CommonCompilerArguments commonCompilerSettings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/jps/JpsKotlinCompilerSettings", "setCommonCompilerArguments"));
        }
        if (commonCompilerSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonCompilerSettings", "org/jetbrains/kotlin/jps/JpsKotlinCompilerSettings", "setCommonCompilerArguments"));
        }
        JpsKotlinCompilerSettings.getOrCreateSettings((JpsProject)project).commonCompilerArguments = commonCompilerSettings;
    }

    @NotNull
    public static K2JVMCompilerArguments getK2JvmCompilerArguments(@NotNull JpsProject project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/jps/JpsKotlinCompilerSettings", "getK2JvmCompilerArguments"));
        }
        K2JVMCompilerArguments k2JVMCompilerArguments = JpsKotlinCompilerSettings.getSettings((JpsProject)project).k2JvmCompilerArguments;
        if (k2JVMCompilerArguments == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/jps/JpsKotlinCompilerSettings", "getK2JvmCompilerArguments"));
        }
        return k2JVMCompilerArguments;
    }

    public static void setK2JvmCompilerArguments(@NotNull JpsProject project, @NotNull K2JVMCompilerArguments k2JvmCompilerArguments) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/jps/JpsKotlinCompilerSettings", "setK2JvmCompilerArguments"));
        }
        if (k2JvmCompilerArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k2JvmCompilerArguments", "org/jetbrains/kotlin/jps/JpsKotlinCompilerSettings", "setK2JvmCompilerArguments"));
        }
        JpsKotlinCompilerSettings.getOrCreateSettings((JpsProject)project).k2JvmCompilerArguments = k2JvmCompilerArguments;
    }

    @NotNull
    public static K2JSCompilerArguments getK2JsCompilerArguments(@NotNull JpsProject project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/jps/JpsKotlinCompilerSettings", "getK2JsCompilerArguments"));
        }
        K2JSCompilerArguments k2JSCompilerArguments = JpsKotlinCompilerSettings.getSettings((JpsProject)project).k2JsCompilerArguments;
        if (k2JSCompilerArguments == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/jps/JpsKotlinCompilerSettings", "getK2JsCompilerArguments"));
        }
        return k2JSCompilerArguments;
    }

    public static void setK2JsCompilerArguments(@NotNull JpsProject project, @NotNull K2JSCompilerArguments k2JsCompilerArguments) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/jps/JpsKotlinCompilerSettings", "setK2JsCompilerArguments"));
        }
        if (k2JsCompilerArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k2JsCompilerArguments", "org/jetbrains/kotlin/jps/JpsKotlinCompilerSettings", "setK2JsCompilerArguments"));
        }
        JpsKotlinCompilerSettings.getOrCreateSettings((JpsProject)project).k2JsCompilerArguments = k2JsCompilerArguments;
    }

    @NotNull
    public static CompilerSettings getCompilerSettings(@NotNull JpsProject project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/jps/JpsKotlinCompilerSettings", "getCompilerSettings"));
        }
        CompilerSettings compilerSettings = JpsKotlinCompilerSettings.getSettings((JpsProject)project).compilerSettings;
        if (compilerSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/jps/JpsKotlinCompilerSettings", "getCompilerSettings"));
        }
        return compilerSettings;
    }

    public static void setCompilerSettings(@NotNull JpsProject project, @NotNull CompilerSettings compilerSettings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/jps/JpsKotlinCompilerSettings", "setCompilerSettings"));
        }
        if (compilerSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerSettings", "org/jetbrains/kotlin/jps/JpsKotlinCompilerSettings", "setCompilerSettings"));
        }
        JpsKotlinCompilerSettings.getOrCreateSettings((JpsProject)project).compilerSettings = compilerSettings;
    }
}

