/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.google.common.collect.Lists;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.ClassFileUtilsKt;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.MultifileClassCodegen;
import org.jetbrains.kotlin.codegen.PackageCodegen;
import org.jetbrains.kotlin.codegen.PackagePartRegistry;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.load.kotlin.JvmMetadataVersion;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.load.kotlin.PackageParts;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.serialization.jvm.JvmPackageTable;
import org.jetbrains.org.objectweb.asm.Type;

public class ClassFileFactory
implements OutputFileCollection {
    private final GenerationState state;
    private final ClassBuilderFactory builderFactory;
    private final Map<String, OutAndSourceFileList> generators;
    private boolean isDone;
    private final Set<File> packagePartSourceFiles;
    private final Map<String, PackageParts> partsGroupedByPackage;

    public ClassFileFactory(@NotNull GenerationState state, @NotNull ClassBuilderFactory builderFactory) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/ClassFileFactory", "<init>"));
        }
        if (builderFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builderFactory", "org/jetbrains/kotlin/codegen/ClassFileFactory", "<init>"));
        }
        this.generators = new LinkedHashMap<String, OutAndSourceFileList>();
        this.isDone = false;
        this.packagePartSourceFiles = new HashSet<File>();
        this.partsGroupedByPackage = new LinkedHashMap<String, PackageParts>();
        this.state = state;
        this.builderFactory = builderFactory;
    }

    @NotNull
    public ClassBuilder newVisitor(@NotNull JvmDeclarationOrigin origin, @NotNull Type asmType, @NotNull PsiFile sourceFile) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "org/jetbrains/kotlin/codegen/ClassFileFactory", "newVisitor"));
        }
        if (asmType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmType", "org/jetbrains/kotlin/codegen/ClassFileFactory", "newVisitor"));
        }
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "org/jetbrains/kotlin/codegen/ClassFileFactory", "newVisitor"));
        }
        ClassBuilder classBuilder2 = this.newVisitor(origin, asmType, Collections.singletonList(sourceFile));
        if (classBuilder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassFileFactory", "newVisitor"));
        }
        return classBuilder2;
    }

    @NotNull
    public ClassBuilder newVisitor(@NotNull JvmDeclarationOrigin origin, @NotNull Type asmType, @NotNull Collection<? extends PsiFile> sourceFiles) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "org/jetbrains/kotlin/codegen/ClassFileFactory", "newVisitor"));
        }
        if (asmType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmType", "org/jetbrains/kotlin/codegen/ClassFileFactory", "newVisitor"));
        }
        if (sourceFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFiles", "org/jetbrains/kotlin/codegen/ClassFileFactory", "newVisitor"));
        }
        String outputFilePath = asmType.getInternalName() + ".class";
        List<File> ioSourceFiles = ClassFileFactory.toIoFilesIgnoringNonPhysical(sourceFiles);
        this.state.getProgress().reportOutput(ioSourceFiles, new File(outputFilePath));
        ClassBuilder answer = this.builderFactory.newClassBuilder(origin);
        this.generators.put(outputFilePath, new ClassBuilderAndSourceFileList(answer, ioSourceFiles));
        ClassBuilder classBuilder2 = answer;
        if (classBuilder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassFileFactory", "newVisitor"));
        }
        return classBuilder2;
    }

    void done() {
        if (!this.isDone) {
            this.isDone = true;
            this.writeModuleMappings();
        }
    }

    public void releaseGeneratedOutput() {
        this.generators.clear();
    }

    private void writeModuleMappings() {
        final JvmPackageTable.PackageTable.Builder builder = JvmPackageTable.PackageTable.newBuilder();
        String outputFilePath = JvmCodegenUtil.getMappingFileName(this.state.getModuleName());
        SmartList parts = new SmartList(this.partsGroupedByPackage.values());
        for (PackageParts part : ClassFileUtilsKt.addCompiledPartsAndSort((List<PackageParts>)parts, this.state)) {
            PackageParts.Companion.serialize(part, builder);
        }
        if (builder.getPackagePartsCount() != 0) {
            this.state.getProgress().reportOutput(this.packagePartSourceFiles, new File(outputFilePath));
            this.generators.put(outputFilePath, new OutAndSourceFileList(CollectionsKt.toList(this.packagePartSourceFiles)){

                @Override
                public byte[] asBytes(ClassBuilderFactory factory2) {
                    try {
                        ByteArrayOutputStream moduleMapping = new ByteArrayOutputStream(4096);
                        DataOutputStream dataOutStream = new DataOutputStream((OutputStream)moduleMapping);
                        int[] version = JvmMetadataVersion.INSTANCE.toArray();
                        dataOutStream.writeInt(version.length);
                        for (int number : version) {
                            dataOutStream.writeInt(number);
                        }
                        builder.build().writeTo((OutputStream)dataOutStream);
                        dataOutStream.flush();
                        return moduleMapping.toByteArray();
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public String asText(ClassBuilderFactory factory2) {
                    try {
                        return new String(this.asBytes(factory2), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    @Override
    @NotNull
    public List<OutputFile> asList() {
        this.done();
        List<OutputFile> list2 = this.getCurrentOutput();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassFileFactory", "asList"));
        }
        return list2;
    }

    @NotNull
    public List<OutputFile> getCurrentOutput() {
        List list2 = ContainerUtil.map(this.generators.keySet(), (Function)new Function<String, OutputFile>(){

            public OutputFile fun(String relativeClassFilePath) {
                return new OutputClassFile(relativeClassFilePath);
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassFileFactory", "getCurrentOutput"));
        }
        return list2;
    }

    @Override
    @Nullable
    public OutputFile get(@NotNull String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "org/jetbrains/kotlin/codegen/ClassFileFactory", "get"));
        }
        return this.generators.containsKey(relativePath) ? new OutputClassFile(relativePath) : null;
    }

    @NotNull
    public String createText() {
        StringBuilder answer = new StringBuilder();
        for (OutputFile file2 : this.asList()) {
            answer.append("@").append(file2.getRelativePath()).append('\n');
            answer.append(file2.asText());
        }
        String string = answer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassFileFactory", "createText"));
        }
        return string;
    }

    @NotNull
    public Map<String, String> createTextForEachFile() {
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        for (OutputFile file2 : this.asList()) {
            answer.put(file2.getRelativePath(), file2.asText());
        }
        LinkedHashMap<String, String> linkedHashMap = answer;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassFileFactory", "createTextForEachFile"));
        }
        return linkedHashMap;
    }

    @NotNull
    public PackageCodegen forPackage(@NotNull FqName fqName2, @NotNull Collection<KtFile> files) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/codegen/ClassFileFactory", "forPackage"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/codegen/ClassFileFactory", "forPackage"));
        }
        assert (!this.isDone) : "Already done!";
        this.registerPackagePartSourceFiles(files);
        PackageCodegen packageCodegen = new PackageCodegen(this.state, files, fqName2, this.buildNewPackagePartRegistry(fqName2));
        if (packageCodegen == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassFileFactory", "forPackage"));
        }
        return packageCodegen;
    }

    @NotNull
    public MultifileClassCodegen forMultifileClass(@NotNull FqName facadeFqName, @NotNull Collection<KtFile> files) {
        if (facadeFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facadeFqName", "org/jetbrains/kotlin/codegen/ClassFileFactory", "forMultifileClass"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/codegen/ClassFileFactory", "forMultifileClass"));
        }
        assert (!this.isDone) : "Already done!";
        this.registerPackagePartSourceFiles(files);
        MultifileClassCodegen multifileClassCodegen = new MultifileClassCodegen(this.state, files, facadeFqName, this.buildNewPackagePartRegistry(facadeFqName.parent()));
        if (multifileClassCodegen == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassFileFactory", "forMultifileClass"));
        }
        return multifileClassCodegen;
    }

    private PackagePartRegistry buildNewPackagePartRegistry(@NotNull FqName packageFqName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/codegen/ClassFileFactory", "buildNewPackagePartRegistry"));
        }
        final String packageFqNameAsString = packageFqName.asString();
        return new PackagePartRegistry(){

            @Override
            public void addPart(@NotNull String partShortName) {
                if (partShortName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partShortName", "org/jetbrains/kotlin/codegen/ClassFileFactory$3", "addPart"));
                }
                ((PackageParts)MapsKt.getOrPut((Map)ClassFileFactory.this.partsGroupedByPackage, (Object)packageFqNameAsString, (Function0)new Function0<PackageParts>(){

                    public PackageParts invoke() {
                        return new PackageParts(packageFqNameAsString);
                    }
                })).getParts().add(partShortName);
            }
        };
    }

    public void registerPackagePartSourceFiles(Collection<KtFile> files) {
        this.packagePartSourceFiles.addAll(ClassFileFactory.toIoFilesIgnoringNonPhysical(PackagePartClassUtils.getFilesWithCallables(files)));
    }

    @NotNull
    private static List<File> toIoFilesIgnoringNonPhysical(@NotNull Collection<? extends PsiFile> psiFiles) {
        if (psiFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFiles", "org/jetbrains/kotlin/codegen/ClassFileFactory", "toIoFilesIgnoringNonPhysical"));
        }
        ArrayList result2 = Lists.newArrayList();
        for (PsiFile psiFile : psiFiles) {
            VirtualFile virtualFile2 = psiFile.getVirtualFile();
            if (virtualFile2 == null) continue;
            result2.add(new File(virtualFile2.getPath()));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassFileFactory", "toIoFilesIgnoringNonPhysical"));
        }
        return arrayList;
    }

    public void removeClasses(Set<String> classNamesToRemove) {
        for (String classInternalName : classNamesToRemove) {
            this.generators.remove(classInternalName + ".class");
        }
    }

    public List<KtFile> getInputFiles() {
        return this.state.getFiles();
    }

    private static abstract class OutAndSourceFileList {
        protected final List<File> sourceFiles;

        private OutAndSourceFileList(List<File> sourceFiles) {
            this.sourceFiles = sourceFiles;
        }

        public abstract byte[] asBytes(ClassBuilderFactory var1);

        public abstract String asText(ClassBuilderFactory var1);
    }

    private static final class ClassBuilderAndSourceFileList
    extends OutAndSourceFileList {
        private final ClassBuilder classBuilder;

        private ClassBuilderAndSourceFileList(ClassBuilder classBuilder2, List<File> sourceFiles) {
            super(sourceFiles);
            this.classBuilder = classBuilder2;
        }

        @Override
        public byte[] asBytes(ClassBuilderFactory factory2) {
            return factory2.asBytes(this.classBuilder);
        }

        @Override
        public String asText(ClassBuilderFactory factory2) {
            return factory2.asText(this.classBuilder);
        }
    }

    private class OutputClassFile
    implements OutputFile {
        private final String relativeClassFilePath;

        public OutputClassFile(String relativeClassFilePath) {
            this.relativeClassFilePath = relativeClassFilePath;
        }

        @Override
        @NotNull
        public String getRelativePath() {
            String string = this.relativeClassFilePath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassFileFactory$OutputClassFile", "getRelativePath"));
            }
            return string;
        }

        @Override
        @NotNull
        public List<File> getSourceFiles() {
            OutAndSourceFileList pair2 = (OutAndSourceFileList)ClassFileFactory.this.generators.get(this.relativeClassFilePath);
            if (pair2 == null) {
                throw new IllegalStateException("No record for binary file " + this.relativeClassFilePath);
            }
            List<File> list2 = pair2.sourceFiles;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassFileFactory$OutputClassFile", "getSourceFiles"));
            }
            return list2;
        }

        @Override
        @NotNull
        public byte[] asByteArray() {
            byte[] byArray;
            try {
                byArray = ((OutAndSourceFileList)ClassFileFactory.this.generators.get(this.relativeClassFilePath)).asBytes(ClassFileFactory.this.builderFactory);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Error generating class file " + this.toString() + ": " + e.getMessage(), e);
            }
            if (byArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassFileFactory$OutputClassFile", "asByteArray"));
            }
            return byArray;
        }

        @Override
        @NotNull
        public String asText() {
            String string;
            try {
                string = ((OutAndSourceFileList)ClassFileFactory.this.generators.get(this.relativeClassFilePath)).asText(ClassFileFactory.this.builderFactory);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Error generating class file " + this.toString() + ": " + e.getMessage(), e);
            }
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassFileFactory$OutputClassFile", "asText"));
            }
            return string;
        }

        @NotNull
        public String toString() {
            String string = this.getRelativePath() + " (compiled from " + this.getSourceFiles() + ")";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassFileFactory$OutputClassFile", "toString"));
            }
            return string;
        }
    }
}

