/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.handlers;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.completion.KeywordLookupObject;
import org.jetbrains.kotlin.idea.core.GenerateUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0014\u0010\u0012\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0002\u001a!\u0010\u0014\u001a\u0004\u0018\u00010\r*\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0018\u001a\u001a\u0010\u0019\u001a\u00020\b*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u001a\u0010\u001a\u001a\u00020\b*\u00020\u001b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0005\u001a\u0012\u0010\u001c\u001a\u00020\r*\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\r\u001a\u0012\u0010\u001e\u001a\u00020\r*\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\r\u001a\u0014\u0010\u001f\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0002\u00a8\u0006 "}, d2={"createKeywordConstructLookupElement", "Lcom/intellij/codeInsight/lookup/LookupElement;", "project", "Lcom/intellij/openapi/project/Project;", "keyword", "", "fileTextToReformat", "trimSpacesAroundCaret", "", "detectIndent", "text", "", "offset", "", "surroundWithBracesIfInStringTemplate", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "indentLinesAfterFirst", "indent", "indexOfSkippingSpace", "c", "", "startIndex", "(Ljava/lang/CharSequence;CI)Ljava/lang/Integer;", "isCharAt", "isTextAt", "Lcom/intellij/openapi/editor/Document;", "skipSpaces", "index", "skipSpacesAndLineBreaks", "unindent", "idea-completion"})
public final class HandlerUtilsKt {
    public static final void surroundWithBracesIfInStringTemplate(@NotNull InsertionContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        int startOffset = context.getStartOffset();
        Document document = context.getDocument();
        if (startOffset > 0 && document.getCharsSequence().charAt(startOffset - 1) == '$') {
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)context.getProject());
            psiDocumentManager.commitAllDocuments();
            PsiElement psiElement = context.getFile().findElementAt(startOffset - 1);
            if (Intrinsics.areEqual((Object)(psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null), (Object)((Object)KtTokens.SHORT_TEMPLATE_ENTRY_START))) {
                psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
                document.insertString(startOffset, (CharSequence)"{");
                context.getOffsetMap().addOffset(CompletionInitializationContext.START_OFFSET, startOffset + 1);
                int tailOffset = context.getTailOffset();
                document.insertString(tailOffset, (CharSequence)"}");
                context.setTailOffset(tailOffset);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Integer indexOfSkippingSpace(@NotNull CharSequence $receiver, char c, int startIndex) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int n = startIndex;
        int n2 = $receiver.length() - 1;
        if (n <= n2) {
            while (true) {
                void i;
                char currentChar;
                if (c == (currentChar = $receiver.charAt((int)i))) {
                    return (int)i;
                }
                if (currentChar != ' ' && currentChar != '\t') {
                    return null;
                }
                if (i == n2) break;
                ++i;
            }
        }
        return null;
    }

    public static final int skipSpaces(@NotNull CharSequence $receiver, int index2) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Iterable $receiver$iv = (Iterable)new IntRange(index2, $receiver.length() - 1);
            for (Object element$iv : $receiver$iv) {
                int it = ((Number)element$iv).intValue();
                char c = $receiver.charAt(it);
                if (!(c != ' ' && c != '\t')) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Integer n = v0;
        return n != null ? ((Number)n).intValue() : $receiver.length();
    }

    public static final int skipSpacesAndLineBreaks(@NotNull CharSequence $receiver, int index2) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Iterable $receiver$iv = (Iterable)new IntRange(index2, $receiver.length() - 1);
            for (Object element$iv : $receiver$iv) {
                int it = ((Number)element$iv).intValue();
                char c = $receiver.charAt(it);
                if (!(c != ' ' && c != '\t' && c != '\n' && c != '\r')) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Integer n = v0;
        return n != null ? ((Number)n).intValue() : $receiver.length();
    }

    public static final boolean isCharAt(@NotNull CharSequence $receiver, int offset2, char c) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return offset2 < $receiver.length() && $receiver.charAt(offset2) == c;
    }

    public static final boolean isTextAt(@NotNull Document $receiver, int offset2, @NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        return offset2 + text2.length() <= $receiver.getTextLength() && Intrinsics.areEqual((Object)$receiver.getText(new TextRange(offset2, offset2 + text2.length())), (Object)text2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final LookupElement createKeywordConstructLookupElement(@NotNull Project project, @NotNull String keyword, @NotNull String fileTextToReformat, boolean trimSpacesAroundCaret) {
        String string;
        String string2;
        String string3;
        void tailAfterCaret;
        void tailBeforeCaret;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)keyword, (String)"keyword");
        Intrinsics.checkParameterIsNotNull((Object)fileTextToReformat, (String)"fileTextToReformat");
        KtFile file2 = new KtPsiFactory(project).createFile(fileTextToReformat);
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)file2);
        String newFileText = file2.getText();
        int keywordOffset = StringsKt.indexOf$default((CharSequence)newFileText, (String)keyword, (int)0, (boolean)false, (int)6, null);
        boolean bl = keywordOffset >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string4 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string4));
        }
        int keywordEndOffset = keywordOffset + keyword.length();
        String caretPlaceHolder = "caret";
        int caretOffset = StringsKt.indexOf$default((CharSequence)newFileText, (String)caretPlaceHolder, (int)0, (boolean)false, (int)6, null);
        boolean bl2 = caretOffset >= 0;
        if (_Assertions.ENABLED && !bl2) {
            String string5 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string5));
        }
        bl2 = caretOffset >= keywordEndOffset;
        if (_Assertions.ENABLED && !bl2) {
            String string6 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string6));
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        String string7 = newFileText;
        Object object = objectRef;
        String string8 = string7;
        if (string8 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string9 = string8.substring(keywordEndOffset, caretOffset);
        Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string10 = string9;
        object.element = string10;
        string7 = new Ref.ObjectRef();
        String string11 = newFileText;
        int n = caretOffset + caretPlaceHolder.length();
        object = string7;
        String string12 = string11;
        if (string12 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string13 = string12.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"(this as java.lang.String).substring(startIndex)");
        string10 = string13;
        object.element = string10;
        if (trimSpacesAroundCaret) {
            string11 = (String)tailBeforeCaret.element;
            object = tailBeforeCaret;
            String string14 = string11;
            if (string14 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string10 = ((Object)StringsKt.trimEnd((CharSequence)string14)).toString();
            object.element = string10;
            string11 = (String)tailAfterCaret.element;
            object = tailAfterCaret;
            String string15 = string11;
            if (string15 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string10 = ((Object)StringsKt.trimStart((CharSequence)string15)).toString();
            object.element = string10;
        }
        CharSequence charSequence = newFileText;
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"newFileText");
        String indent = HandlerUtilsKt.detectIndent(charSequence, keywordOffset);
        tailBeforeCaret.element = HandlerUtilsKt.unindent((String)tailBeforeCaret.element, indent);
        tailAfterCaret.element = HandlerUtilsKt.unindent((String)tailAfterCaret.element, indent);
        StringBuilder stringBuilder = new StringBuilder();
        if (StringsKt.contains$default((CharSequence)((String)tailBeforeCaret.element), (char)'\n', (boolean)false, (int)2, null)) {
            string3 = StringsKt.replace$default((String)((String)tailBeforeCaret.element), (String)"\n", (String)"", (boolean)false, (int)4, null);
            object = stringBuilder;
            String string16 = string3;
            if (string16 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string10 = ((Object)StringsKt.trimEnd((CharSequence)string16)).toString();
            stringBuilder = object;
            string2 = string10;
        } else {
            string2 = (String)tailBeforeCaret.element;
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("...");
        if (StringsKt.contains$default((CharSequence)((String)tailAfterCaret.element), (char)'\n', (boolean)false, (int)2, null)) {
            string3 = StringsKt.replace$default((String)((String)tailAfterCaret.element), (String)"\n", (String)"", (boolean)false, (int)4, null);
            object = stringBuilder2;
            String string17 = string3;
            if (string17 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string10 = ((Object)StringsKt.trimStart((CharSequence)string17)).toString();
            stringBuilder2 = object;
            string = string10;
        } else {
            string = (String)tailAfterCaret.element;
        }
        String tailText = stringBuilder2.append(string).toString();
        LookupElement lookupElement2 = (LookupElement)LookupElementBuilder.create((Object)new KeywordLookupObject(), (String)keyword).bold().withTailText(tailText).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(keyword, (Ref.ObjectRef)tailBeforeCaret, (Ref.ObjectRef)tailAfterCaret){
            final /* synthetic */ String $keyword;
            final /* synthetic */ Ref.ObjectRef $tailBeforeCaret;
            final /* synthetic */ Ref.ObjectRef $tailAfterCaret;

            public final void handleInsert(InsertionContext insertionContext, LookupElement lookupElement2) {
                if (insertionContext.getCompletionChar() == '\n' || insertionContext.getCompletionChar() == '\t') {
                    int offset2 = insertionContext.getTailOffset();
                    CharSequence charSequence = insertionContext.getDocument().getCharsSequence();
                    Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"insertionContext.document.charsSequence");
                    String newIndent = HandlerUtilsKt.access$detectIndent(charSequence, offset2 - this.$keyword.length());
                    String beforeCaret = HandlerUtilsKt.access$indentLinesAfterFirst((String)this.$tailBeforeCaret.element, newIndent);
                    String afterCaret = HandlerUtilsKt.access$indentLinesAfterFirst((String)this.$tailAfterCaret.element, newIndent);
                    insertionContext.getDocument().insertString(offset2, (CharSequence)(beforeCaret + afterCaret));
                    GenerateUtilKt.moveCaret$default(insertionContext.getEditor(), offset2 + beforeCaret.length(), null, 2, null);
                }
            }
            {
                this.$keyword = string;
                this.$tailBeforeCaret = objectRef;
                this.$tailAfterCaret = objectRef2;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)lookupElement2, (String)"LookupElementBuilder.cre\u2026          }\n            }");
        return lookupElement2;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ LookupElement createKeywordConstructLookupElement$default(Project project, String string, String string2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createKeywordConstructLookupElement");
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return HandlerUtilsKt.createKeywordConstructLookupElement(project, string, string2, bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final String detectIndent(CharSequence text2, int offset2) {
        CharSequence charSequence;
        block4: {
            CharSequence charSequence2 = text2;
            int n = 0;
            String $receiver$iv = StringsKt.substringAfterLast$default((String)((Object)charSequence2.subSequence(n, offset2)).toString(), (char)'\n', null, (int)2, null);
            n = 0;
            int n2 = $receiver$iv.length() - 1;
            if (n <= n2) {
                while (true) {
                    void index$iv;
                    char it;
                    if (!CharsKt.isWhitespace((char)(it = $receiver$iv.charAt((int)index$iv)))) {
                        String string = $receiver$iv;
                        int n3 = 0;
                        String string2 = string;
                        if (string2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string3 = string2.substring(n3, (int)index$iv);
                        charSequence = string3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        break block4;
                    }
                    if (index$iv == n2) break;
                    ++index$iv;
                }
            }
            charSequence = charSequence2;
        }
        return charSequence;
    }

    private static final String indentLinesAfterFirst(@NotNull String $receiver, String indent) {
        String text2 = $receiver;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder $receiver2 = stringBuilder;
        List lines = StringsKt.lines((CharSequence)text2);
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)lines)) {
            int index2 = indexedValue.component1();
            String line = (String)indexedValue.component2();
            if (index2 > 0) {
                $receiver2.append(indent);
            }
            $receiver2.append(line);
            if (index2 == CollectionsKt.getLastIndex((List)lines)) continue;
            $receiver2.append('\n');
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private static final String unindent(@NotNull String $receiver, String indent) {
        String text2 = $receiver;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder $receiver2 = stringBuilder;
        List lines = StringsKt.lines((CharSequence)text2);
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)lines)) {
            int index2 = indexedValue.component1();
            String line = (String)indexedValue.component2();
            $receiver2.append(StringsKt.removePrefix((String)line, (CharSequence)indent));
            if (index2 == CollectionsKt.getLastIndex((List)lines)) continue;
            $receiver2.append('\n');
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public static final /* synthetic */ String access$detectIndent(@NotNull CharSequence text2, int offset2) {
        return HandlerUtilsKt.detectIndent(text2, offset2);
    }

    @NotNull
    public static final /* synthetic */ String access$indentLinesAfterFirst(@NotNull String $receiver, @NotNull String indent) {
        return HandlerUtilsKt.indentLinesAfterFirst($receiver, indent);
    }
}

