/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.plugins.gradle.frameworkSupport.BuildScriptDataBuilder;
import org.jetbrains.plugins.gradle.frameworkSupport.GradleFrameworkSupportProvider;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/GradleKotlinJavaFrameworkSupportProvider;", "Lorg/jetbrains/plugins/gradle/frameworkSupport/GradleFrameworkSupportProvider;", "()V", "addSupport", "", "module", "Lcom/intellij/openapi/module/Module;", "rootModel", "Lcom/intellij/openapi/roots/ModifiableRootModel;", "modifiableModelsProvider", "Lcom/intellij/openapi/roots/ModifiableModelsProvider;", "buildScriptData", "Lorg/jetbrains/plugins/gradle/frameworkSupport/BuildScriptDataBuilder;", "getFrameworkType", "Lcom/intellij/framework/FrameworkTypeEx;", "idea"})
public final class GradleKotlinJavaFrameworkSupportProvider
extends GradleFrameworkSupportProvider {
    @NotNull
    public FrameworkTypeEx getFrameworkType() {
        return new FrameworkTypeEx(this, "KOTLIN"){
            final /* synthetic */ GradleKotlinJavaFrameworkSupportProvider this$0;

            @NotNull
            public Icon getIcon() {
                Icon icon = KotlinIcons.SMALL_LOGO;
                Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"KotlinIcons.SMALL_LOGO");
                return icon;
            }

            @NotNull
            public String getPresentableName() {
                return "Kotlin (Java)";
            }

            @NotNull
            public FrameworkSupportInModuleProvider createProvider() {
                return (FrameworkSupportInModuleProvider)this.this$0;
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
    }

    public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel, @NotNull ModifiableModelsProvider modifiableModelsProvider, @NotNull BuildScriptDataBuilder buildScriptData) {
        String additionalRepository;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)rootModel, (String)"rootModel");
        Intrinsics.checkParameterIsNotNull((Object)modifiableModelsProvider, (String)"modifiableModelsProvider");
        Intrinsics.checkParameterIsNotNull((Object)buildScriptData, (String)"buildScriptData");
        String kotlinVersion = KotlinRuntimeLibraryUtilKt.bundledRuntimeVersion$default(null, 1, null);
        if (Intrinsics.areEqual((Object)kotlinVersion, (Object)"@snapshot@")) {
            kotlinVersion = "0.1-SNAPSHOT";
            string = KotlinWithGradleConfigurator.SNAPSHOT_REPOSITORY;
        } else {
            string = additionalRepository = ConfigureKotlinInProjectUtilsKt.isEap(kotlinVersion) ? KotlinWithGradleConfigurator.EAP_REPOSITORY : (String)null;
        }
        if (additionalRepository != null) {
            String oneLineRepository = StringsKt.replace$default((String)additionalRepository, (char)'\n', (char)' ', (boolean)false, (int)4, null);
            buildScriptData.addBuildscriptRepositoriesDefinition(oneLineRepository);
            buildScriptData.addRepositoriesDefinition("mavenCentral()");
            buildScriptData.addRepositoriesDefinition(oneLineRepository);
        }
        buildScriptData.addPluginDefinition("apply plugin: 'kotlin'").addBuildscriptRepositoriesDefinition("mavenCentral()").addRepositoriesDefinition("mavenCentral()").addBuildscriptPropertyDefinition("ext.kotlin_version = '" + kotlinVersion + "'").addDependencyNotation("compile \"org.jetbrains.kotlin:kotlin-stdlib:$kotlin_version\"").addBuildscriptDependencyNotation("classpath \"org.jetbrains.kotlin:kotlin-gradle-plugin:$kotlin_version\"");
    }
}

