/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollectorKt;
import org.jetbrains.kotlin.idea.framework.ui.ConfigureDialogWithModulesAndVersion;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public abstract class KotlinWithGradleConfigurator
implements KotlinProjectConfigurator {
    private static final String VERSION_TEMPLATE = "$VERSION$";
    public static final String GROUP_ID = "org.jetbrains.kotlin";
    public static final String GRADLE_PLUGIN_ID = "kotlin-gradle-plugin";
    protected static final String CLASSPATH = "classpath \"org.jetbrains.kotlin:kotlin-gradle-plugin:$kotlin_version\"";
    protected static final String SNAPSHOT_REPOSITORY = "maven {\nurl '" + ConfigureKotlinInProjectUtilsKt.SNAPSHOT_REPOSITORY.getUrl() + "'\n}";
    protected static final String EAP_REPOSITORY = "maven {\nurl '" + ConfigureKotlinInProjectUtilsKt.EAP_REPOSITORY.getUrl() + "'\n}";
    private static final String MAVEN_CENTRAL = "mavenCentral()\n";
    private static final String JCENTER = "jcenter()\n";
    public static final String LIBRARY = "compile \"org.jetbrains.kotlin:kotlin-stdlib:$kotlin_version\"";
    protected static final String SOURCE_SET = "main.java.srcDirs += 'src/main/kotlin'\n";
    private static final String VERSION = String.format("ext.kotlin_version = '%s'", "$VERSION$");

    @Override
    public boolean isConfigured(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "isConfigured"));
        }
        if (ConfigureKotlinInProjectUtilsKt.hasKotlinJvmRuntimeInScope(module)) {
            return true;
        }
        GroovyFile moduleGradleFile = KotlinWithGradleConfigurator.getBuildGradleFile(module.getProject(), KotlinWithGradleConfigurator.getModuleFilePath(module));
        if (moduleGradleFile != null && this.isFileConfigured(moduleGradleFile)) {
            return true;
        }
        GroovyFile projectGradleFile = KotlinWithGradleConfigurator.getBuildGradleFile(module.getProject(), KotlinWithGradleConfigurator.getTopLevelProjectFilePath(module.getProject()));
        return projectGradleFile != null && this.isFileConfigured(projectGradleFile);
    }

    private boolean isFileConfigured(GroovyFile projectGradleFile) {
        String fileText = projectGradleFile.getText();
        return KotlinWithGradleConfigurator.containsDirective(fileText, this.getApplyPluginDirective()) && fileText.contains(LIBRARY);
    }

    private static boolean containsDirective(@NotNull String fileText, @NotNull String directive) {
        if (fileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "containsDirective"));
        }
        if (directive == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directive", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "containsDirective"));
        }
        return fileText.contains(directive) || fileText.contains(directive.replace("\"", "'")) || fileText.contains(directive.replace("'", "\""));
    }

    @Override
    public void configure(final @NotNull Project project, Collection<Module> excludeModules) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "configure"));
        }
        final ConfigureDialogWithModulesAndVersion dialog2 = new ConfigureDialogWithModulesAndVersion(project, this, excludeModules);
        dialog2.show();
        if (!dialog2.isOK()) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                boolean isModified;
                NotificationMessageCollector collector2 = NotificationMessageCollectorKt.createConfigureKotlinNotificationCollector(project);
                HashSet<GroovyFile> changedFiles = new HashSet<GroovyFile>();
                GroovyFile projectGradleFile = KotlinWithGradleConfigurator.getBuildGradleFile(project, KotlinWithGradleConfigurator.getTopLevelProjectFilePath(project));
                if (projectGradleFile != null && KotlinWithGradleConfigurator.canConfigureFile(projectGradleFile) && (isModified = KotlinWithGradleConfigurator.this.changeGradleFile(projectGradleFile, true, dialog2.getKotlinVersion(), collector2))) {
                    changedFiles.add(projectGradleFile);
                }
                for (Module module : dialog2.getModulesToConfigure()) {
                    GroovyFile file2 = KotlinWithGradleConfigurator.getBuildGradleFile(project, KotlinWithGradleConfigurator.getModuleFilePath(module));
                    if (file2 != null && KotlinWithGradleConfigurator.canConfigureFile(file2)) {
                        boolean isModified2 = KotlinWithGradleConfigurator.this.changeGradleFile(file2, false, dialog2.getKotlinVersion(), collector2);
                        if (!isModified2) continue;
                        changedFiles.add(file2);
                        continue;
                    }
                    KotlinWithGradleConfigurator.showErrorMessage(project, "Cannot find build.gradle file for module " + module.getName());
                }
                for (GroovyFile file3 : changedFiles) {
                    OpenFileAction.openFile((VirtualFile)file3.getVirtualFile(), (Project)project);
                }
                collector2.showNotification();
            }
        }, "Configure Kotlin", null);
    }

    public static void addKotlinLibraryToModule(final Module module, final DependencyScope scope2, final ExternalLibraryDescriptor libraryDescriptor) {
        String gradleFilePath = KotlinWithGradleConfigurator.getModuleFilePath(module);
        final GroovyFile gradleFile = KotlinWithGradleConfigurator.getBuildGradleFile(module.getProject(), gradleFilePath);
        if (gradleFile != null && KotlinWithGradleConfigurator.canConfigureFile(gradleFile)) {
            new WriteCommandAction(gradleFile.getProject(), new PsiFile[0]){

                protected void run(@NotNull Result result2) {
                    String groovyScope;
                    if (result2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator$2", "run"));
                    }
                    switch (scope2) {
                        case COMPILE: {
                            groovyScope = "compile";
                            break;
                        }
                        case TEST: {
                            if (KotlinPluginUtil.isAndroidGradleModule(module)) {
                                groovyScope = "compile";
                                break;
                            }
                            groovyScope = "testCompile";
                            break;
                        }
                        case RUNTIME: {
                            groovyScope = "runtime";
                            break;
                        }
                        case PROVIDED: {
                            groovyScope = "compile";
                            break;
                        }
                        default: {
                            groovyScope = "compile";
                        }
                    }
                    String dependencyString = String.format("%s \"%s:%s:%s\"", groovyScope, libraryDescriptor.getLibraryGroupId(), libraryDescriptor.getLibraryArtifactId(), libraryDescriptor.getMaxVersion());
                    GrClosableBlock dependenciesBlock = KotlinWithGradleConfigurator.getDependenciesBlock((GrStatementOwner)gradleFile);
                    KotlinWithGradleConfigurator.addLastExpressionInBlockIfNeeded(dependencyString, dependenciesBlock);
                    CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)gradleFile);
                }
            }.execute();
            VirtualFile virtualFile2 = gradleFile.getVirtualFile();
            if (virtualFile2 != null) {
                NotificationMessageCollectorKt.createConfigureKotlinNotificationCollector(gradleFile.getProject()).addMessage(virtualFile2.getPath() + " was modified").showNotification();
            }
        }
    }

    @Nullable
    public static String getKotlinStdlibVersion(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getKotlinStdlibVersion"));
        }
        String gradleFilePath = KotlinWithGradleConfigurator.getModuleFilePath(module);
        GroovyFile gradleFile = KotlinWithGradleConfigurator.getBuildGradleFile(module.getProject(), gradleFilePath);
        if (gradleFile == null) {
            return null;
        }
        String versionProperty = "$kotlin_version";
        GrClosableBlock block = KotlinWithGradleConfigurator.getBuildScriptBlock((GrStatementOwner)gradleFile);
        if (block.getText().contains("ext.kotlin_version = ")) {
            return versionProperty;
        }
        GrStatement[] dependencies2 = KotlinWithGradleConfigurator.getDependenciesBlock((GrStatementOwner)gradleFile).getStatements();
        String stdlibArtifactPrefix = "org.jetbrains.kotlin:kotlin-stdlib:";
        for (GrStatement dependency : dependencies2) {
            String dependencyText = dependency.getText();
            int startIndex = dependencyText.indexOf(stdlibArtifactPrefix) + stdlibArtifactPrefix.length();
            int endIndex = dependencyText.length() - 1;
            if (startIndex == -1 || endIndex == -1) continue;
            return dependencyText.substring(startIndex, endIndex);
        }
        return null;
    }

    protected static boolean addElementsToProjectFile(@NotNull GroovyFile file2, @NotNull String version) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "addElementsToProjectFile"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "addElementsToProjectFile"));
        }
        GrClosableBlock buildScriptBlock = KotlinWithGradleConfigurator.getBuildScriptBlock((GrStatementOwner)file2);
        boolean wasModified = KotlinWithGradleConfigurator.addFirstExpressionInBlockIfNeeded(VERSION.replace(VERSION_TEMPLATE, version), buildScriptBlock);
        GrClosableBlock buildScriptRepositoriesBlock = KotlinWithGradleConfigurator.getBuildScriptRepositoriesBlock((GrStatementOwner)file2);
        if (ConfigureKotlinInProjectUtilsKt.isSnapshot(version)) {
            wasModified |= KotlinWithGradleConfigurator.addLastExpressionInBlockIfNeeded(SNAPSHOT_REPOSITORY, buildScriptRepositoriesBlock);
        } else if (ConfigureKotlinInProjectUtilsKt.isEap(version)) {
            wasModified |= KotlinWithGradleConfigurator.addLastExpressionInBlockIfNeeded(EAP_REPOSITORY, buildScriptRepositoriesBlock);
        } else if (!KotlinWithGradleConfigurator.isRepositoryConfigured(buildScriptRepositoriesBlock)) {
            wasModified |= KotlinWithGradleConfigurator.addLastExpressionInBlockIfNeeded(MAVEN_CENTRAL, buildScriptRepositoriesBlock);
        }
        GrClosableBlock buildScriptDependenciesBlock = KotlinWithGradleConfigurator.getBuildScriptDependenciesBlock((GrStatementOwner)file2);
        return wasModified |= KotlinWithGradleConfigurator.addLastExpressionInBlockIfNeeded(CLASSPATH, buildScriptDependenciesBlock);
    }

    protected boolean addElementsToModuleFile(@NotNull GroovyFile file2, @NotNull String version) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "addElementsToModuleFile"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "addElementsToModuleFile"));
        }
        boolean wasModified = false;
        if (!KotlinWithGradleConfigurator.containsDirective(file2.getText(), this.getApplyPluginDirective())) {
            GrExpression apply2 = GroovyPsiElementFactory.getInstance((Project)file2.getProject()).createExpressionFromText((CharSequence)this.getApplyPluginDirective());
            GrApplicationStatement applyStatement = KotlinWithGradleConfigurator.getApplyStatement(file2);
            if (applyStatement != null) {
                file2.addAfter((PsiElement)apply2, (PsiElement)applyStatement);
                wasModified = true;
            } else {
                GrClosableBlock buildScript = KotlinWithGradleConfigurator.getBlockByName((PsiElement)file2, "buildscript");
                if (buildScript != null) {
                    file2.addAfter((PsiElement)apply2, buildScript.getParent());
                    wasModified = true;
                } else {
                    GrStatement[] statements = file2.getStatements();
                    if (statements.length > 0) {
                        file2.addAfter((PsiElement)apply2, (PsiElement)statements[statements.length - 1]);
                    } else {
                        file2.addAfter((PsiElement)apply2, file2.getFirstChild());
                    }
                    wasModified = true;
                }
            }
        }
        GrClosableBlock repositoriesBlock = KotlinWithGradleConfigurator.getRepositoriesBlock((GrStatementOwner)file2);
        if (ConfigureKotlinInProjectUtilsKt.isSnapshot(version)) {
            wasModified |= KotlinWithGradleConfigurator.addLastExpressionInBlockIfNeeded(SNAPSHOT_REPOSITORY, repositoriesBlock);
        } else if (ConfigureKotlinInProjectUtilsKt.isEap(version)) {
            wasModified |= KotlinWithGradleConfigurator.addLastExpressionInBlockIfNeeded(EAP_REPOSITORY, repositoriesBlock);
        } else if (!KotlinWithGradleConfigurator.isRepositoryConfigured(repositoriesBlock)) {
            wasModified |= KotlinWithGradleConfigurator.addLastExpressionInBlockIfNeeded(MAVEN_CENTRAL, repositoriesBlock);
        }
        GrClosableBlock dependenciesBlock = KotlinWithGradleConfigurator.getDependenciesBlock((GrStatementOwner)file2);
        wasModified |= KotlinWithGradleConfigurator.addExpressionInBlockIfNeeded(LIBRARY, dependenciesBlock, false);
        return wasModified |= this.addSourceSetsBlock(file2);
    }

    private static boolean isRepositoryConfigured(GrClosableBlock repositoriesBlock) {
        return repositoriesBlock.getText().contains(MAVEN_CENTRAL) || repositoriesBlock.getText().contains(JCENTER);
    }

    protected abstract String getApplyPluginDirective();

    protected abstract boolean addSourceSetsBlock(@NotNull GroovyFile var1);

    protected abstract boolean addElementsToFile(@NotNull GroovyFile var1, boolean var2, @NotNull String var3);

    private static boolean canConfigureFile(@NotNull GroovyFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "canConfigureFile"));
        }
        return WritingAccessProvider.isPotentiallyWritable((VirtualFile)file2.getVirtualFile(), null);
    }

    @Nullable
    private static GroovyFile getBuildGradleFile(Project project, @Nullable String path) {
        if (path == null) {
            return null;
        }
        VirtualFile file2 = VfsUtil.findFileByIoFile((File)new File(path), (boolean)true);
        if (file2 == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
        if (!(psiFile instanceof GroovyFile)) {
            return null;
        }
        return (GroovyFile)psiFile;
    }

    @NotNull
    private static String getTopLevelProjectFilePath(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getTopLevelProjectFilePath"));
        }
        String string = project.getBasePath() + "/" + "build.gradle";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getTopLevelProjectFilePath"));
        }
        return string;
    }

    @Nullable
    private static String getModuleFilePath(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getModuleFilePath"));
        }
        String moduleDir = new File(module.getModuleFilePath()).getParent();
        File buildGradleFile = new File(moduleDir + "/" + "build.gradle");
        if (buildGradleFile.exists()) {
            return buildGradleFile.getPath();
        }
        for (VirtualFile file2 : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            buildGradleFile = new File(file2.getPath() + "/" + "build.gradle");
            if (!buildGradleFile.exists()) continue;
            return buildGradleFile.getPath();
        }
        return null;
    }

    protected boolean changeGradleFile(final @NotNull GroovyFile groovyFile, final boolean isTopLevelProjectFile, final @NotNull String version, @NotNull NotificationMessageCollector collector2) {
        if (groovyFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groovyFile", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "changeGradleFile"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "changeGradleFile"));
        }
        if (collector2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "changeGradleFile"));
        }
        final boolean[] isModified = new boolean[]{false};
        new WriteCommandAction(groovyFile.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result result2) {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator$3", "run"));
                }
                isModified[0] = KotlinWithGradleConfigurator.this.addElementsToFile(groovyFile, isTopLevelProjectFile, version);
                CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)groovyFile);
            }
        }.execute();
        VirtualFile virtualFile2 = groovyFile.getVirtualFile();
        if (virtualFile2 != null && isModified[0]) {
            collector2.addMessage(virtualFile2.getPath() + " was modified");
        }
        return isModified[0];
    }

    @NotNull
    private static GrClosableBlock getDependenciesBlock(@NotNull GrStatementOwner file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getDependenciesBlock"));
        }
        GrClosableBlock grClosableBlock = KotlinWithGradleConfigurator.getBlockOrCreate(file2, "dependencies");
        if (grClosableBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getDependenciesBlock"));
        }
        return grClosableBlock;
    }

    @NotNull
    protected static GrClosableBlock getSourceSetsBlock(@NotNull GrStatementOwner parent2) {
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getSourceSetsBlock"));
        }
        GrClosableBlock grClosableBlock = KotlinWithGradleConfigurator.getBlockOrCreate(parent2, "sourceSets");
        if (grClosableBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getSourceSetsBlock"));
        }
        return grClosableBlock;
    }

    @NotNull
    private static GrClosableBlock getBuildScriptBlock(@NotNull GrStatementOwner file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getBuildScriptBlock"));
        }
        GrClosableBlock grClosableBlock = KotlinWithGradleConfigurator.getBlockOrCreate(file2, "buildscript");
        if (grClosableBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getBuildScriptBlock"));
        }
        return grClosableBlock;
    }

    @NotNull
    private static GrClosableBlock getBuildScriptDependenciesBlock(@NotNull GrStatementOwner file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getBuildScriptDependenciesBlock"));
        }
        GrClosableBlock buildScript = KotlinWithGradleConfigurator.getBuildScriptBlock(file2);
        GrClosableBlock grClosableBlock = KotlinWithGradleConfigurator.getBlockOrCreate((GrStatementOwner)buildScript, "dependencies");
        if (grClosableBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getBuildScriptDependenciesBlock"));
        }
        return grClosableBlock;
    }

    @NotNull
    private static GrClosableBlock getBuildScriptRepositoriesBlock(@NotNull GrStatementOwner file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getBuildScriptRepositoriesBlock"));
        }
        GrClosableBlock buildScript = KotlinWithGradleConfigurator.getBuildScriptBlock(file2);
        GrClosableBlock grClosableBlock = KotlinWithGradleConfigurator.getBlockOrCreate((GrStatementOwner)buildScript, "repositories");
        if (grClosableBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getBuildScriptRepositoriesBlock"));
        }
        return grClosableBlock;
    }

    @NotNull
    private static GrClosableBlock getRepositoriesBlock(@NotNull GrStatementOwner file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getRepositoriesBlock"));
        }
        GrClosableBlock grClosableBlock = KotlinWithGradleConfigurator.getBlockOrCreate(file2, "repositories");
        if (grClosableBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getRepositoriesBlock"));
        }
        return grClosableBlock;
    }

    @NotNull
    protected static GrClosableBlock getBlockOrCreate(@NotNull GrStatementOwner parent2, @NotNull String name2) {
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getBlockOrCreate"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getBlockOrCreate"));
        }
        GrClosableBlock block = KotlinWithGradleConfigurator.getBlockByName((PsiElement)parent2, name2);
        if (block == null) {
            GroovyPsiElementFactory factory2 = GroovyPsiElementFactory.getInstance((Project)parent2.getProject());
            GrExpression newBlock = factory2.createExpressionFromText((CharSequence)(name2 + "{\n}\n"));
            GrStatement[] statements = parent2.getStatements();
            if (statements.length > 0) {
                parent2.addAfter((PsiElement)newBlock, (PsiElement)statements[statements.length - 1]);
            } else {
                parent2.addAfter((PsiElement)newBlock, parent2.getFirstChild());
            }
            block = KotlinWithGradleConfigurator.getBlockByName((PsiElement)parent2, name2);
            assert (block != null) : "Block should be non-null because it is created";
        }
        GrClosableBlock grClosableBlock = block;
        if (grClosableBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getBlockOrCreate"));
        }
        return grClosableBlock;
    }

    protected static boolean addLastExpressionInBlockIfNeeded(@NotNull String text2, @NotNull GrClosableBlock block) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "addLastExpressionInBlockIfNeeded"));
        }
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "addLastExpressionInBlockIfNeeded"));
        }
        return KotlinWithGradleConfigurator.addExpressionInBlockIfNeeded(text2, block, false);
    }

    private static boolean addFirstExpressionInBlockIfNeeded(@NotNull String text2, @NotNull GrClosableBlock block) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "addFirstExpressionInBlockIfNeeded"));
        }
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "addFirstExpressionInBlockIfNeeded"));
        }
        return KotlinWithGradleConfigurator.addExpressionInBlockIfNeeded(text2, block, true);
    }

    @Nullable
    private static GrClosableBlock getBlockByName(@NotNull PsiElement parent2, @NotNull String name2) {
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getBlockByName"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getBlockByName"));
        }
        GrMethodCallExpression[] allExpressions = (GrMethodCallExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)parent2, GrMethodCallExpression.class);
        if (allExpressions != null) {
            for (GrMethodCallExpression expression2 : allExpressions) {
                String expressionText2;
                GrExpression invokedExpression = expression2.getInvokedExpression();
                if (expression2.getClosureArguments().length == 0 || !(expressionText2 = invokedExpression.getText()).equals(name2)) continue;
                return expression2.getClosureArguments()[0];
            }
        }
        return null;
    }

    private static boolean addExpressionInBlockIfNeeded(@NotNull String text2, @NotNull GrClosableBlock block, boolean isFirst) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "addExpressionInBlockIfNeeded"));
        }
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "addExpressionInBlockIfNeeded"));
        }
        if (block.getText().contains(text2)) {
            return false;
        }
        GrExpression newStatement = GroovyPsiElementFactory.getInstance((Project)block.getProject()).createExpressionFromText((CharSequence)text2);
        CodeStyleManager.getInstance((Project)block.getProject()).reformat((PsiElement)newStatement);
        GrStatement[] statements = block.getStatements();
        if (!isFirst && statements.length > 0) {
            GrStatement lastStatement = statements[statements.length - 1];
            if (lastStatement != null) {
                block.addAfter((PsiElement)newStatement, (PsiElement)lastStatement);
            }
        } else {
            PsiElement firstChild = block.getFirstChild();
            if (firstChild != null) {
                block.addAfter((PsiElement)newStatement, firstChild);
            }
        }
        return true;
    }

    @Nullable
    private static GrApplicationStatement getApplyStatement(@NotNull GroovyFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getApplyStatement"));
        }
        GrApplicationStatement[] applyStatement = (GrApplicationStatement[])PsiTreeUtil.getChildrenOfType((PsiElement)file2, GrApplicationStatement.class);
        if (applyStatement == null) {
            return null;
        }
        for (GrApplicationStatement callExpression2 : applyStatement) {
            GrExpression invokedExpression = callExpression2.getInvokedExpression();
            if (!invokedExpression.getText().equals("apply")) continue;
            return callExpression2;
        }
        return null;
    }

    private static void showErrorMessage(@NotNull Project project, @Nullable String message2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "showErrorMessage"));
        }
        Messages.showErrorDialog((Project)project, (String)("<html>Couldn't configure kotlin-gradle plugin automatically.<br/>" + (message2 != null ? message2 + "<br/>" : "") + "<br/>See manual installation instructions <a href=\"https://kotlinlang.org/docs/reference/using-gradle.html\">here</a>.</html>"), (String)"Configure Kotlin-Gradle Plugin");
    }
}

