/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.conversion.copy;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.conversion.copy.ConversionResult;
import org.jetbrains.kotlin.idea.conversion.copy.KotlinPasteFromJavaDialog;
import org.jetbrains.kotlin.idea.editor.KotlinEditorOptions;
import org.jetbrains.kotlin.idea.j2k.IdeaJavaToKotlinServices;
import org.jetbrains.kotlin.j2k.ConverterSettings;
import org.jetbrains.kotlin.j2k.JavaToKotlinConverter;
import org.jetbrains.kotlin.j2k.ParseContext;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u001a\u001e\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a8\u0006\u000f"}, d2={"confirmConvertJavaOnPaste", "", "project", "Lcom/intellij/openapi/project/Project;", "isPlainText", "convertCopiedCodeToKotlin", "Lorg/jetbrains/kotlin/idea/conversion/copy/ConversionResult;", "elementsAndTexts", "", "", "isNoConversionPosition", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "offset", "", "idea"})
public final class ConvertJavaCopyPasteProcessorKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ConversionResult convertCopiedCodeToKotlin(@NotNull Collection<? extends Object> elementsAndTexts, @NotNull Project project) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(elementsAndTexts, (String)"elementsAndTexts");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        JavaToKotlinConverter converter = new JavaToKotlinConverter(project, ConverterSettings.Companion.getDefaultSettings(), IdeaJavaToKotlinServices.INSTANCE);
        Iterable iterable = elementsAndTexts;
        void var5_4 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof PsiElement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List inputElements = (List)destination$iv$iv;
        List<JavaToKotlinConverter.ElementResult> results2 = converter.elementsToKotlin(inputElements).getResults();
        LinkedHashSet importsToAdd = new LinkedHashSet();
        int resultIndex = 0;
        StringBuilder convertedCodeBuilder = new StringBuilder();
        StringBuilder originalCodeBuilder = new StringBuilder();
        ParseContext parseContext = null;
        for (Object object : elementsAndTexts) {
            if (object instanceof PsiElement) {
                String originalText = ((PsiElement)object).getText();
                originalCodeBuilder.append(originalText);
                JavaToKotlinConverter.ElementResult result2 = results2.get(resultIndex++);
                if (result2 != null) {
                    convertedCodeBuilder.append(result2.getText());
                    if (parseContext == null) {
                        parseContext = result2.getParseContext();
                    }
                    importsToAdd.addAll(result2.getImportsToAdd());
                    continue;
                }
                convertedCodeBuilder.append(originalText);
                continue;
            }
            originalCodeBuilder.append(object);
            Object object2 = object;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            convertedCodeBuilder.append((String)object2);
        }
        String string = convertedCodeBuilder.toString();
        String originalCode = originalCodeBuilder.toString();
        String string2 = string;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"convertedCode");
        ParseContext parseContext2 = parseContext;
        if (parseContext2 == null) {
            parseContext2 = ParseContext.CODE_BLOCK;
        }
        return new ConversionResult(string2, parseContext2, importsToAdd, Intrinsics.areEqual((Object)string, (Object)originalCode) ^ true);
    }

    public static final boolean isNoConversionPosition(@NotNull KtFile file2, int offset2) {
        PsiElement token;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if (offset2 == 0) {
            return false;
        }
        PsiElement psiElement = file2.findElementAt(offset2 - 1);
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        if (!((token = psiElement) instanceof PsiWhiteSpace) && PsiUtilsKt.getEndOffset(token) != offset2) {
            return true;
        }
        for (PsiElement element2 : PsiUtilsKt.getParentsWithSelf(token)) {
            if (element2 instanceof PsiComment) {
                return true;
            }
            if (element2 instanceof KtStringTemplateEntryWithExpression) {
                return false;
            }
            if (!(element2 instanceof KtStringTemplateExpression)) continue;
            return true;
        }
        return false;
    }

    public static final boolean confirmConvertJavaOnPaste(@NotNull Project project, boolean isPlainText) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (KotlinEditorOptions.getInstance().isDonTShowConversionDialog()) {
            return true;
        }
        KotlinPasteFromJavaDialog dialog2 = new KotlinPasteFromJavaDialog(project, isPlainText);
        dialog2.show();
        return dialog2.isOK();
    }
}

