/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.FieldBreakpoint;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Field;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.WatchpointRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinFieldBreakpoint$WhenMappings;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinPropertyBreakpointProperties;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 F2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002EFB\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010\u0015\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J:\u0010\u001c\u001a\u0004\u0018\u0001H\u001d\"\n\b\u0000\u0010\u001d\u0018\u0001*\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001d0 2\u0006\u0010!\u001a\u00020\"H\u0086\b\u00a2\u0006\u0002\u0010#J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0017H\u0014J\n\u0010*\u001a\u0004\u0018\u00010+H\u0016J\n\u0010,\u001a\u0004\u0018\u00010-H\u0016J\u0010\u0010.\u001a\u00020+2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010/\u001a\u0004\u0018\u00010\fJ\b\u00100\u001a\u00020+H\u0002J\u0010\u00101\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0017H\u0014J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020+03H\u0002J\u0014\u00104\u001a\u0004\u0018\u00010\f2\b\u00105\u001a\u0004\u0018\u000106H\u0002J\u0010\u00107\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0017H\u0014J\u0010\u00108\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0017H\u0014J\u0010\u00109\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0017H\u0014J\b\u0010:\u001a\u00020\u0017H\u0016J\u000e\u0010;\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bJ\u0012\u0010<\u001a\u00020\u000e2\b\u0010=\u001a\u0004\u0018\u00010>H\u0014J\u000e\u0010?\u001a\u00020\u000e2\u0006\u0010@\u001a\u00020+J\u0010\u0010A\u001a\u00020\u000e2\u0006\u0010B\u001a\u00020\u0017H\u0007J\u0010\u0010C\u001a\u00020\u000e2\u0006\u0010B\u001a\u00020\u0017H\u0007J\u0010\u0010D\u001a\u00020\u000e2\u0006\u0010B\u001a\u00020\u0017H\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinFieldBreakpoint;", "Lcom/intellij/debugger/ui/breakpoints/BreakpointWithHighlighter;", "Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinPropertyBreakpointProperties;", "project", "Lcom/intellij/openapi/project/Project;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/breakpoints/XBreakpoint;)V", "breakpointType", "Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinFieldBreakpoint$BreakpointType;", "computeBreakpointType", "property", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "createMethodBreakpoint", "", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "refType", "Lcom/sun/jdi/ReferenceType;", "accessor", "Lcom/sun/jdi/Method;", "createRequestForPreparedClass", "evaluateCondition", "", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "event", "Lcom/sun/jdi/event/LocatableEvent;", "findRequest", "T", "Lcom/sun/jdi/request/EventRequest;", "requestClass", "Ljava/lang/Class;", "requestor", "Lcom/intellij/debugger/requests/Requestor;", "(Lcom/intellij/debugger/engine/DebugProcessImpl;Ljava/lang/Class;Lcom/intellij/debugger/requests/Requestor;)Lcom/sun/jdi/request/EventRequest;", "getCategory", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/debugger/ui/breakpoints/FieldBreakpoint;", "getDisabledIcon", "Ljavax/swing/Icon;", "isMuted", "getDisplayName", "", "getEvaluationElement", "Lcom/intellij/psi/PsiElement;", "getEventMessage", "getField", "getFieldName", "getInvalidIcon", "getMethodsName", "", "getProperty", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "getSetIcon", "getVerifiedIcon", "getVerifiedWarningsIcon", "isValid", "matchesEvent", "reload", "psiFile", "Lcom/intellij/psi/PsiFile;", "setFieldName", "fieldName", "setWatchAccess", "value", "setWatchInitialization", "setWatchModification", "BreakpointType", "Companion", "idea"})
public final class KotlinFieldBreakpoint
extends BreakpointWithHighlighter<KotlinPropertyBreakpointProperties> {
    private BreakpointType breakpointType;
    private static final Logger LOG;
    private static final Key<FieldBreakpoint> CATEGORY;
    public static final Companion Companion;

    public boolean isValid() {
        if (!KotlinFieldBreakpoint.access$isPositionValid$s714927978(this.getXBreakpoint().getSourcePosition())) {
            return false;
        }
        return (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(this){
            final /* synthetic */ KotlinFieldBreakpoint this$0;

            public final boolean invoke() {
                KtCallableDeclaration field2 = this.this$0.getField();
                return field2 != null && field2.isValid();
            }
            {
                this.this$0 = kotlinFieldBreakpoint;
                super(0);
            }
        });
    }

    @Nullable
    public final KtCallableDeclaration getField() {
        SourcePosition sourcePosition2 = this.getSourcePosition();
        return this.getProperty(sourcePosition2);
    }

    private final KtCallableDeclaration getProperty(SourcePosition sourcePosition2) {
        KtProperty property2 = (KtProperty)PositionUtil.getPsiElementAt((Project)this.getProject(), KtProperty.class, (SourcePosition)sourcePosition2);
        if (property2 != null) {
            return property2;
        }
        KtParameter parameter = (KtParameter)PositionUtil.getPsiElementAt((Project)this.getProject(), KtParameter.class, (SourcePosition)sourcePosition2);
        if (parameter != null) {
            return parameter;
        }
        return null;
    }

    protected void reload(@Nullable PsiFile psiFile) {
        KtCallableDeclaration property2 = this.getProperty(this.getSourcePosition());
        if (property2 != null) {
            String string = property2.getName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"property.name!!");
            this.setFieldName(string);
            if (property2 instanceof KtProperty && ((KtProperty)property2).isTopLevel()) {
                KotlinPropertyBreakpointProperties kotlinPropertyBreakpointProperties = (KotlinPropertyBreakpointProperties)this.getProperties();
                String string2 = JvmFileClassUtil.getFileClassInfoNoResolve(property2.getContainingKtFile()).getFileClassFqName().asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"JvmFileClassUtil.getFile\u2026ileClassFqName.asString()");
                kotlinPropertyBreakpointProperties.setMyClassName(string2);
            } else {
                FqName fqName2;
                KtClassOrObject ktClass = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)property2, KtClassOrObject.class);
                if (ktClass instanceof KtClassOrObject && (fqName2 = ktClass.getFqName()) != null) {
                    KotlinPropertyBreakpointProperties kotlinPropertyBreakpointProperties = (KotlinPropertyBreakpointProperties)this.getProperties();
                    String string3 = fqName2.asString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"fqName.asString()");
                    kotlinPropertyBreakpointProperties.setMyClassName(string3);
                }
            }
            this.setInstanceFiltersEnabled(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void createRequestForPreparedClass(@Nullable DebugProcessImpl debugProcess, @Nullable ReferenceType refType) {
        if (debugProcess == null || refType == null) {
            return;
        }
        KtCallableDeclaration ktCallableDeclaration = this.getProperty(this.getSourcePosition());
        if (ktCallableDeclaration == null) {
            return;
        }
        KtCallableDeclaration property2 = ktCallableDeclaration;
        this.breakpointType = this.computeBreakpointType(property2);
        VirtualMachineProxyImpl vm = debugProcess.getVirtualMachineProxy();
        try {
            SourcePosition sourcePosition2;
            if (((KotlinPropertyBreakpointProperties)this.getProperties()).getWATCH_INITIALIZATION() && (sourcePosition2 = this.getSourcePosition()) != null) {
                void destination$iv$iv;
                Iterator $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = debugProcess.getPositionManager().locationsOfLine(refType, sourcePosition2);
                void var7_8 = $receiver$iv;
                Collection collection = new ArrayList();
                Iterator iterator2 = $receiver$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv$iv = iterator2.next();
                    Location it = (Location)element$iv$iv;
                    if (!(it.method().isConstructor() || it.method().isStaticInitializer())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                for (Object element$iv : $receiver$iv) {
                    Location it = (Location)element$iv;
                    BreakpointRequest request = debugProcess.getRequestsManager().createBreakpointRequest((FilteredRequestor)this, it);
                    debugProcess.getRequestsManager().enableRequest((EventRequest)request);
                    if (!KotlinFieldBreakpoint.Companion.getLOG().isDebugEnabled()) continue;
                    KotlinFieldBreakpoint.Companion.getLOG().debug("Breakpoint request added");
                }
            }
            switch (KotlinFieldBreakpoint$WhenMappings.$EnumSwitchMapping$0[this.breakpointType.ordinal()]) {
                case 1: {
                    Field field2 = refType.fieldByName(this.getFieldName());
                    if (field2 != null) {
                        WatchpointRequest request;
                        RequestManagerImpl manager = debugProcess.getRequestsManager();
                        if (((KotlinPropertyBreakpointProperties)this.getProperties()).getWATCH_MODIFICATION() && vm.canWatchFieldModification()) {
                            request = manager.createModificationWatchpointRequest((FilteredRequestor)this, field2);
                            debugProcess.getRequestsManager().enableRequest((EventRequest)request);
                            if (KotlinFieldBreakpoint.Companion.getLOG().isDebugEnabled()) {
                                KotlinFieldBreakpoint.Companion.getLOG().debug("Modification request added");
                            }
                        }
                        if (((KotlinPropertyBreakpointProperties)this.getProperties()).getWATCH_ACCESS() && vm.canWatchFieldAccess()) {
                            request = manager.createAccessWatchpointRequest((FilteredRequestor)this, field2);
                            debugProcess.getRequestsManager().enableRequest((EventRequest)request);
                            if (KotlinFieldBreakpoint.Companion.getLOG().isDebugEnabled()) {
                                KotlinFieldBreakpoint.Companion.getLOG().debug("Field access request added (field = " + field2.name() + "; refType = " + refType.name() + ")");
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    Method setter;
                    Method getter;
                    String fieldName = this.getFieldName();
                    if (((KotlinPropertyBreakpointProperties)this.getProperties()).getWATCH_ACCESS() && (getter = (Method)CollectionsKt.firstOrNull(refType.methodsByName(JvmAbi.getterName(fieldName)))) != null) {
                        this.createMethodBreakpoint(debugProcess, refType, getter);
                    }
                    if (!((KotlinPropertyBreakpointProperties)this.getProperties()).getWATCH_MODIFICATION() || (setter = (Method)CollectionsKt.firstOrNull(refType.methodsByName(JvmAbi.setterName(fieldName)))) == null) break;
                    this.createMethodBreakpoint(debugProcess, refType, setter);
                }
            }
        }
        catch (Exception ex) {
            KotlinFieldBreakpoint.Companion.getLOG().debug((Throwable)ex);
        }
    }

    private final BreakpointType computeBreakpointType(KtCallableDeclaration property2) {
        return (BreakpointType)((Object)ApplicationUtilsKt.runReadAction((Function0)new Function0<BreakpointType>(property2){
            final /* synthetic */ KtCallableDeclaration $property;

            @NotNull
            public final BreakpointType invoke() {
                BindingContext bindingContext2 = ResolutionUtils.analyze$default(this.$property, null, 1, null);
                DeclarationDescriptor descriptor2 = bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, this.$property);
                if (descriptor2 instanceof ValueParameterDescriptor) {
                    descriptor2 = (DeclarationDescriptor)bindingContext2.get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, descriptor2);
                }
                DeclarationDescriptor declarationDescriptor = descriptor2;
                if (declarationDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyDescriptor");
                }
                V v = bindingContext2.get(BindingContext.BACKING_FIELD_REQUIRED, (PropertyDescriptor)declarationDescriptor);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                return (Boolean)v != false ? BreakpointType.FIELD : BreakpointType.METHOD;
            }
            {
                this.$property = ktCallableDeclaration;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void createMethodBreakpoint(DebugProcessImpl debugProcess, ReferenceType refType, Method accessor) {
        RequestManagerImpl manager = debugProcess.getRequestsManager();
        Location line = (Location)CollectionsKt.firstOrNull(accessor.allLineLocations());
        if (line != null) {
            BreakpointRequest request = manager.createBreakpointRequest((FilteredRequestor)this, line);
            debugProcess.getRequestsManager().enableRequest((EventRequest)request);
            if (KotlinFieldBreakpoint.Companion.getLOG().isDebugEnabled()) {
                KotlinFieldBreakpoint.Companion.getLOG().debug("Breakpoint request added");
            }
        } else {
            EventRequest eventRequest;
            block9: {
                void requestor$iv;
                KotlinFieldBreakpoint kotlinFieldBreakpoint = this;
                Class<MethodEntryRequest> clazz = MethodEntryRequest.class;
                Requestor requestor = (Requestor)this;
                Set requests$iv = debugProcess.getRequestsManager().findRequests((Requestor)requestor$iv);
                for (EventRequest eventRequest$iv : requests$iv) {
                    void requestClass$iv;
                    if (!Intrinsics.areEqual(eventRequest$iv.getClass(), (Object)requestClass$iv)) continue;
                    EventRequest eventRequest2 = eventRequest$iv;
                    if (eventRequest2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.request.MethodEntryRequest");
                    }
                    eventRequest = (MethodEntryRequest)eventRequest2;
                    break block9;
                }
                eventRequest = null;
            }
            MethodEntryRequest entryRequest = (MethodEntryRequest)eventRequest;
            if (entryRequest == null) {
                MethodEntryRequest methodEntryRequest = manager.createMethodEntryRequest((FilteredRequestor)this);
                if (methodEntryRequest == null) {
                    Intrinsics.throwNpe();
                }
                entryRequest = methodEntryRequest;
                if (KotlinFieldBreakpoint.Companion.getLOG().isDebugEnabled()) {
                    KotlinFieldBreakpoint.Companion.getLOG().debug("Method entry request added (method = " + accessor.name() + "; refType = " + refType.name() + ")");
                }
            } else {
                entryRequest.disable();
            }
            entryRequest.addClassFilter(refType);
            manager.enableRequest((EventRequest)entryRequest);
        }
    }

    private final <T extends EventRequest> T findRequest(DebugProcessImpl debugProcess, Class<T> requestClass, Requestor requestor) {
        Set requests = debugProcess.getRequestsManager().findRequests(requestor);
        for (EventRequest eventRequest : requests) {
            if (!Intrinsics.areEqual(eventRequest.getClass(), requestClass)) continue;
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            return (T)eventRequest;
        }
        return (T)((EventRequest)null);
    }

    public boolean evaluateCondition(@NotNull EvaluationContextImpl context, @NotNull LocatableEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)((Object)this.breakpointType), (Object)((Object)BreakpointType.METHOD)) && !this.matchesEvent(event)) {
            return false;
        }
        return super.evaluateCondition(context, event);
    }

    public final boolean matchesEvent(@NotNull LocatableEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Method method = event.location().method();
        return method != null && this.getMethodsName().contains(method.name());
    }

    private final List<String> getMethodsName() {
        String fieldName = this.getFieldName();
        return CollectionsKt.listOf((Object[])new String[]{JvmAbi.getterName(fieldName), JvmAbi.setterName(fieldName)});
    }

    @NotNull
    public String getEventMessage(@NotNull LocatableEvent event) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Location location2 = event.location();
        String locationQName = location2.declaringType().name() + "." + location2.method().name();
        try {
            string = location2.sourceName();
        }
        catch (AbsentInformationException e) {
            string = this.getFileName();
        }
        catch (InternalError e) {
            string = this.getFileName();
        }
        String locationFileName = string;
        int locationLine = location2.lineNumber();
        LocatableEvent locatableEvent = event;
        if (locatableEvent instanceof ModificationWatchpointEvent) {
            Field field2 = ((ModificationWatchpointEvent)event).field();
            String string2 = DebuggerBundle.message((String)"status.static.field.watchpoint.reached.access", (Object[])new Object[]{field2.declaringType().name(), field2.name(), locationQName, locationFileName, locationLine});
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"DebuggerBundle.message(\n\u2026            locationLine)");
            return string2;
        }
        if (locatableEvent instanceof AccessWatchpointEvent) {
            Field field3 = ((AccessWatchpointEvent)event).field();
            String string3 = DebuggerBundle.message((String)"status.static.field.watchpoint.reached.access", (Object[])new Object[]{field3.declaringType().name(), field3.name(), locationQName, locationFileName, locationLine});
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"DebuggerBundle.message(\n\u2026            locationLine)");
            return string3;
        }
        if (locatableEvent instanceof MethodEntryEvent) {
            Method method = ((MethodEntryEvent)event).method();
            String string4 = DebuggerBundle.message((String)"status.method.entry.breakpoint.reached", (Object[])new Object[]{method.declaringType().name() + "." + method.name() + "()", locationQName, locationFileName, locationLine});
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"DebuggerBundle.message(\n\u2026            locationLine)");
            return string4;
        }
        if (locatableEvent instanceof MethodExitEvent) {
            Method method = ((MethodExitEvent)event).method();
            String string5 = DebuggerBundle.message((String)"status.method.exit.breakpoint.reached", (Object[])new Object[]{method.declaringType().name() + "." + method.name() + "()", locationQName, locationFileName, locationLine});
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"DebuggerBundle.message(\n\u2026            locationLine)");
            return string5;
        }
        String string6 = DebuggerBundle.message((String)"status.line.breakpoint.reached", (Object[])new Object[]{locationQName, locationFileName, locationLine});
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"DebuggerBundle.message(\n\u2026            locationLine)");
        return string6;
    }

    public final void setFieldName(@NotNull String fieldName) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        ((KotlinPropertyBreakpointProperties)this.getProperties()).setMyFieldName(fieldName);
    }

    public final void setWatchAccess(boolean value2) {
        ((KotlinPropertyBreakpointProperties)this.getProperties()).setWATCH_ACCESS(value2);
    }

    public final void setWatchModification(boolean value2) {
        ((KotlinPropertyBreakpointProperties)this.getProperties()).setWATCH_MODIFICATION(value2);
    }

    public final void setWatchInitialization(boolean value2) {
        ((KotlinPropertyBreakpointProperties)this.getProperties()).setWATCH_INITIALIZATION(value2);
    }

    @NotNull
    protected Icon getDisabledIcon(boolean isMuted) {
        Icon icon;
        Breakpoint master = DebuggerManagerEx.getInstanceEx((Project)this.myProject).getBreakpointManager().findMasterBreakpoint((Breakpoint)this);
        if (isMuted && master == null) {
            Icon icon2 = AllIcons.Debugger.Db_muted_disabled_field_breakpoint;
            icon = icon2;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"AllIcons.Debugger.Db_mut\u2026disabled_field_breakpoint");
        } else if (isMuted && master != null) {
            Icon icon3 = AllIcons.Debugger.Db_muted_dep_field_breakpoint;
            icon = icon3;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon3, (String)"AllIcons.Debugger.Db_muted_dep_field_breakpoint");
        } else if (master != null) {
            Icon icon4 = AllIcons.Debugger.Db_dep_field_breakpoint;
            icon = icon4;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon4, (String)"AllIcons.Debugger.Db_dep_field_breakpoint");
        } else {
            Icon icon5 = AllIcons.Debugger.Db_disabled_field_breakpoint;
            icon = icon5;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon5, (String)"AllIcons.Debugger.Db_disabled_field_breakpoint");
        }
        return icon;
    }

    @NotNull
    protected Icon getSetIcon(boolean isMuted) {
        Icon icon;
        if (isMuted) {
            Icon icon2 = AllIcons.Debugger.Db_muted_field_breakpoint;
            icon = icon2;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"AllIcons.Debugger.Db_muted_field_breakpoint");
        } else {
            Icon icon3 = AllIcons.Debugger.Db_field_breakpoint;
            icon = icon3;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon3, (String)"AllIcons.Debugger.Db_field_breakpoint");
        }
        return icon;
    }

    @NotNull
    protected Icon getInvalidIcon(boolean isMuted) {
        Icon icon;
        if (isMuted) {
            Icon icon2 = AllIcons.Debugger.Db_muted_invalid_field_breakpoint;
            icon = icon2;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"AllIcons.Debugger.Db_mut\u2026_invalid_field_breakpoint");
        } else {
            Icon icon3 = AllIcons.Debugger.Db_invalid_field_breakpoint;
            icon = icon3;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon3, (String)"AllIcons.Debugger.Db_invalid_field_breakpoint");
        }
        return icon;
    }

    @NotNull
    protected Icon getVerifiedIcon(boolean isMuted) {
        Icon icon;
        if (isMuted) {
            Icon icon2 = AllIcons.Debugger.Db_muted_verified_field_breakpoint;
            icon = icon2;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"AllIcons.Debugger.Db_mut\u2026verified_field_breakpoint");
        } else {
            Icon icon3 = AllIcons.Debugger.Db_verified_field_breakpoint;
            icon = icon3;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon3, (String)"AllIcons.Debugger.Db_verified_field_breakpoint");
        }
        return icon;
    }

    @NotNull
    protected Icon getVerifiedWarningsIcon(boolean isMuted) {
        Icon icon;
        if (isMuted) {
            Icon icon2 = AllIcons.Debugger.Db_muted_field_warning_breakpoint;
            icon = icon2;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"AllIcons.Debugger.Db_mut\u2026_field_warning_breakpoint");
        } else {
            Icon icon3 = AllIcons.Debugger.Db_field_warning_breakpoint;
            icon = icon3;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon3, (String)"AllIcons.Debugger.Db_field_warning_breakpoint");
        }
        return icon;
    }

    @NotNull
    public Key<FieldBreakpoint> getCategory() {
        return KotlinFieldBreakpoint.Companion.getCATEGORY();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public String getDisplayName() {
        String string;
        if (!this.isValid()) {
            return DebuggerBundle.message((String)"status.breakpoint.invalid", (Object[])new Object[0]);
        }
        String className2 = this.getClassName();
        if (className2 != null) {
            CharSequence charSequence = className2;
            if (!(charSequence.length() == 0)) {
                string = className2 + "." + this.getFieldName();
                return string;
            }
        }
        string = this.getFieldName();
        return string;
    }

    private final String getFieldName() {
        KtCallableDeclaration declaration = this.getField();
        String string = (String)ApplicationUtilsKt.runReadAction((Function0)new Function0<String>(declaration){
            final /* synthetic */ KtCallableDeclaration $declaration;

            @Nullable
            public final String invoke() {
                KtCallableDeclaration ktCallableDeclaration = this.$declaration;
                return ktCallableDeclaration != null ? ktCallableDeclaration.getName() : null;
            }
            {
                this.$declaration = ktCallableDeclaration;
                super(0);
            }
        });
        if (string == null) {
            string = "unknown";
        }
        return string;
    }

    @Nullable
    public PsiElement getEvaluationElement() {
        return this.getField();
    }

    public KotlinFieldBreakpoint(@NotNull Project project, @NotNull XBreakpoint<KotlinPropertyBreakpointProperties> breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        super(project, breakpoint);
        this.breakpointType = BreakpointType.FIELD;
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance((String)"#org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinFieldBreakpoint");
        Key key = BreakpointCategory.lookup((String)"field_breakpoints");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"BreakpointCategory.looku\u2026int>(\"field_breakpoints\")");
        CATEGORY = key;
    }

    public static final /* synthetic */ boolean access$isPositionValid$s714927978(@Nullable XSourcePosition sourcePosition2) {
        return BreakpointWithHighlighter.isPositionValid((XSourcePosition)sourcePosition2);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinFieldBreakpoint$BreakpointType;", "", "(Ljava/lang/String;I)V", "FIELD", "METHOD", "idea"})
    private static final class BreakpointType
    extends Enum<BreakpointType> {
        public static final /* enum */ BreakpointType FIELD;
        public static final /* enum */ BreakpointType METHOD;
        private static final /* synthetic */ BreakpointType[] $VALUES;

        static {
            BreakpointType[] breakpointTypeArray = new BreakpointType[2];
            BreakpointType[] breakpointTypeArray2 = breakpointTypeArray;
            breakpointTypeArray[0] = FIELD = new BreakpointType();
            breakpointTypeArray[1] = METHOD = new BreakpointType();
            $VALUES = breakpointTypeArray;
        }

        public static BreakpointType[] values() {
            return (BreakpointType[])$VALUES.clone();
        }

        public static BreakpointType valueOf(String string) {
            return Enum.valueOf(BreakpointType.class, string);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinFieldBreakpoint$Companion;", "", "()V", "CATEGORY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/debugger/ui/breakpoints/FieldBreakpoint;", "getCATEGORY", "()Lcom/intellij/openapi/util/Key;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "idea"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        private final Key<FieldBreakpoint> getCATEGORY() {
            return CATEGORY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

