/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.jdi.JdiValuesKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.debugger.KotlinEditorTextProvider;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentFactory;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluationBuilder;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluationBuilderKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinRuntimeTypeEvaluator;
import org.jetbrains.kotlin.idea.j2k.J2kPostProcessor;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.j2k.AfterConversionPass;
import org.jetbrains.kotlin.psi.KtBlockCodeFragment;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 .2\u00020\u0001:\u0002./B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\"\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J6\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00112\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00190\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u00152\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001c\u001a\u00020\u0011H\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\n !*\u0004\u0018\u00010 0 H\u0016J\u001c\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010\u000b2\u0006\u0010%\u001a\u00020&H\u0002J\u001c\u0010'\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0014\u0010(\u001a\u0004\u0018\u00010\u00112\b\u0010)\u001a\u0004\u0018\u00010\u0011H\u0002J\u0012\u0010*\u001a\u00020+2\b\u0010$\u001a\u0004\u0018\u00010\u000bH\u0016J&\u0010,\u001a\u0004\u0018\u00010\u00152\u0006\u0010\f\u001a\u00020\r2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\b\u0010-\u001a\u0004\u0018\u00010\u0015H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentFactory;", "Lcom/intellij/debugger/engine/evaluation/CodeFragmentFactory;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createCodeFragment", "Lcom/intellij/psi/JavaCodeFragment;", "item", "Lcom/intellij/debugger/engine/evaluation/TextWithImports;", "context", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "createFakeFileWithJavaContextElement", "Lorg/jetbrains/kotlin/psi/KtFile;", "funWithLocalVariables", "", "javaContext", "createPresentationCodeFragment", "createWrappingContext", "Lorg/jetbrains/kotlin/psi/KtElement;", "newFragmentText", "labels", "", "Lcom/sun/jdi/Value;", "originalContext", "fixImportIfNeeded", "import", "getEvaluatorBuilder", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluationBuilder;", "getFileType", "Lorg/jetbrains/kotlin/idea/KotlinFileType;", "kotlin.jvm.PlatformType", "getFrameInfo", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentFactory$FrameInfo;", "contextElement", "debuggerContext", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "getWrappedContextElement", "initImports", "imports", "isContextAccepted", "", "wrapContextIfNeeded", "newContext", "Companion", "FrameInfo", "idea"})
public final class KotlinCodeFragmentFactory
extends CodeFragmentFactory {
    private final Logger LOG = Logger.getInstance(((Object)((Object)this)).getClass());
    @NotNull
    private static final Key<Value> LABEL_VARIABLE_VALUE_KEY;
    @NotNull
    private static final String DEBUG_LABEL_SUFFIX = "_DebugLabel";
    @NotNull
    private static final Key<DebuggerContextImpl> DEBUG_CONTEXT_FOR_TESTS;
    public static final Companion Companion;

    @NotNull
    public JavaCodeFragment createCodeFragment(@NotNull TextWithImports item, @Nullable PsiElement context, @NotNull Project project) {
        KtCodeFragment ktCodeFragment;
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        PsiElement contextElement = this.getWrappedContextElement(project, context);
        if (contextElement == null) {
            PsiElement psiElement = context;
            this.LOG.warn("CodeFragment with null context created:" + "\n" + "originalContext = " + (psiElement != null ? PsiUtilsKt.getElementTextWithContext(psiElement) : null));
        }
        if (Intrinsics.areEqual((Object)item.getKind(), (Object)CodeFragmentKind.EXPRESSION)) {
            CharSequence charSequence = item.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"item.text");
            ktCodeFragment = new KtExpressionCodeFragment(project, "fragment.kt", charSequence, this.initImports(item.getImports()), contextElement);
        } else {
            CharSequence charSequence = item.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"item.text");
            ktCodeFragment = new KtBlockCodeFragment(project, "fragment.kt", charSequence, this.initImports(item.getImports()), contextElement);
        }
        KtCodeFragment codeFragment = ktCodeFragment;
        codeFragment.putCopyableUserData(KtCodeFragment.Companion.getRUNTIME_TYPE_EVALUATOR(), new Function1<KtExpression, KotlinType>(project){
            final /* synthetic */ Project $project;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final KotlinType invoke(@NotNull KtExpression expression2) {
                KotlinType kotlinType;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                DebuggerContextImpl debuggerContext = DebuggerManagerEx.getInstanceEx((Project)this.$project).getContext();
                DebuggerSession debuggerSession = debuggerContext.getDebuggerSession();
                if (debuggerSession == null || debuggerContext.getSuspendContext() == null) {
                    kotlinType = null;
                } else {
                    int n;
                    int n2;
                    Semaphore semaphore = new Semaphore();
                    semaphore.down();
                    AtomicReference<V> nameRef = new AtomicReference<V>();
                    Editor editor = null;
                    DebuggerContextImpl debuggerContextImpl = debuggerContext;
                    Intrinsics.checkExpressionValueIsNotNull((Object)debuggerContextImpl, (String)"debuggerContext");
                    ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                    Intrinsics.checkExpressionValueIsNotNull((Object)progressIndicator, (String)"ProgressManager.getInstance().progressIndicator");
                    KotlinRuntimeTypeEvaluator worker2 = new KotlinRuntimeTypeEvaluator(nameRef, semaphore, expression2, debuggerContext, editor, expression2, debuggerContextImpl, progressIndicator){
                        final /* synthetic */ AtomicReference $nameRef;
                        final /* synthetic */ Semaphore $semaphore;
                        final /* synthetic */ KtExpression $expression;
                        final /* synthetic */ DebuggerContextImpl $debuggerContext;

                        protected void typeCalculationFinished(@Nullable KotlinType type2) {
                            this.$nameRef.set(type2);
                            this.$semaphore.up();
                        }
                        {
                            this.$nameRef = $captured_local_variable$0;
                            this.$semaphore = $captured_local_variable$1;
                            this.$expression = $captured_local_variable$2;
                            this.$debuggerContext = $captured_local_variable$3;
                            super($super_call_param$4, $super_call_param$5, $super_call_param$6, $super_call_param$7);
                        }
                    };
                    DebugProcessImpl debugProcessImpl = debuggerContext.getDebugProcess();
                    if (debugProcessImpl != null && (debugProcessImpl = debugProcessImpl.getManagerThread()) != null) {
                        debugProcessImpl.invoke((DebuggerCommandImpl)worker2);
                    }
                    if ((n2 = 0) <= (n = 50)) {
                        while (true) {
                            void i;
                            ProgressManager.checkCanceled();
                            if (semaphore.waitFor(20L) || i == n) break;
                            ++i;
                        }
                    }
                    kotlinType = (KotlinType)nameRef.get();
                }
                return kotlinType;
            }
            {
                this.$project = project;
                super(1);
            }
        });
        if (contextElement != null && !(contextElement instanceof KtElement)) {
            codeFragment.putCopyableUserData(KtCodeFragment.Companion.getFAKE_CONTEXT_FOR_JAVA_FILE(), new Function0<KtElement>(this, contextElement, project){
                final /* synthetic */ KotlinCodeFragmentFactory this$0;
                final /* synthetic */ PsiElement $contextElement;
                final /* synthetic */ Project $project;

                /*
                 * Unable to fully structure code
                 */
                @NotNull
                public final KtElement invoke() {
                    block12: {
                        block11: {
                            emptyFile = KotlinCodeFragmentFactory.access$createFakeFileWithJavaContextElement(this.this$0, "", this.$contextElement);
                            debuggerContext = DebuggerManagerEx.getInstanceEx((Project)this.$project).getContext();
                            debuggerSession = debuggerContext.getDebuggerSession();
                            if (!(debuggerSession != null && debuggerContext.getSuspendContext() != null || ApplicationManager.getApplication().isUnitTestMode())) {
                                KotlinCodeFragmentFactory.access$getLOG$p(this.this$0).warn("Couldn't create fake context element for java file, debugger isn't paused on breakpoint");
                                return emptyFile;
                            }
                            v0 = debuggerContext;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"debuggerContext");
                            frameDescriptor = KotlinCodeFragmentFactory.access$getFrameInfo(this.this$0, this.$contextElement, v0);
                            if (frameDescriptor == null) {
                                KotlinCodeFragmentFactory.access$getLOG$p(this.this$0).warn("Couldn't get info about 'this' and local variables for " + debuggerContext.getSourcePosition().getFile().getName() + ":" + debuggerContext.getSourcePosition().getLine());
                                return emptyFile;
                            }
                            v1 = frameDescriptor.getThisObject();
                            if (v1 == null) ** GOTO lbl-1000
                            var6_5 = v1;
                            it = var6_5;
                            v2 = it.type().name();
                            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it.type().name()");
                            v1 = org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentFactory$Companion.access$createKotlinProperty(KotlinCodeFragmentFactory.Companion, this.$project, "this_0", v2, it);
                            if (v1 != null) {
                                v3 = v1.getTypeReference();
                            } else lbl-1000:
                            // 2 sources

                            {
                                v3 = null;
                            }
                            if ((v4 = (receiverTypeReference = v3)) == null) break block11;
                            it = v4;
                            it = (KtTypeReference)it;
                            v4 = it.getText() + ".";
                            if (v4 != null) break block12;
                        }
                        v4 = "";
                    }
                    receiverTypeText = v4;
                    it = frameDescriptor.getVisibleVariables().entrySet();
                    var20_9 = KotlinCodeFragmentFactory.Companion;
                    capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
                    var10_12 = $receiver$iv;
                    var11_13 = new LinkedHashMap<K, V>(capacity$iv);
                    for (T element$iv$iv : $receiver$iv$iv) {
                        var14_16 = destination$iv$iv;
                        it = (Map.Entry)element$iv$iv;
                        var17_18 = TuplesKt.to((Object)((LocalVariable)it.getKey()).name(), it.getValue());
                        var14_16.put(var17_18.getFirst(), var17_18.getSecond());
                    }
                    var21_19 = destination$iv$iv;
                    kotlinVariablesText = org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentFactory$Companion.access$kotlinVariablesAsText(var20_9, (Map)var21_19, this.$project);
                    fakeFunctionText = "fun " + receiverTypeText + "_java_locals_debug_fun_() {" + "\n" + kotlinVariablesText + "\n" + "}";
                    fakeFile = KotlinCodeFragmentFactory.access$createFakeFileWithJavaContextElement(this.this$0, fakeFunctionText, this.$contextElement);
                    v5 = CollectionsKt.firstOrNull(fakeFile.getDeclarations());
                    if (!(v5 instanceof KtFunction)) {
                        v5 = null;
                    }
                    v6 = fakeFunction = (KtFunction)v5;
                    v7 = v6 != null ? v6.getBodyExpression() : null;
                    if (!(v7 instanceof KtBlockExpression)) {
                        v7 = null;
                    }
                    v8 = fakeContext = (v9 = (KtBlockExpression)v7) != null && (v9 = v9.getStatements()) != null ? (KtExpression)CollectionsKt.lastOrNull((List)v9) : null;
                    v10 = KotlinCodeFragmentFactory.access$wrapContextIfNeeded(this.this$0, this.$project, this.$contextElement, fakeContext);
                    if (v10 == null) {
                        v10 = emptyFile;
                    }
                    return v10;
                }
                {
                    this.this$0 = kotlinCodeFragmentFactory;
                    this.$contextElement = psiElement;
                    this.$project = project;
                    super(0);
                }
            });
        }
        return codeFragment;
    }

    /*
     * WARNING - void declaration
     */
    private final FrameInfo getFrameInfo(PsiElement contextElement, DebuggerContextImpl debuggerContext) {
        int n;
        int n2;
        void frameInfo;
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        DebuggerCommandImpl worker2 = new DebuggerCommandImpl(contextElement, debuggerContext, (Ref.ObjectRef)frameInfo, semaphore){
            final /* synthetic */ PsiElement $contextElement;
            final /* synthetic */ DebuggerContextImpl $debuggerContext;
            final /* synthetic */ Ref.ObjectRef $frameInfo;
            final /* synthetic */ Semaphore $semaphore;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void action() {
                try {
                    Map<LocalVariable, Value> map2;
                    Value value2;
                    FrameInfo frameInfo;
                    FrameInfo frameInfo2;
                    block12: {
                        block11: {
                            FrameInfo frameInfo3;
                            StackFrame stackFrame;
                            if (ApplicationManager.getApplication().isUnitTestMode()) {
                                PsiElement psiElement = this.$contextElement;
                                stackFrame = psiElement != null && (psiElement = (DebuggerContextImpl)psiElement.getCopyableUserData(KotlinCodeFragmentFactory.Companion.getDEBUG_CONTEXT_FOR_TESTS())) != null && (psiElement = psiElement.getFrameProxy()) != null ? psiElement.getStackFrame() : null;
                            } else {
                                StackFrameProxyImpl stackFrameProxyImpl = this.$debuggerContext.getFrameProxy();
                                stackFrame = stackFrameProxyImpl != null ? stackFrameProxyImpl.getStackFrame() : null;
                            }
                            StackFrame frame = stackFrame;
                            Ref.ObjectRef objectRef = this.$frameInfo;
                            frameInfo2 = frameInfo3;
                            frameInfo = frameInfo3;
                            StackFrame stackFrame2 = frame;
                            value2 = stackFrame2 != null ? stackFrame2.thisObject() : null;
                            map2 = frame;
                            if (map2 == null) break block11;
                            StackFrame stackFrame3 = map2;
                            Value value3 = value2;
                            FrameInfo frameInfo4 = frameInfo2;
                            FrameInfo frameInfo5 = frameInfo;
                            Ref.ObjectRef objectRef2 = objectRef;
                            StackFrame it = stackFrame3;
                            Map<LocalVariable, Value> map3 = it.getValues(it.visibleVariables());
                            objectRef = objectRef2;
                            frameInfo = frameInfo5;
                            frameInfo2 = frameInfo4;
                            value2 = value3;
                            map2 = map3;
                            if (map2 != null) break block12;
                        }
                        map2 = MapsKt.emptyMap();
                    }
                    frameInfo2(value2, (Map<LocalVariable, ? extends Value>)map2);
                    objectRef.element = frameInfo;
                }
                catch (AbsentInformationException absentInformationException) {
                }
                finally {
                    this.$semaphore.up();
                }
            }
            {
                this.$contextElement = $captured_local_variable$0;
                this.$debuggerContext = $captured_local_variable$1;
                this.$frameInfo = $captured_local_variable$2;
                this.$semaphore = $captured_local_variable$3;
            }
        };
        DebugProcessImpl debugProcessImpl = debuggerContext.getDebugProcess();
        if (debugProcessImpl != null && (debugProcessImpl = debugProcessImpl.getManagerThread()) != null) {
            debugProcessImpl.invoke(worker2);
        }
        if ((n2 = 0) <= (n = 50)) {
            void i;
            while (!semaphore.waitFor(20L) && i != n) {
                ++i;
            }
        }
        return (FrameInfo)frameInfo.element;
    }

    /*
     * WARNING - void declaration
     */
    private final String initImports(String imports) {
        if (imports != null) {
            CharSequence charSequence = imports;
            if (!(charSequence.length() == 0)) {
                void destination$iv$iv;
                void $receiver$iv$iv$iv;
                void $receiver$iv$iv;
                Iterable $receiver$iv = StringsKt.split$default((CharSequence)imports, (String[])new String[]{KtCodeFragment.Companion.getIMPORT_SEPARATOR()}, (boolean)false, (int)0, (int)6, null);
                Iterable iterable = $receiver$iv;
                Collection collection = new ArrayList();
                void var5_5 = $receiver$iv$iv;
                for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                    String string;
                    Object element$iv$iv = element$iv$iv$iv;
                    String it = (String)element$iv$iv;
                    if (this.fixImportIfNeeded(it) == null) continue;
                    String it$iv$iv = string;
                    destination$iv$iv.add(it$iv$iv);
                }
                return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)KtCodeFragment.Companion.getIMPORT_SEPARATOR(), null, null, (int)0, null, null, (int)62, null);
            }
        }
        return null;
    }

    private final String fixImportIfNeeded(String string) {
        if (StringsKt.endsWith$default((String)string, (String)"[]", (boolean)false, (int)2, null)) {
            String string2 = StringsKt.removeSuffix((String)string, (CharSequence)"[]");
            KotlinCodeFragmentFactory kotlinCodeFragmentFactory = this;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string4 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            return kotlinCodeFragmentFactory.fixImportIfNeeded(string4);
        }
        if (Intrinsics.areEqual((Object)PsiTypesUtil.boxIfPossible((String)string), (Object)string) ^ true) {
            return null;
        }
        return string;
    }

    private final PsiElement getWrappedContextElement(Project project, PsiElement context) {
        PsiElement newContext = Companion.getContextElement(context);
        if (!(newContext instanceof KtElement)) {
            return newContext;
        }
        return (PsiElement)this.wrapContextIfNeeded(project, context, (KtElement)newContext);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public JavaCodeFragment createPresentationCodeFragment(@NotNull TextWithImports item, @Nullable PsiElement context, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        JavaCodeFragment kotlinCodeFragment = this.createCodeFragment(item, context, project);
        if (PsiTreeUtil.hasErrorElements((PsiElement)((PsiElement)kotlinCodeFragment)) && kotlinCodeFragment instanceof KtExpressionCodeFragment) {
            Object e2;
            PsiExpression psiExpression;
            try {
                psiExpression = PsiElementFactory.SERVICE.getInstance((Project)project).createExpressionFromText(item.getText(), context);
            }
            catch (IncorrectOperationException e2) {
                psiExpression = null;
            }
            PsiExpression javaExpression = psiExpression;
            try {
                PsiImportList psiImportList;
                KtImportList ktImportList = ((KtExpressionCodeFragment)kotlinCodeFragment).importsAsImportList();
                if (ktImportList != null) {
                    e2 = ktImportList;
                    KtImportList it = (KtImportList)e2;
                    PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("dummy.java", (FileType)JavaFileType.INSTANCE, (CharSequence)it.getText());
                    if (!(psiFile instanceof PsiJavaFile)) {
                        psiFile = null;
                    }
                    PsiJavaFile psiJavaFile = (PsiJavaFile)psiFile;
                    psiImportList = psiJavaFile != null ? psiJavaFile.getImportList() : null;
                } else {
                    psiImportList = null;
                }
                e2 = psiImportList;
            }
            catch (IncorrectOperationException e3) {
                e2 = null;
            }
            PsiImportList importList = e2;
            if (javaExpression != null) {
                void convertedFragment;
                e2 = new Ref.ObjectRef();
                e2.element = null;
                ApplicationUtilsKt.executeWriteCommand(project, "Convert java expression to kotlin in Evaluate Expression", (Function0<Unit>)((Function0)new Function0<Unit>(javaExpression, importList, (Ref.ObjectRef)convertedFragment, project, kotlinCodeFragment){
                    final /* synthetic */ PsiExpression $javaExpression;
                    final /* synthetic */ PsiImportList $importList;
                    final /* synthetic */ Ref.ObjectRef $convertedFragment;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ JavaCodeFragment $kotlinCodeFragment;

                    public final void invoke() {
                        String newImports;
                        String newText = KotlinRefactoringUtilKt.j2kText((PsiElement)this.$javaExpression);
                        PsiImportList psiImportList = this.$importList;
                        String string = newImports = psiImportList != null ? KotlinRefactoringUtilKt.j2kText((PsiElement)psiImportList) : null;
                        if (newText != null) {
                            String string2 = ((KtExpressionCodeFragment)this.$kotlinCodeFragment).getName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"kotlinCodeFragment.name");
                            this.$convertedFragment.element = new KtExpressionCodeFragment(this.$project, string2, newText, newImports, ((KtExpressionCodeFragment)this.$kotlinCodeFragment).getContext());
                            AfterConversionPass afterConversionPass = new AfterConversionPass(this.$project, new J2kPostProcessor(false));
                            KtExpressionCodeFragment ktExpressionCodeFragment = (KtExpressionCodeFragment)this.$convertedFragment.element;
                            if (ktExpressionCodeFragment == null) {
                                Intrinsics.throwNpe();
                            }
                            afterConversionPass.run(ktExpressionCodeFragment, null);
                        }
                    }
                    {
                        this.$javaExpression = psiExpression;
                        this.$importList = psiImportList;
                        this.$convertedFragment = objectRef;
                        this.$project = project;
                        this.$kotlinCodeFragment = javaCodeFragment;
                        super(0);
                    }
                }));
                KtExpressionCodeFragment ktExpressionCodeFragment = (KtExpressionCodeFragment)convertedFragment.element;
                return ktExpressionCodeFragment != null ? (JavaCodeFragment)ktExpressionCodeFragment : kotlinCodeFragment;
            }
        }
        return kotlinCodeFragment;
    }

    public boolean isContextAccepted(@Nullable PsiElement contextElement) {
        boolean bl;
        if (contextElement instanceof PsiCodeBlock) {
            PsiElement psiElement = ((PsiCodeBlock)contextElement).getContext();
            bl = this.isContextAccepted((PsiElement)(psiElement != null ? psiElement.getContext() : null));
        } else if (contextElement == null) {
            bl = false;
        } else if (Intrinsics.areEqual((Object)contextElement.getLanguage(), (Object)KotlinFileType.INSTANCE.getLanguage())) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)contextElement.getLanguage(), (Object)JavaFileType.INSTANCE.getLanguage())) {
            Project project = contextElement.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"contextElement.project");
            GlobalSearchScope globalSearchScope = contextElement.getResolveScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"contextElement.resolveScope");
            bl = KotlinRuntimeLibraryUtilKt.getKotlinJvmRuntimeMarkerClass(project, globalSearchScope) != null;
        } else {
            bl = false;
        }
        return bl;
    }

    public KotlinFileType getFileType() {
        return KotlinFileType.INSTANCE;
    }

    @NotNull
    public KotlinEvaluationBuilder getEvaluatorBuilder() {
        return KotlinEvaluationBuilder.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final KtElement wrapContextIfNeeded(Project project, PsiElement originalContext, KtElement newContext) {
        void labels;
        void text2;
        Map markupMap;
        Map map2;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PsiElement psiElement = originalContext;
            map2 = NodeDescriptorImpl.getMarkupMap((DebugProcess)((DebugProcess)(psiElement != null && (psiElement = (DebuggerContextImpl)psiElement.getCopyableUserData(Companion.getDEBUG_CONTEXT_FOR_TESTS())) != null ? psiElement.getDebugProcess() : null)));
        } else {
            XDebugSessionImpl xDebugSessionImpl;
            XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)project).getCurrentSession();
            if (!(xDebugSession instanceof XDebugSessionImpl)) {
                xDebugSession = null;
            }
            map2 = (xDebugSessionImpl = (XDebugSessionImpl)xDebugSession) != null && (xDebugSessionImpl = xDebugSessionImpl.getValueMarkers()) != null ? xDebugSessionImpl.getAllMarkers() : (markupMap = null);
        }
        if (markupMap == null || markupMap.isEmpty()) {
            return newContext;
        }
        Object object = Companion.createCodeFragmentForLabeledObjects(project, markupMap);
        String string = (String)object.component1();
        Map map3 = (Map)object.component2();
        object = null;
        object = (CharSequence)text2;
        if (object.length() == 0) {
            return newContext;
        }
        return this.createWrappingContext((String)text2, (Map<String, ? extends Value>)labels, newContext, project);
    }

    private final KtFile createFakeFileWithJavaContextElement(String funWithLocalVariables, PsiElement javaContext) {
        PsiJavaFile psiJavaFile;
        Object it;
        PsiJavaFile psiJavaFile2;
        PsiFile psiFile = javaContext.getContainingFile();
        if (!(psiFile instanceof PsiJavaFile)) {
            psiFile = null;
        }
        PsiJavaFile javaFile = (PsiJavaFile)psiFile;
        StringBuilder sb = new StringBuilder();
        Object object = javaFile;
        if (object != null && (object = object.getPackageName()) != null && (object = (String)AddToStdlibKt.check(object, createFakeFileWithJavaContextElement.1.INSTANCE)) != null) {
            psiJavaFile2 = object;
            it = (String)psiJavaFile2;
            sb.append("package ").append(UtilsKt.quoteIfNeeded((String)it)).append("\n");
        }
        if ((psiJavaFile = javaFile) != null && (psiJavaFile = psiJavaFile.getImportList()) != null) {
            psiJavaFile2 = psiJavaFile;
            it = (PsiImportList)psiJavaFile2;
            sb.append(it.getText()).append("\n");
        }
        sb.append(funWithLocalVariables);
        Project project = javaContext.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"javaContext.project");
        KtPsiFactory ktPsiFactory = new KtPsiFactory(project);
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return ktPsiFactory.createAnalyzableFile("fakeFileForJavaContextInDebugger.kt", string, javaContext);
    }

    @Nullable
    public final KtElement createWrappingContext(@NotNull String newFragmentText, @NotNull Map<String, ? extends Value> labels, @Nullable KtElement originalContext, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)newFragmentText, (String)"newFragmentText");
        Intrinsics.checkParameterIsNotNull(labels, (String)"labels");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        KtBlockCodeFragment codeFragment = new KtPsiFactory(project).createBlockCodeFragment(newFragmentText, (PsiElement)originalContext);
        codeFragment.accept(new KtTreeVisitorVoid(labels){
            final /* synthetic */ Map $labels;

            public void visitProperty(@NotNull KtProperty property2) {
                Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
                Map map2 = this.$labels;
                String string = property2.getName();
                Map map3 = map2;
                if (map3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
                }
                Value reference2 = (Value)map3.get(string);
                if (reference2 != null) {
                    property2.putUserData(KotlinCodeFragmentFactory.Companion.getLABEL_VARIABLE_VALUE_KEY(), reference2);
                }
            }
            {
                this.$labels = $captured_local_variable$0;
            }
        });
        return (KtElement)CollectionsKt.lastOrNull(codeFragment.getContentElement().getStatements());
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"_label_variable_value_key_");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create<Value>(\"_label_variable_value_key_\")");
        LABEL_VARIABLE_VALUE_KEY = key;
        DEBUG_LABEL_SUFFIX = DEBUG_LABEL_SUFFIX;
        Key key2 = Key.create((String)"DEBUG_CONTEXT_FOR_TESTS");
        Intrinsics.checkExpressionValueIsNotNull((Object)key2, (String)"Key.create(\"DEBUG_CONTEXT_FOR_TESTS\")");
        DEBUG_CONTEXT_FOR_TESTS = key2;
    }

    @NotNull
    public static final /* synthetic */ KtFile access$createFakeFileWithJavaContextElement(KotlinCodeFragmentFactory $this, @NotNull String funWithLocalVariables, @NotNull PsiElement javaContext) {
        return $this.createFakeFileWithJavaContextElement(funWithLocalVariables, javaContext);
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLOG$p(KotlinCodeFragmentFactory $this) {
        return $this.LOG;
    }

    @Nullable
    public static final /* synthetic */ FrameInfo access$getFrameInfo(KotlinCodeFragmentFactory $this, @Nullable PsiElement contextElement, @NotNull DebuggerContextImpl debuggerContext) {
        return $this.getFrameInfo(contextElement, debuggerContext);
    }

    @Nullable
    public static final /* synthetic */ KtElement access$wrapContextIfNeeded(KotlinCodeFragmentFactory $this, @NotNull Project project, @Nullable PsiElement originalContext, @Nullable KtElement newContext) {
        return $this.wrapContextIfNeeded(project, originalContext, newContext);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentFactory$FrameInfo;", "", "thisObject", "Lcom/sun/jdi/Value;", "visibleVariables", "", "Lcom/sun/jdi/LocalVariable;", "(Lcom/sun/jdi/Value;Ljava/util/Map;)V", "getThisObject", "()Lcom/sun/jdi/Value;", "getVisibleVariables", "()Ljava/util/Map;", "idea"})
    private static final class FrameInfo {
        @Nullable
        private final Value thisObject;
        @NotNull
        private final Map<LocalVariable, Value> visibleVariables;

        @Nullable
        public final Value getThisObject() {
            return this.thisObject;
        }

        @NotNull
        public final Map<LocalVariable, Value> getVisibleVariables() {
            return this.visibleVariables;
        }

        public FrameInfo(@Nullable Value thisObject, @NotNull Map<LocalVariable, ? extends Value> visibleVariables) {
            Intrinsics.checkParameterIsNotNull(visibleVariables, (String)"visibleVariables");
            this.thisObject = thisObject;
            this.visibleVariables = visibleVariables;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0010\u0010\u0014\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00150\u0011J*\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\rH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cJ\u000e\u0010\u001e\u001a\u00020\u001f*\u0004\u0018\u00010 H\u0002J \u0010!\u001a\u00020\t*\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentFactory$Companion;", "", "()V", "DEBUG_CONTEXT_FOR_TESTS", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "getDEBUG_CONTEXT_FOR_TESTS", "()Lcom/intellij/openapi/util/Key;", "DEBUG_LABEL_SUFFIX", "", "getDEBUG_LABEL_SUFFIX", "()Ljava/lang/String;", "LABEL_VARIABLE_VALUE_KEY", "Lcom/sun/jdi/Value;", "getLABEL_VARIABLE_VALUE_KEY", "createCodeFragmentForLabeledObjects", "Lkotlin/Pair;", "", "project", "Lcom/intellij/openapi/project/Project;", "markupMap", "Lcom/intellij/xdebugger/impl/ui/tree/ValueMarkup;", "createKotlinProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "variableName", "variableTypeName", "value", "getContextElement", "Lcom/intellij/psi/PsiElement;", "elementAt", "check", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "kotlinVariablesAsText", "idea"})
    public static final class Companion {
        @NotNull
        public final Key<Value> getLABEL_VARIABLE_VALUE_KEY() {
            return LABEL_VARIABLE_VALUE_KEY;
        }

        @NotNull
        public final String getDEBUG_LABEL_SUFFIX() {
            return DEBUG_LABEL_SUFFIX;
        }

        @NotNull
        public final Key<DebuggerContextImpl> getDEBUG_CONTEXT_FOR_TESTS() {
            return DEBUG_CONTEXT_FOR_TESTS;
        }

        @Nullable
        public final PsiElement getContextElement(@Nullable PsiElement elementAt) {
            int n;
            if (elementAt == null) {
                return null;
            }
            if (elementAt instanceof PsiCodeBlock) {
                PsiElement psiElement = ((PsiCodeBlock)elementAt).getContext();
                return this.getContextElement((PsiElement)(psiElement != null ? psiElement.getContext() : null));
            }
            if (elementAt instanceof KtLightClass) {
                return this.getContextElement((PsiElement)((KtLightClass)elementAt).getKotlinOrigin());
            }
            PsiFile containingFile = elementAt.getContainingFile();
            if (containingFile instanceof PsiJavaFile) {
                return elementAt;
            }
            if (!(containingFile instanceof KtFile)) {
                return null;
            }
            if (elementAt instanceof PsiWhiteSpace || elementAt instanceof PsiComment) {
                PsiElement psiElement = PsiTreeUtil.skipSiblingsForward((PsiElement)elementAt, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
                n = psiElement != null ? psiElement.getTextOffset() : elementAt.getTextOffset();
            } else {
                n = elementAt.getTextOffset();
            }
            int lineStartOffset = n;
            KtExpression result2 = (KtExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)containingFile, (int)lineStartOffset, KtExpression.class, (boolean)false);
            if (this.check(result2)) {
                KtExpression ktExpression = result2;
                if (ktExpression == null) {
                    Intrinsics.throwNpe();
                }
                return (PsiElement)CodeInsightUtils.getTopmostElementAtOffset((PsiElement)ktExpression, lineStartOffset, KtExpression.class);
            }
            result2 = KotlinEditorTextProvider.Companion.findExpressionInner(elementAt, true);
            if (this.check(result2)) {
                return (PsiElement)result2;
            }
            return (PsiElement)containingFile;
        }

        private final boolean check(@Nullable KtElement $receiver) {
            return $receiver != null && AddToStdlibKt.check($receiver, check.1.INSTANCE) != null;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Pair<String, Map<String, Value>> createCodeFragmentForLabeledObjects(@NotNull Project project, @NotNull Map<?, ? extends ValueMarkup> markupMap) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull(markupMap, (String)"markupMap");
            Iterable iterable = markupMap.entrySet();
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
            void var6_6 = $receiver$iv;
            Map map2 = new LinkedHashMap(capacity$iv);
            for (Object element$iv$iv : $receiver$iv$iv) {
                void value2;
                void markup;
                Map.Entry it;
                Map.Entry entry;
                void var10_12 = destination$iv$iv;
                Map.Entry entry2 = entry = (it = (Map.Entry)element$iv$iv);
                Object k = entry2.getKey();
                entry2 = entry;
                ValueMarkup valueMarkup = (ValueMarkup)entry2.getValue();
                entry = null;
                String string = markup.getText() + Companion.getDEBUG_LABEL_SUFFIX();
                Object v1 = value2;
                if (!(v1 instanceof Value)) {
                    v1 = null;
                }
                Pair pair2 = TuplesKt.to((Object)string, (Object)v1);
                var10_12.put(pair2.getFirst(), pair2.getSecond());
            }
            $receiver$iv = destination$iv$iv;
            LinkedHashMap result$iv = new LinkedHashMap();
            var6_6 = $receiver$iv;
            for (Map.Entry entry : var6_6.entrySet()) {
                Value it = (Value)entry.getValue();
                if (!(it != null)) continue;
                result$iv.put(entry.getKey(), entry.getValue());
            }
            Map variables = result$iv;
            return TuplesKt.to((Object)this.kotlinVariablesAsText(variables, project), (Object)variables);
        }

        private final String kotlinVariablesAsText(@NotNull Map<String, ? extends Value> $receiver, Project project) {
            StringBuilder sb = new StringBuilder();
            PsiNameHelper psiNameHelper = PsiNameHelper.getInstance((Project)project);
            Iterator<Map.Entry<String, ? extends Value>> iterator2 = $receiver.entrySet().iterator();
            while (iterator2.hasNext()) {
                KtProperty kotlinProperty;
                Map.Entry<String, ? extends Value> entry;
                Map.Entry<String, ? extends Value> entry2 = entry = iterator2.next();
                String variableName = entry2.getKey();
                Map.Entry<String, ? extends Value> entry3 = entry;
                Value variableValue = entry3.getValue();
                if (!psiNameHelper.isIdentifier(variableName)) continue;
                String string = variableValue.type().name();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variableValue.type().name()");
                if (this.createKotlinProperty(project, variableName, string, variableValue) == null) {
                    continue;
                }
                sb.append(kotlinProperty.getText() + "\n");
            }
            sb.append("val _debug_context_val = 1\n");
            String string = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
            return string;
        }

        private final KtProperty createKotlinProperty(Project project, String variableName, String variableTypeName, Value value2) {
            KtProperty ktField;
            block2: {
                KtElementImplStub ktElementImplStub;
                Type type2 = JdiValuesKt.asValue(value2).getAsmType();
                GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
                Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"GlobalSearchScope.allScope(project)");
                ClassDescriptor actualClassDescriptor = KotlinEvaluationBuilderKt.getClassDescriptor(type2, globalSearchScope);
                if (actualClassDescriptor != null && actualClassDescriptor.getDefaultType().getArguments().isEmpty()) {
                    String renderedType = IdeDescriptorRenderers.SOURCE_CODE.renderType(TypeUtilsKt.makeNullable(actualClassDescriptor.getDefaultType()));
                    return new KtPsiFactory(project).createProperty(UtilsKt.quoteIfNeeded(variableName), renderedType, false);
                }
                Function1<String, String> addArraySuffix$ = new Function1<String, String>(value2){
                    final /* synthetic */ Value $value;

                    @NotNull
                    public final String invoke(@NotNull String $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        return this.$value instanceof ArrayReference ? $receiver + "[]" : $receiver;
                    }
                    {
                        this.$value = value2;
                        super(1);
                    }
                };
                String className2 = StringsKt.substringBefore$default((String)StringsKt.replace$default((String)variableTypeName, (String)"$", (String)".", (boolean)false, (int)4, null), (String)"[]", null, (int)2, null);
                PsiClassType classType = PsiType.getTypeByName((String)className2, (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
                String type3 = addArraySuffix$.invoke(!(value2 instanceof PrimitiveValue) && classType.resolve() == null ? "java.lang.Object" : className2);
                PsiField field2 = PsiElementFactory.SERVICE.getInstance((Project)project).createField(variableName, (PsiType)PsiType.getTypeByName((String)type3, (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project)));
                KtNamedDeclaration ktNamedDeclaration = KotlinRefactoringUtilKt.j2k((PsiMember)field2);
                if (!(ktNamedDeclaration instanceof KtProperty)) {
                    ktNamedDeclaration = null;
                }
                if ((ktElementImplStub = (ktField = (KtProperty)ktNamedDeclaration)) == null || (ktElementImplStub = ((KtModifierListOwnerStub)ktElementImplStub).getModifierList()) == null) break block2;
                ktElementImplStub.delete();
            }
            return ktField;
        }

        private Companion() {
        }

        @Nullable
        public static final /* synthetic */ KtProperty access$createKotlinProperty(Companion $this, @NotNull Project project, @NotNull String variableName, @NotNull String variableTypeName, @NotNull Value value2) {
            return $this.createKotlinProperty(project, variableName, variableTypeName, value2);
        }

        @NotNull
        public static final /* synthetic */ String access$kotlinVariablesAsText(Companion $this, @NotNull Map $receiver, @NotNull Project project) {
            return $this.kotlinVariablesAsText($receiver, project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

