/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.framework.FrameworksCompatibilityUtils;
import org.jetbrains.kotlin.idea.framework.JSFrameworkType;
import org.jetbrains.kotlin.idea.framework.JSLibraryStdDescription;
import org.jetbrains.kotlin.idea.framework.JavaFrameworkType;
import org.jetbrains.kotlin.idea.framework.JavaRuntimeLibraryDescription;

class JavaFrameworkSupportProvider
extends FrameworkSupportInModuleProvider {
    JavaFrameworkSupportProvider() {
    }

    @NotNull
    public FrameworkTypeEx getFrameworkType() {
        JavaFrameworkType javaFrameworkType = JavaFrameworkType.getInstance();
        if (javaFrameworkType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/framework/JavaFrameworkSupportProvider", "getFrameworkType"));
        }
        return javaFrameworkType;
    }

    @NotNull
    public FrameworkSupportInModuleConfigurable createConfigurable(final @NotNull FrameworkSupportModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/kotlin/idea/framework/JavaFrameworkSupportProvider", "createConfigurable"));
        }
        FrameworkSupportInModuleConfigurable frameworkSupportInModuleConfigurable = new FrameworkSupportInModuleConfigurable(){
            private JavaRuntimeLibraryDescription description = null;

            @Nullable
            public CustomLibraryDescription createLibraryDescription() {
                this.description = new JavaRuntimeLibraryDescription(model.getProject());
                return this.description;
            }

            @Nullable
            public JComponent createComponent() {
                return null;
            }

            public boolean isOnlyLibraryAdded() {
                return true;
            }

            public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel, @NotNull ModifiableModelsProvider modifiableModelsProvider) {
                if (module == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/framework/JavaFrameworkSupportProvider$1", "addSupport"));
                }
                if (rootModel == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "org/jetbrains/kotlin/idea/framework/JavaFrameworkSupportProvider$1", "addSupport"));
                }
                if (modifiableModelsProvider == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiableModelsProvider", "org/jetbrains/kotlin/idea/framework/JavaFrameworkSupportProvider$1", "addSupport"));
                }
                FrameworksCompatibilityUtils.suggestRemoveIncompatibleFramework(rootModel, JSLibraryStdDescription.SUITABLE_LIBRARY_KINDS, (FrameworkType)JSFrameworkType.getInstance());
                this.description.finishLibConfiguration(module, rootModel);
            }

            public void onFrameworkSelectionChanged(boolean selected) {
                String providerId;
                if (selected && model.isFrameworkSelected(providerId = JSFrameworkType.getInstance().getId())) {
                    model.setFrameworkComponentEnabled(providerId, false);
                }
            }
        };
        if (frameworkSupportInModuleConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/framework/JavaFrameworkSupportProvider", "createConfigurable"));
        }
        return frameworkSupportInModuleConfigurable;
    }

    public boolean isEnabledForModuleType(@NotNull ModuleType moduleType) {
        if (moduleType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleType", "org/jetbrains/kotlin/idea/framework/JavaFrameworkSupportProvider", "isEnabledForModuleType"));
        }
        return moduleType instanceof JavaModuleType;
    }
}

