/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.ConvertReceiverToParameterIntention;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureConfiguration;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMutableMethodDescriptor;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertReceiverToParameterIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "configureChangeSignature", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinChangeSignatureConfiguration;", "isApplicableTo", "", "startInWriteAction", "idea"})
public final class ConvertReceiverToParameterIntention
extends SelfTargetingOffsetIndependentIntention<KtTypeReference>
implements LowPriorityAction {
    @Override
    public boolean isApplicableTo(@NotNull KtTypeReference element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        PsiElement psiElement = element2.getParent();
        if (!(psiElement instanceof KtNamedFunction)) {
            psiElement = null;
        }
        KtNamedFunction ktNamedFunction = (KtNamedFunction)psiElement;
        return Intrinsics.areEqual((Object)(ktNamedFunction != null ? ktNamedFunction.getReceiverTypeReference() : null), (Object)element2);
    }

    private final KotlinChangeSignatureConfiguration configureChangeSignature() {
        return new KotlinChangeSignatureConfiguration(){

            @NotNull
            public KotlinMethodDescriptor configure(@NotNull KotlinMethodDescriptor originalDescriptor) {
                Intrinsics.checkParameterIsNotNull((Object)originalDescriptor, (String)"originalDescriptor");
                return KotlinChangeSignatureKt.modify(originalDescriptor, (Function1<? super KotlinMutableMethodDescriptor, Unit>)((Function1)configureChangeSignature.configure.1.INSTANCE));
            }

            public boolean performSilently(@NotNull Collection<? extends PsiElement> affectedFunctions) {
                Intrinsics.checkParameterIsNotNull(affectedFunctions, (String)"affectedFunctions");
                return KotlinChangeSignatureConfiguration.DefaultImpls.performSilently(this, affectedFunctions);
            }

            public boolean forcePerformForSelectedFunctionOnly() {
                return KotlinChangeSignatureConfiguration.DefaultImpls.forcePerformForSelectedFunctionOnly(this);
            }
        };
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void applyTo(@NotNull KtTypeReference element2, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        PsiElement psiElement = element2.getParent();
        if (!(psiElement instanceof KtNamedFunction)) {
            psiElement = null;
        }
        KtNamedFunction ktNamedFunction = (KtNamedFunction)psiElement;
        if (ktNamedFunction == null) {
            return;
        }
        KtNamedFunction function2 = ktNamedFunction;
        BindingContext context = ResolutionUtils.analyze$default(function2, null, 1, null);
        DeclarationDescriptor declarationDescriptor = context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, function2);
        if (!(declarationDescriptor instanceof FunctionDescriptor)) {
            declarationDescriptor = null;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)declarationDescriptor;
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor descriptor2 = functionDescriptor;
        Project project = element2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"element.project");
        KotlinChangeSignatureKt.runChangeSignature(project, descriptor2, this.configureChangeSignature(), (PsiElement)element2, this.getText());
    }

    public ConvertReceiverToParameterIntention() {
        super(KtTypeReference.class, "Convert receiver to parameter", null, 4, null);
    }
}

