/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.quickfix.AddFunctionToSupertypeFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002\u0019\u001aB\u001d\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0012\u001a\u00020\nH\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016J\"\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddFunctionToSupertypeFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "element", "functions", "", "Lorg/jetbrains/kotlin/idea/quickfix/AddFunctionToSupertypeFix$FunctionData;", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Ljava/util/List;)V", "actionName", "", "functionData", "addFunction", "", "project", "Lcom/intellij/openapi/project/Project;", "createFunctionPopup", "Lcom/intellij/openapi/ui/popup/ListPopupStep;", "getFamilyName", "getText", "invoke", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "FunctionData", "idea"})
public final class AddFunctionToSupertypeFix
extends KotlinQuickFixAction<KtNamedFunction>
implements LowPriorityAction {
    private final List<FunctionData> functions;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        FunctionData single = (FunctionData)CollectionsKt.singleOrNull(this.functions);
        return single != null ? this.actionName(single) : "Add function to supertype...";
    }

    @NotNull
    public String getFamilyName() {
        return "Add function to supertype";
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(this, editor, project){
            final /* synthetic */ AddFunctionToSupertypeFix this$0;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ Project $project;

            public final void run() {
                if (AddFunctionToSupertypeFix.access$getFunctions$p(this.this$0).size() == 1 || this.$editor == null || !this.$editor.getComponent().isShowing()) {
                    AddFunctionToSupertypeFix.access$addFunction(this.this$0, (FunctionData)CollectionsKt.first((List)AddFunctionToSupertypeFix.access$getFunctions$p(this.this$0)), this.$project);
                } else {
                    JBPopupFactory.getInstance().createListPopup(AddFunctionToSupertypeFix.access$createFunctionPopup(this.this$0, this.$project)).showInBestPositionFor(this.$editor);
                }
            }
            {
                this.this$0 = addFunctionToSupertypeFix;
                this.$editor = editor;
                this.$project = project;
            }
        });
    }

    private final void addFunction(FunctionData functionData, Project project) {
        ApplicationUtilsKt.executeWriteCommand(project, "Add Function to Type", (Function0<Unit>)((Function0)new Function0<Unit>(functionData, project){
            final /* synthetic */ FunctionData $functionData;
            final /* synthetic */ Project $project;

            public final void invoke() {
                KtClassBody classBody = KtClassOrObjectKt.getOrCreateBody(this.$functionData.getTargetClass());
                KtNamedFunction functionElement = new KtPsiFactory(this.$project).createFunction(this.$functionData.getSourceCode());
                PsiElement psiElement = classBody.addBefore(functionElement, classBody.getRBrace());
                if (psiElement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedFunction");
                }
                KtNamedFunction insertedFunctionElement = (KtNamedFunction)psiElement;
                ShortenReferences.process$default(ShortenReferences.DEFAULT, insertedFunctionElement, null, 2, null);
            }
            {
                this.$functionData = functionData;
                this.$project = project;
                super(0);
            }
        }));
    }

    private final ListPopupStep<?> createFunctionPopup(Project project) {
        return (ListPopupStep)new BaseListPopupStep<FunctionData>(this, project, "Choose Type", this.functions){
            final /* synthetic */ AddFunctionToSupertypeFix this$0;
            final /* synthetic */ Project $project;

            public boolean isAutoSelectionEnabled() {
                return false;
            }

            @Nullable
            public PopupStep<?> onChosen(@NotNull FunctionData selectedValue, boolean finalChoice) {
                Intrinsics.checkParameterIsNotNull((Object)selectedValue, (String)"selectedValue");
                if (finalChoice) {
                    AddFunctionToSupertypeFix.access$addFunction(this.this$0, selectedValue, this.$project);
                }
                return PopupStep.FINAL_CHOICE;
            }

            public Icon getIconFor(@NotNull FunctionData value2) {
                Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
                return PlatformIcons.FUNCTION_ICON;
            }

            @NotNull
            public String getTextFor(@NotNull FunctionData value2) {
                Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
                return AddFunctionToSupertypeFix.access$actionName(this.this$0, value2);
            }
            {
                this.this$0 = $outer;
                this.$project = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3);
            }
        };
    }

    private final String actionName(FunctionData functionData) {
        return "Add '" + functionData.getSignaturePreview() + "' to '" + functionData.getTargetClass().getName() + "'";
    }

    private AddFunctionToSupertypeFix(KtNamedFunction element2, List<FunctionData> functions2) {
        super((PsiElement)element2);
        this.functions = functions2;
        Collection collection = this.functions;
        boolean bl = !collection.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    @NotNull
    public static final /* synthetic */ List access$getFunctions$p(AddFunctionToSupertypeFix $this) {
        return $this.functions;
    }

    public static final /* synthetic */ void access$addFunction(AddFunctionToSupertypeFix $this, @NotNull FunctionData functionData, @NotNull Project project) {
        $this.addFunction(functionData, project);
    }

    @NotNull
    public static final /* synthetic */ ListPopupStep access$createFunctionPopup(AddFunctionToSupertypeFix $this, @NotNull Project project) {
        return $this.createFunctionPopup(project);
    }

    @NotNull
    public static final /* synthetic */ String access$actionName(AddFunctionToSupertypeFix $this, @NotNull FunctionData functionData) {
        return $this.actionName(functionData);
    }

    public /* synthetic */ AddFunctionToSupertypeFix(@NotNull KtNamedFunction element2, @NotNull List functions2, DefaultConstructorMarker $constructor_marker) {
        this(element2, functions2);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddFunctionToSupertypeFix$FunctionData;", "", "signaturePreview", "", "sourceCode", "targetClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/psi/KtClass;)V", "getSignaturePreview", "()Ljava/lang/String;", "getSourceCode", "getTargetClass", "()Lorg/jetbrains/kotlin/psi/KtClass;", "idea"})
    private static final class FunctionData {
        @NotNull
        private final String signaturePreview;
        @NotNull
        private final String sourceCode;
        @NotNull
        private final KtClass targetClass;

        @NotNull
        public final String getSignaturePreview() {
            return this.signaturePreview;
        }

        @NotNull
        public final String getSourceCode() {
            return this.sourceCode;
        }

        @NotNull
        public final KtClass getTargetClass() {
            return this.targetClass;
        }

        public FunctionData(@NotNull String signaturePreview, @NotNull String sourceCode, @NotNull KtClass targetClass) {
            Intrinsics.checkParameterIsNotNull((Object)signaturePreview, (String)"signaturePreview");
            Intrinsics.checkParameterIsNotNull((Object)sourceCode, (String)"sourceCode");
            Intrinsics.checkParameterIsNotNull((Object)targetClass, (String)"targetClass");
            this.signaturePreview = signaturePreview;
            this.sourceCode = sourceCode;
            this.targetClass = targetClass;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u0015\u001a\u00020\u000fH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddFunctionToSupertypeFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "createFunctionData", "Lorg/jetbrains/kotlin/idea/quickfix/AddFunctionToSupertypeFix$FunctionData;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "generateFunctionSignatureForType", "typeDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "generateFunctionsToAdd", "", "functionElement", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "getSuperClasses", "classDescriptor", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            void destination$iv$iv;
            void $receiver$iv$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement = diagnostic.getPsiElement();
            if (!(psiElement instanceof KtNamedFunction)) {
                psiElement = null;
            }
            KtNamedFunction ktNamedFunction = (KtNamedFunction)psiElement;
            if (ktNamedFunction == null) {
                return null;
            }
            KtNamedFunction function2 = ktNamedFunction;
            List<FunctionDescriptor> descriptors = this.generateFunctionsToAdd(function2);
            if (descriptors.isEmpty()) {
                return null;
            }
            Project project = diagnostic.getPsiFile().getProject();
            Iterable iterable = descriptors;
            void var7_6 = $receiver$iv;
            Collection collection = new ArrayList();
            void var9_8 = $receiver$iv$iv;
            Iterator iterator2 = $receiver$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FunctionData functionData;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                FunctionDescriptor it = (FunctionDescriptor)element$iv$iv;
                Project project2 = project;
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
                if (Companion.createFunctionData(it, project2) == null) continue;
                FunctionData it$iv$iv = functionData;
                destination$iv$iv.add(it$iv$iv);
            }
            List functionData = (List)destination$iv$iv;
            if (functionData.isEmpty()) {
                return null;
            }
            return new AddFunctionToSupertypeFix(function2, functionData, null);
        }

        private final FunctionData createFunctionData(FunctionDescriptor functionDescriptor, Project project) {
            PsiElement psiElement;
            DeclarationDescriptor declarationDescriptor = functionDescriptor.getContainingDeclaration();
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
            String sourceCode = IdeDescriptorRenderers.SOURCE_CODE.render(functionDescriptor);
            if (Intrinsics.areEqual((Object)((Object)classDescriptor.getKind()), (Object)((Object)ClassKind.INTERFACE)) ^ true && Intrinsics.areEqual((Object)((Object)functionDescriptor.getModality()), (Object)((Object)Modality.ABSTRACT)) ^ true) {
                KotlinType returnType2 = functionDescriptor.getReturnType();
                sourceCode = returnType2 == null || !KotlinBuiltIns.isUnit(returnType2) ? sourceCode + "{ throw UnsupportedOperationException() }" : sourceCode + "{}";
            }
            if (!((psiElement = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project, classDescriptor)) instanceof KtClass)) {
                psiElement = null;
            }
            KtClass ktClass = (KtClass)psiElement;
            if (ktClass == null) {
                return null;
            }
            KtClass targetClass = ktClass;
            return new FunctionData(IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.render(functionDescriptor), sourceCode, targetClass);
        }

        private final List<FunctionDescriptor> generateFunctionsToAdd(KtNamedFunction functionElement) {
            Collection destination$iv$iv;
            ClassDescriptor it;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptor(functionElement);
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
            }
            FunctionDescriptor functionDescriptor = (FunctionDescriptor)declarationDescriptor;
            DeclarationDescriptor declarationDescriptor2 = functionDescriptor.getContainingDeclaration();
            if (!(declarationDescriptor2 instanceof ClassDescriptor)) {
                declarationDescriptor2 = null;
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor2;
            if (classDescriptor == null) {
                return CollectionsKt.emptyList();
            }
            ClassDescriptor containingClass = classDescriptor;
            Iterable iterable = this.getSuperClasses(containingClass);
            void var5_5 = $receiver$iv;
            Collection collection = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (ClassDescriptor)element$iv$iv;
                if (KotlinBuiltIns.isAnyOrNullableAny(it.getDefaultType())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                it = (ClassDescriptor)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                FunctionDescriptor functionDescriptor2 = Companion.generateFunctionSignatureForType(functionDescriptor, it);
                collection2.add(functionDescriptor2);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final List<ClassDescriptor> getSuperClasses(ClassDescriptor classDescriptor) {
            void destination$iv$iv;
            void $receiver$iv$iv$iv;
            void $receiver$iv$iv;
            List supertypes2 = CollectionsKt.sortedWith((Iterable)TypeUtilsKt.supertypes(classDescriptor.getDefaultType()), (Comparator)getSuperClasses.supertypes.1.INSTANCE);
            Iterable $receiver$iv = supertypes2;
            Iterable iterable = $receiver$iv;
            Collection collection = new ArrayList();
            void var6_6 = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                ClassDescriptor classDescriptor2;
                Object element$iv$iv = element$iv$iv$iv;
                KotlinType it = (KotlinType)element$iv$iv;
                ClassifierDescriptor classifierDescriptor = it.getConstructor().getDeclarationDescriptor();
                if (!(classifierDescriptor instanceof ClassDescriptor)) {
                    classifierDescriptor = null;
                }
                if ((ClassDescriptor)classifierDescriptor == null) continue;
                ClassDescriptor it$iv$iv = classDescriptor2;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final FunctionDescriptor generateFunctionSignatureForType(FunctionDescriptor functionDescriptor, ClassDescriptor typeDescriptor) {
            Modality modality;
            if (Intrinsics.areEqual((Object)((Object)typeDescriptor.getKind()), (Object)((Object)ClassKind.INTERFACE))) {
                modality = Modality.OPEN;
            } else {
                Modality modality2 = typeDescriptor.getModality();
                modality = modality2;
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)modality2), (String)"typeDescriptor.modality");
            }
            Modality modality3 = modality;
            FunctionDescriptor functionDescriptor2 = functionDescriptor.copy(typeDescriptor, modality3, functionDescriptor.getVisibility(), CallableMemberDescriptor.Kind.DECLARATION, false);
            Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor2, (String)"functionDescriptor.copy(\u2026copyOverrides = */ false)");
            return functionDescriptor2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

