/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.MakeConstructorParameterPropertyFixKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinValVar;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0016H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MakeConstructorParameterPropertyFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "element", "kotlinValVar", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinValVar;", "className", "", "(Lorg/jetbrains/kotlin/psi/KtParameter;Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinValVar;Ljava/lang/String;)V", "suffix", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "", "Lcom/intellij/psi/PsiFile;", "Factory", "idea"})
public final class MakeConstructorParameterPropertyFix
extends KotlinQuickFixAction<KtParameter> {
    private final String suffix;
    private final KotlinValVar kotlinValVar;
    public static final Factory Factory = new Factory(null);

    @NotNull
    public String getFamilyName() {
        return "Make constructor parameter a property";
    }

    @NotNull
    public String getText() {
        return "Make constructor parameter a property" + this.suffix;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return super.isAvailable(project, editor, file2) && !((KtParameter)this.getElement()).hasValOrVar();
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        block3: {
            Editor editor2;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            KtParameter ktParameter = (KtParameter)this.getElement();
            PsiElement psiElement = this.kotlinValVar.createKeyword(new KtPsiFactory(project));
            if (psiElement == null) {
                Intrinsics.throwNpe();
            }
            ktParameter.addBefore(psiElement, ((KtParameter)this.getElement()).getFirstChild());
            ((KtParameter)this.getElement()).addModifier(KtTokens.PRIVATE_KEYWORD);
            PsiElement psiElement2 = KtPsiUtilKt.visibilityModifier((KtDeclaration)this.getElement());
            if (psiElement2 == null) break block3;
            PsiElement psiElement3 = psiElement2;
            PsiElement psiElement4 = psiElement3;
            Editor editor3 = editor;
            if (editor3 != null) {
                Editor editor4 = editor3;
                Editor $receiver = editor4;
                $receiver.getSelectionModel().setSelection(PsiUtilsKt.getStartOffset(psiElement4), PsiUtilsKt.getEndOffset(psiElement4));
                $receiver.getCaretModel().moveToOffset(PsiUtilsKt.getEndOffset(psiElement4));
                editor2 = editor4;
            } else {
                editor2 = null;
            }
        }
    }

    public MakeConstructorParameterPropertyFix(@NotNull KtParameter element2, @NotNull KotlinValVar kotlinValVar, @Nullable String className2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)((Object)kotlinValVar), (String)"kotlinValVar");
        super((PsiElement)element2);
        this.kotlinValVar = kotlinValVar;
        this.suffix = className2 != null ? " in class '" + className2 + "'" : "";
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MakeConstructorParameterPropertyFix$Factory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Factory
    extends KotlinIntentionActionsFactory {
        @Override
        @NotNull
        protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
            KtClass containingClass;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            Object a = ((DiagnosticWithParameters1)Errors.UNRESOLVED_REFERENCE.cast(diagnostic)).getA();
            if (!(a instanceof KtNameReferenceExpression)) {
                a = null;
            }
            KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)a;
            if (ktNameReferenceExpression == null) {
                return CollectionsKt.emptyList();
            }
            KtNameReferenceExpression ktReference = ktNameReferenceExpression;
            KotlinValVar valOrVar = KtPsiUtilKt.getAssignmentByLHS(ktReference) != null ? KotlinValVar.Var : KotlinValVar.Val;
            KtParameter ktParameter = MakeConstructorParameterPropertyFixKt.getPrimaryConstructorParameterWithSameName(ktReference);
            if (ktParameter == null) {
                return CollectionsKt.emptyList();
            }
            KtParameter ktParameter2 = ktParameter;
            KtClass ktClass = KtPsiUtilKt.containingClass(ktParameter2);
            if (ktClass == null) {
                Intrinsics.throwNpe();
            }
            String className2 = Intrinsics.areEqual((Object)(containingClass = ktClass), (Object)KtPsiUtilKt.containingClass(ktReference)) ^ true ? containingClass.getNameAsSafeName().asString() : (String)null;
            return CollectionsKt.listOf((Object)new MakeConstructorParameterPropertyFix(ktParameter2, valOrVar, className2));
        }

        private Factory() {
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

