/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.AbstractDiagnostic;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.AddArrayOfTypeFix;
import org.jetbrains.kotlin.idea.quickfix.AddExclExclCallFix;
import org.jetbrains.kotlin.idea.quickfix.AddToStringFix;
import org.jetbrains.kotlin.idea.quickfix.CastExpressionFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeFunctionReturnTypeFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeParameterTypeFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeVariableTypeFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.LetImplementInterfaceFix;
import org.jetbrains.kotlin.idea.quickfix.NumberConversionFix;
import org.jetbrains.kotlin.idea.quickfix.WrongPrimitiveLiteralFix;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.idea.util.TypeUtils;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/QuickFixFactoryForTypeMismatchError;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "Companion", "idea"})
public final class QuickFixFactoryForTypeMismatchError
extends KotlinIntentionActionsFactory {
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    @NotNull
    protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2;
        KotlinType expressionType;
        PsiElement diagnosticElement;
        BindingContext context;
        LinkedList<Object> actions2;
        block35: {
            KotlinType expectedType;
            block37: {
                block36: {
                    KtAnnotationEntry annotationEntry2;
                    KtFunction declaration;
                    ResolvedCall<? extends CallableDescriptor> resolvedCall3;
                    PsiElement expressionParent;
                    KtCallableDeclaration function2;
                    KotlinType typeToInsert;
                    LexicalScope scope2;
                    KtProperty property2;
                    KotlinType nullableExpected;
                    AbstractDiagnostic diagnosticWithParameters;
                    Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
                    actions2 = new LinkedList<Object>();
                    PsiFile psiFile = diagnostic.getPsiFile();
                    if (psiFile == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                    }
                    context = ResolutionUtils.analyzeFully((KtFile)psiFile);
                    diagnosticElement = diagnostic.getPsiElement();
                    if (!(diagnosticElement instanceof KtExpression)) {
                        QuickFixFactoryForTypeMismatchError.Companion.getLOG().error("Unexpected element: " + diagnosticElement.getText());
                        return CollectionsKt.emptyList();
                    }
                    if (diagnostic.getFactory() == Errors.TYPE_MISMATCH) {
                        diagnosticWithParameters = (DiagnosticWithParameters2)Errors.TYPE_MISMATCH.cast(diagnostic);
                        Object a = ((DiagnosticWithParameters2)diagnosticWithParameters).getA();
                        Intrinsics.checkExpressionValueIsNotNull(a, (String)"diagnosticWithParameters.a");
                        expectedType = (KotlinType)a;
                        expressionType = (KotlinType)((DiagnosticWithParameters2)diagnosticWithParameters).getB();
                    } else if (diagnostic.getFactory() == Errors.NULL_FOR_NONNULL_TYPE) {
                        diagnosticWithParameters = (DiagnosticWithParameters1)Errors.NULL_FOR_NONNULL_TYPE.cast(diagnostic);
                        Object a = ((DiagnosticWithParameters1)diagnosticWithParameters).getA();
                        Intrinsics.checkExpressionValueIsNotNull(a, (String)"diagnosticWithParameters.a");
                        expectedType = (KotlinType)a;
                        expressionType = TypeUtilsKt.makeNullable(expectedType);
                    } else if (diagnostic.getFactory() == Errors.CONSTANT_EXPECTED_TYPE_MISMATCH) {
                        diagnosticWithParameters = (DiagnosticWithParameters2)Errors.CONSTANT_EXPECTED_TYPE_MISMATCH.cast(diagnostic);
                        Object b = ((DiagnosticWithParameters2)diagnosticWithParameters).getB();
                        Intrinsics.checkExpressionValueIsNotNull(b, (String)"diagnosticWithParameters.b");
                        expectedType = (KotlinType)b;
                        expressionType = context.getType((KtExpression)diagnosticElement);
                        if (expressionType == null) {
                            QuickFixFactoryForTypeMismatchError.Companion.getLOG().error("No type inferred: " + ((KtExpression)diagnosticElement).getText());
                            return CollectionsKt.emptyList();
                        }
                    } else {
                        QuickFixFactoryForTypeMismatchError.Companion.getLOG().error("Unexpected diagnostic: " + DefaultErrorMessages.render(diagnostic));
                        return CollectionsKt.emptyList();
                    }
                    if (TypeUtilsKt.isPrimitiveNumberType(expressionType) && TypeUtilsKt.isPrimitiveNumberType(expectedType)) {
                        WrongPrimitiveLiteralFix wrongPrimitiveLiteralFix = null;
                        if (diagnosticElement instanceof KtConstantExpression && !KotlinBuiltIns.isChar(expectedType)) {
                            KtConstantExpression ktConstantExpression = (KtConstantExpression)diagnosticElement;
                            Intrinsics.checkExpressionValueIsNotNull((Object)ktConstantExpression, (String)"diagnosticElement");
                            wrongPrimitiveLiteralFix = new WrongPrimitiveLiteralFix(ktConstantExpression, expectedType);
                            actions2.add(wrongPrimitiveLiteralFix);
                        }
                        KtExpression ktExpression = (KtExpression)diagnosticElement;
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"diagnosticElement");
                        actions2.add(new NumberConversionFix(ktExpression, expectedType, wrongPrimitiveLiteralFix));
                    }
                    if (KotlinBuiltIns.isCharSequenceOrNullableCharSequence(expectedType) || KotlinBuiltIns.isStringOrNullableString(expectedType)) {
                        KtExpression ktExpression = (KtExpression)diagnosticElement;
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"diagnosticElement");
                        actions2.add(new AddToStringFix(ktExpression, false));
                        if (expectedType.isMarkedNullable() && expressionType.isMarkedNullable()) {
                            KtExpression ktExpression2 = (KtExpression)diagnosticElement;
                            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"diagnosticElement");
                            actions2.add(new AddToStringFix(ktExpression2, true));
                        }
                    }
                    if (TypeUtilsKt.isInterface(expectedType)) {
                        KtClassOrObject expressionTypeDeclaration;
                        PsiElement psiElement;
                        PsiElement psiElement2;
                        Object it;
                        Object object;
                        ClassifierDescriptor classifierDescriptor = expressionType.getConstructor().getDeclarationDescriptor();
                        if (classifierDescriptor != null) {
                            object = classifierDescriptor;
                            it = object;
                            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"it");
                            psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
                        } else {
                            psiElement2 = psiElement = null;
                        }
                        if (!(psiElement2 instanceof KtClassOrObject)) {
                            psiElement = null;
                        }
                        KtClassOrObject ktClassOrObject = expressionTypeDeclaration = (KtClassOrObject)psiElement;
                        if (ktClassOrObject != null) {
                            object = ktClassOrObject;
                            it = (KtClassOrObject)object;
                            actions2.add(new LetImplementInterfaceFix((KtClassOrObject)it, expectedType, expressionType));
                        }
                    }
                    if (!(diagnosticElement instanceof KtBinaryExpressionWithTypeRHS) && !(((KtExpression)diagnosticElement).getParent() instanceof KtBinaryExpressionWithTypeRHS)) {
                        KtExpression ktExpression = (KtExpression)diagnosticElement;
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"diagnosticElement");
                        actions2.add(new CastExpressionFix(ktExpression, expectedType));
                    }
                    if (!expectedType.isMarkedNullable() && org.jetbrains.kotlin.types.TypeUtils.isNullableType(expressionType) && TypeUtilsKt.isSubtypeOf(expressionType, nullableExpected = TypeUtilsKt.makeNullable(expectedType))) {
                        PsiElement psiElement = diagnosticElement;
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"diagnosticElement");
                        actions2.add(new AddExclExclCallFix(psiElement));
                    }
                    if ((property2 = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)diagnosticElement, KtProperty.class)) != null) {
                        KtPropertyAccessor getter = property2.getGetter();
                        KtExpression initializer2 = property2.getInitializer();
                        if (QuickFixUtil.canEvaluateTo(initializer2, (KtExpression)diagnosticElement) || getter != null && QuickFixUtil.canFunctionOrGetterReturnExpression(getter, (KtExpression)diagnosticElement)) {
                            scope2 = ScopeUtils.getResolutionScope(property2, context, ResolutionUtils.getResolutionFacade(property2));
                            typeToInsert = TypeUtils.approximateWithResolvableType(expressionType, scope2, false);
                            actions2.add(new ChangeVariableTypeFix(property2, typeToInsert));
                        }
                    }
                    KtCallableDeclaration ktCallableDeclaration = function2 = (expressionParent = ((KtExpression)diagnosticElement).getParent()) instanceof KtReturnExpression ? BindingContextUtilsKt.getTargetFunction((KtReturnExpression)expressionParent, context) : (KtCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)diagnosticElement, KtFunction.class, (boolean)true);
                    if (function2 instanceof KtFunction && QuickFixUtil.canFunctionOrGetterReturnExpression(function2, (KtExpression)diagnosticElement)) {
                        scope2 = ScopeUtils.getResolutionScope(function2, context, ResolutionUtils.getResolutionFacade(function2));
                        typeToInsert = TypeUtils.approximateWithResolvableType(expressionType, scope2, false);
                        actions2.add(new ChangeFunctionReturnTypeFix((KtFunction)function2, typeToInsert));
                    }
                    if (diagnosticElement instanceof KtOperationExpression && (resolvedCall3 = CallUtilKt.getResolvedCall((KtElement)diagnosticElement, context)) != null && (declaration = QuickFixFactoryForTypeMismatchError.Companion.getFunctionDeclaration(resolvedCall3)) != null) {
                        actions2.add(new ChangeFunctionReturnTypeFix(declaration, expectedType));
                    }
                    if (diagnosticElement instanceof KtCallExpression && (resolvedCall3 = CallUtilKt.getResolvedCall((KtElement)diagnosticElement, context)) != null && (declaration = QuickFixFactoryForTypeMismatchError.Companion.getFunctionDeclaration(resolvedCall3)) != null) {
                        actions2.add(new ChangeFunctionReturnTypeFix(declaration, expectedType));
                    }
                    if ((annotationEntry2 = (KtAnnotationEntry)PsiTreeUtil.getParentOfType((PsiElement)diagnosticElement, KtAnnotationEntry.class)) == null) break block35;
                    if (!KotlinBuiltIns.isArray(expectedType)) break block36;
                    KotlinType kotlinType = expectedType.getArguments().get(0).getType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"expectedType.arguments[0].type");
                    if (TypeUtilsKt.isSubtypeOf(expressionType, kotlinType)) break block37;
                }
                if (!KotlinBuiltIns.isPrimitiveArray(expectedType)) break block35;
            }
            KtExpression ktExpression = (KtExpression)diagnosticElement;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"diagnosticElement");
            actions2.add(new AddArrayOfTypeFix(ktExpression, expectedType));
        }
        if ((resolvedCall2 = CallUtilKt.getParentResolvedCall((KtElement)diagnosticElement, context, true)) != null) {
            KtExpression ktExpression;
            KtIfExpression parentIf;
            KtIfExpression ktIfExpression = parentIf = QuickFixUtil.getParentIfForBranch((KtExpression)diagnosticElement);
            if (ktIfExpression != null) {
                ktExpression = ktIfExpression;
            } else {
                KtExpression ktExpression3 = (KtExpression)diagnosticElement;
                ktExpression = ktExpression3;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"diagnosticElement");
            }
            KtExpression argumentExpression = ktExpression;
            ValueArgument valueArgument = CallUtilKt.getValueArgumentForExpression(resolvedCall2.getCall(), argumentExpression);
            if (valueArgument != null) {
                KotlinType valueArgumentType;
                KtParameter correspondingParameter = QuickFixUtil.getParameterDeclarationForValueArgument(resolvedCall2, valueArgument);
                KtExpression expressionFromArgument = valueArgument.getArgumentExpression();
                KotlinType kotlinType = diagnostic.getFactory() == Errors.NULL_FOR_NONNULL_TYPE ? expressionType : (valueArgumentType = expressionFromArgument != null ? context.getType(expressionFromArgument) : (KotlinType)null);
                if (correspondingParameter != null && valueArgumentType != null) {
                    KtCallableDeclaration callable2;
                    KtCallableDeclaration ktCallableDeclaration = callable2 = (KtCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)correspondingParameter, KtCallableDeclaration.class, (boolean)true);
                    LexicalScope scope3 = ktCallableDeclaration != null ? ScopeUtils.getResolutionScope(ktCallableDeclaration, context, ResolutionUtils.getResolutionFacade(callable2)) : null;
                    KotlinType typeToInsert = TypeUtils.approximateWithResolvableType(valueArgumentType, scope3, true);
                    actions2.add(new ChangeParameterTypeFix(correspondingParameter, typeToInsert));
                }
            }
        }
        return actions2;
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(QuickFixFactoryForTypeMismatchError.class);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u0004\u0018\u00010\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002R\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/QuickFixFactoryForTypeMismatchError$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getFunctionDeclaration", "Lorg/jetbrains/kotlin/psi/KtFunction;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "idea"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        private final KtFunction getFunctionDeclaration(ResolvedCall<?> resolvedCall2) {
            PsiElement result2 = QuickFixUtil.safeGetDeclaration(resolvedCall2.getResultingDescriptor());
            if (result2 instanceof KtFunction) {
                return (KtFunction)result2;
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

