/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.intentions.SpecifyTypeExplicitlyIntention;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.types.KotlinType;

public class RemovePartsFromPropertyFix
extends KotlinQuickFixAction<KtProperty> {
    private final boolean removeInitializer;
    private final boolean removeGetter;
    private final boolean removeSetter;

    private RemovePartsFromPropertyFix(@NotNull KtProperty element2, boolean removeInitializer, boolean removeGetter, boolean removeSetter) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/RemovePartsFromPropertyFix", "<init>"));
        }
        super(element2);
        this.removeInitializer = removeInitializer;
        this.removeGetter = removeGetter;
        this.removeSetter = removeSetter;
    }

    private RemovePartsFromPropertyFix(@NotNull KtProperty element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/RemovePartsFromPropertyFix", "<init>"));
        }
        this(element2, element2.hasInitializer(), element2.getGetter() != null && element2.getGetter().getBodyExpression() != null, element2.getSetter() != null && element2.getSetter().getBodyExpression() != null);
    }

    private static String partsToRemove(boolean getter, boolean setter, boolean initializer2) {
        StringBuilder sb = new StringBuilder();
        if (getter) {
            sb.append("getter");
            if (setter && initializer2) {
                sb.append(", ");
            } else if (setter || initializer2) {
                sb.append(" and ");
            }
        }
        if (setter) {
            sb.append("setter");
            if (initializer2) {
                sb.append(" and ");
            }
        }
        if (initializer2) {
            sb.append("initializer");
        }
        return sb.toString();
    }

    @NotNull
    public String getText() {
        String string = KotlinBundle.message("remove.parts.from.property", RemovePartsFromPropertyFix.partsToRemove(this.removeGetter, this.removeSetter, this.removeInitializer));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/RemovePartsFromPropertyFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = KotlinBundle.message("remove.parts.from.property.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/RemovePartsFromPropertyFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/RemovePartsFromPropertyFix", "isAvailable"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/quickfix/RemovePartsFromPropertyFix", "isAvailable"));
        }
        if (!super.isAvailable(project, editor, file2)) {
            return false;
        }
        KotlinType type2 = QuickFixUtil.getDeclarationReturnType((KtNamedDeclaration)this.getElement());
        return type2 != null && !type2.isError();
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, @NotNull KtFile file2) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/RemovePartsFromPropertyFix", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/quickfix/RemovePartsFromPropertyFix", "invoke"));
        }
        KotlinType type2 = QuickFixUtil.getDeclarationReturnType((KtNamedDeclaration)this.getElement());
        KtProperty newElement = (KtProperty)((KtProperty)this.getElement()).copy();
        KtPropertyAccessor getter = newElement.getGetter();
        if (this.removeGetter && getter != null) {
            newElement.deleteChildInternal(getter.getNode());
        }
        KtPropertyAccessor setter = newElement.getSetter();
        if (this.removeSetter && setter != null) {
            newElement.deleteChildInternal(setter.getNode());
        }
        KtExpression initializer2 = newElement.getInitializer();
        KotlinType typeToAdd = null;
        if (this.removeInitializer && initializer2 != null) {
            PsiElement nameIdentifier = newElement.getNameIdentifier();
            assert (nameIdentifier != null);
            PsiElement nextSibling = nameIdentifier.getNextSibling();
            assert (nextSibling != null);
            newElement.deleteChildRange(nextSibling, (PsiElement)initializer2);
            if (newElement.getTypeReference() == null && type2 != null) {
                typeToAdd = type2;
            }
        }
        newElement = (KtProperty)((KtProperty)this.getElement()).replace(newElement);
        if (typeToAdd != null) {
            SpecifyTypeExplicitlyIntention.Companion.addTypeAnnotation(editor, newElement, typeToAdd);
        }
    }

    public static KotlinSingleIntentionActionFactory createFactory() {
        return new KotlinSingleIntentionActionFactory(){

            @Override
            public KotlinQuickFixAction<KtProperty> createAction(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/RemovePartsFromPropertyFix$1", "createAction"));
                }
                PsiElement element2 = diagnostic.getPsiElement();
                assert (element2 instanceof KtElement);
                KtProperty property2 = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)element2, KtProperty.class);
                if (property2 == null) {
                    return null;
                }
                return new RemovePartsFromPropertyFix(property2);
            }
        };
    }
}

