/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.SurroundWithNullCheckFix;
import org.jetbrains.kotlin.idea.quickfix.SurroundWithNullCheckFix$TypeMismatchFactory$createAction$;
import org.jetbrains.kotlin.idea.quickfix.SurroundWithNullCheckFixKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0013\u0014\u0015B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/SurroundWithNullCheckFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "nullableExpression", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/psi/KtExpression;)V", "getNullableExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "IteratorOnNullableFactory", "TypeMismatchFactory", "idea"})
public final class SurroundWithNullCheckFix
extends KotlinQuickFixAction<KtExpression> {
    @NotNull
    private final KtExpression nullableExpression;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return "Surround with null check";
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory(this.getElement());
        KtExpression surrounded = CreateByPatternKt.createExpressionByPattern(factory2, "if ($0 != null) { $1 }", this.nullableExpression, this.getElement());
        ((KtExpression)this.getElement()).replace((PsiElement)surrounded);
    }

    @NotNull
    public final KtExpression getNullableExpression() {
        return this.nullableExpression;
    }

    public SurroundWithNullCheckFix(@NotNull KtExpression expression2, @NotNull KtExpression nullableExpression) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)nullableExpression, (String)"nullableExpression");
        super((PsiElement)expression2);
        this.nullableExpression = nullableExpression;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/SurroundWithNullCheckFix$IteratorOnNullableFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class IteratorOnNullableFactory
    extends KotlinSingleIntentionActionFactory {
        public static final IteratorOnNullableFactory INSTANCE;

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement = diagnostic.getPsiElement();
            if (!(psiElement instanceof KtReferenceExpression)) {
                psiElement = null;
            }
            KtReferenceExpression ktReferenceExpression = (KtReferenceExpression)psiElement;
            if (ktReferenceExpression == null) {
                return null;
            }
            KtReferenceExpression nullableExpression = ktReferenceExpression;
            PsiElement psiElement2 = nullableExpression.getParent();
            Object object = psiElement2 != null ? psiElement2.getParent() : null;
            if (!(object instanceof KtForExpression)) {
                object = null;
            }
            KtForExpression ktForExpression = (KtForExpression)object;
            if (ktForExpression == null) {
                return null;
            }
            KtForExpression forExpression = ktForExpression;
            if (!(forExpression.getParent() instanceof KtBlockExpression)) {
                return null;
            }
            if (!SurroundWithNullCheckFixKt.access$isPredictable(nullableExpression)) {
                return null;
            }
            return new SurroundWithNullCheckFix(forExpression, nullableExpression);
        }

        private IteratorOnNullableFactory() {
            INSTANCE = this;
        }

        static {
            new IteratorOnNullableFactory();
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/SurroundWithNullCheckFix$TypeMismatchFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class TypeMismatchFactory
    extends KotlinSingleIntentionActionFactory {
        public static final TypeMismatchFactory INSTANCE;

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            KtExpression rootCall;
            void $receiver$iv;
            void strict$iv22;
            void $receiver$iv2;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            DiagnosticWithParameters2 typeMismatch = (DiagnosticWithParameters2)Errors.TYPE_MISMATCH.cast(diagnostic);
            Object e = typeMismatch.getPsiElement();
            if (!(e instanceof KtReferenceExpression)) {
                e = null;
            }
            KtReferenceExpression ktReferenceExpression = (KtReferenceExpression)e;
            if (ktReferenceExpression == null) {
                return null;
            }
            KtReferenceExpression nullableExpression = ktReferenceExpression;
            PsiElement psiElement = nullableExpression.getParent();
            if (!(psiElement instanceof KtValueArgument)) {
                psiElement = null;
            }
            KtValueArgument ktValueArgument = (KtValueArgument)psiElement;
            if (ktValueArgument == null) {
                return null;
            }
            KtValueArgument argument2 = ktValueArgument;
            PsiElement psiElement2 = (PsiElement)argument2;
            boolean bl = true;
            KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv2, KtCallExpression.class, (boolean)strict$iv22);
            if (ktCallExpression == null) {
                return null;
            }
            KtCallExpression call = ktCallExpression;
            PsiElement strict$iv22 = (PsiElement)call;
            Object object = SequencesKt.lastOrNull((Sequence)SequencesKt.takeWhile(PsiUtilsKt.getParents((PsiElement)$receiver$iv), (Function1)TypeMismatchFactory$createAction$$inlined$getLastParentOfTypeInRow$1.INSTANCE));
            if (!(object instanceof KtQualifiedExpression)) {
                object = null;
            }
            KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)object;
            KtExpression ktExpression = rootCall = ktQualifiedExpression != null ? (KtExpression)ktQualifiedExpression : (KtExpression)call;
            if (!(rootCall.getParent() instanceof KtBlockExpression)) {
                return null;
            }
            KotlinType kotlinType = (KotlinType)typeMismatch.getA();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"typeMismatch.a");
            KotlinType kotlinType2 = (KotlinType)typeMismatch.getB();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"typeMismatch.b");
            if (!TypeUtilsKt.isNullabilityMismatch(kotlinType, kotlinType2)) {
                return null;
            }
            if (!SurroundWithNullCheckFixKt.access$isPredictable(nullableExpression)) {
                return null;
            }
            return new SurroundWithNullCheckFix(rootCall, nullableExpression);
        }

        private TypeMismatchFactory() {
            INSTANCE = this;
        }

        static {
            new TypeMismatchFactory();
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/SurroundWithNullCheckFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            KtExpression ktExpression;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement element2 = diagnostic.getPsiElement();
            KtExpression ktExpression2 = (KtExpression)PsiUtilsKt.getParentOfTypesAndPredicate(element2, false, new Class[]{KtExpression.class}, createAction.expression.1.INSTANCE);
            if (ktExpression2 == null) {
                return null;
            }
            KtExpression expression2 = ktExpression2;
            if (expression2 instanceof KtDeclaration) {
                return null;
            }
            PsiElement parent2 = element2.getParent();
            PsiElement psiElement = parent2;
            if (psiElement instanceof KtDotQualifiedExpression) {
                ktExpression = ((KtDotQualifiedExpression)parent2).getReceiverExpression();
            } else if (psiElement instanceof KtBinaryExpression) {
                ktExpression = ((KtBinaryExpression)parent2).getLeft();
            } else if (psiElement instanceof KtCallExpression) {
                ktExpression = ((KtCallExpression)parent2).getCalleeExpression();
            } else {
                return null;
            }
            KtExpression ktExpression3 = ktExpression;
            if (!(ktExpression instanceof KtReferenceExpression)) {
                ktExpression3 = null;
            }
            KtReferenceExpression ktReferenceExpression = (KtReferenceExpression)ktExpression3;
            if (ktReferenceExpression == null) {
                return null;
            }
            KtReferenceExpression nullableExpression = ktReferenceExpression;
            if (!SurroundWithNullCheckFixKt.access$isPredictable(nullableExpression)) {
                return null;
            }
            return new SurroundWithNullCheckFix(expression2, nullableExpression);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

