/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.changePackage;

import com.intellij.CommonBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.moveClassesOrPackages.AutocreatingSingleSourceRootMoveDestination;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/changePackage/MoveFileToPackageMatchingDirectoryIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtPackageDirective;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "idea"})
public final class MoveFileToPackageMatchingDirectoryIntention
extends SelfTargetingOffsetIndependentIntention<KtPackageDirective> {
    @Override
    public boolean isApplicableTo(@NotNull KtPackageDirective element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (KotlinRefactoringUtilKt.isInsideInjectedFragment(element2)) {
            return false;
        }
        if (PackageUtilsKt.packageMatchesDirectory(element2.getContainingKtFile())) {
            return false;
        }
        String qualifiedName = element2.getQualifiedName();
        CharSequence charSequence = qualifiedName;
        String dirName = charSequence.length() == 0 ? "source root" : "'" + StringsKt.replace$default((String)qualifiedName, (char)'.', (char)'/', (boolean)false, (int)4, null) + "'";
        this.setText("Move file to " + dirName);
        return true;
    }

    @Override
    public void applyTo(@NotNull KtPackageDirective element2, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtFile file2 = element2.getContainingKtFile();
        Project project = file2.getProject();
        List sourceRoots = JavaProjectRootsUtil.getSuitableDestinationSourceRoots((Project)project);
        PackageWrapper packageWrapper = new PackageWrapper(PsiManager.getInstance((Project)project), element2.getQualifiedName());
        PsiFile fileToMove = element2.getContainingFile();
        VirtualFile virtualFile2 = (VirtualFile)CollectionsKt.singleOrNull((List)sourceRoots);
        if (virtualFile2 == null) {
            virtualFile2 = MoveClassesOrPackagesUtil.chooseSourceRoot((PackageWrapper)packageWrapper, (List)sourceRoots, (PsiDirectory)fileToMove.getContainingDirectory());
        }
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile chosenRoot = virtualFile2;
        AutocreatingSingleSourceRootMoveDestination targetDirFactory = new AutocreatingSingleSourceRootMoveDestination(packageWrapper, chosenRoot);
        String string = targetDirFactory.verify(fileToMove);
        if (string != null) {
            String string2 = string;
            String it = string2;
            Messages.showMessageDialog((Project)project, (String)it, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        PsiDirectory psiDirectory = targetDirFactory.getTargetDirectory(fileToMove);
        if (psiDirectory == null) {
            return;
        }
        PsiDirectory targetDirectory = psiDirectory;
        String string3 = RefactoringMessageUtil.checkCanCreateFile((PsiDirectory)targetDirectory, (String)file2.getName());
        if (string3 != null) {
            String string4 = string3;
            String it = string4;
            Messages.showMessageDialog((Project)project, (String)it, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        MoveFilesOrDirectoriesUtil.doMoveFile((PsiFile)((PsiFile)file2), (PsiDirectory)targetDirectory);
    }

    public MoveFileToPackageMatchingDirectoryIntention() {
        super(KtPackageDirective.class, "", "Move file to package-matching directory");
    }
}

