/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.config;

import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.js.config.EcmaVersion;
import org.jetbrains.kotlin.js.resolve.JsPlatform;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.TargetPlatformKt;
import org.jetbrains.kotlin.serialization.js.JsModuleDescriptor;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadata;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;

public abstract class JsConfig {
    private final boolean inlineEnabled;
    @NotNull
    private final Project project;
    @NotNull
    private final LockBasedStorageManager storageManager;
    @NotNull
    private final List<KtFile> sourceFilesFromLibraries;
    @NotNull
    private final EcmaVersion target;
    @NotNull
    private final String moduleId;
    @NotNull
    private final ModuleKind moduleKind;
    private final boolean sourcemap;
    private final boolean metaInfo;
    private final boolean kjsm;
    @NotNull
    protected final List<KotlinJavascriptMetadata> metadata;
    @Nullable
    private List<JsModuleDescriptor<ModuleDescriptorImpl>> moduleDescriptors;
    private boolean initialized;

    protected JsConfig(@NotNull Project project, @NotNull String moduleId, @NotNull ModuleKind moduleKind, @NotNull EcmaVersion ecmaVersion, boolean sourcemap, boolean inlineEnabled, boolean metaInfo, boolean kjsm) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/js/config/JsConfig", "<init>"));
        }
        if (moduleId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleId", "org/jetbrains/kotlin/js/config/JsConfig", "<init>"));
        }
        if (moduleKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleKind", "org/jetbrains/kotlin/js/config/JsConfig", "<init>"));
        }
        if (ecmaVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ecmaVersion", "org/jetbrains/kotlin/js/config/JsConfig", "<init>"));
        }
        this.storageManager = new LockBasedStorageManager();
        this.sourceFilesFromLibraries = new SmartList();
        this.metadata = new SmartList();
        this.moduleDescriptors = null;
        this.initialized = false;
        this.project = project;
        this.target = ecmaVersion;
        this.moduleId = moduleId;
        this.moduleKind = moduleKind;
        this.sourcemap = sourcemap;
        this.inlineEnabled = inlineEnabled;
        this.metaInfo = metaInfo;
        this.kjsm = kjsm;
    }

    public boolean isSourcemap() {
        return this.sourcemap;
    }

    public boolean isMetaInfo() {
        return this.metaInfo;
    }

    public boolean isKjsm() {
        return this.kjsm;
    }

    public boolean isInlineEnabled() {
        return this.inlineEnabled;
    }

    @NotNull
    public Project getProject() {
        Project project = this.project;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getProject"));
        }
        return project;
    }

    @NotNull
    public String getModuleId() {
        String string = this.moduleId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getModuleId"));
        }
        return string;
    }

    @NotNull
    public ModuleKind getModuleKind() {
        ModuleKind moduleKind = this.moduleKind;
        if (moduleKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getModuleKind"));
        }
        return moduleKind;
    }

    public abstract boolean checkLibFilesAndReportErrors(@NotNull Function1<String, Unit> var1);

    protected abstract void init(@NotNull List<KtFile> var1, @NotNull List<KotlinJavascriptMetadata> var2);

    @NotNull
    public List<JsModuleDescriptor<ModuleDescriptorImpl>> getModuleDescriptors() {
        this.init();
        if (this.moduleDescriptors != null) {
            List<JsModuleDescriptor<ModuleDescriptorImpl>> list2 = this.moduleDescriptors;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getModuleDescriptors"));
            }
            return list2;
        }
        this.moduleDescriptors = new SmartList();
        ArrayList<ModuleDescriptorImpl> kotlinModuleDescriptors = new ArrayList<ModuleDescriptorImpl>();
        for (KotlinJavascriptMetadata kotlinJavascriptMetadata : this.metadata) {
            JsModuleDescriptor<ModuleDescriptorImpl> descriptor2 = this.createModuleDescriptor(kotlinJavascriptMetadata);
            this.moduleDescriptors.add(descriptor2);
            kotlinModuleDescriptors.add(descriptor2.getData());
        }
        for (JsModuleDescriptor jsModuleDescriptor : this.moduleDescriptors) {
            JsConfig.setDependencies((ModuleDescriptorImpl)jsModuleDescriptor.getData(), kotlinModuleDescriptors);
        }
        List<JsModuleDescriptor<ModuleDescriptorImpl>> list3 = this.moduleDescriptors = Collections.unmodifiableList(this.moduleDescriptors);
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getModuleDescriptors"));
        }
        return list3;
    }

    @NotNull
    public List<KtFile> getSourceFilesFromLibraries() {
        this.init();
        List<KtFile> list2 = this.sourceFilesFromLibraries;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getSourceFilesFromLibraries"));
        }
        return list2;
    }

    public boolean isTestConfig() {
        return false;
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        this.init(this.sourceFilesFromLibraries, this.metadata);
        this.initialized = true;
    }

    private JsModuleDescriptor<ModuleDescriptorImpl> createModuleDescriptor(KotlinJavascriptMetadata metadata) {
        assert (metadata.isAbiVersionCompatible()) : "expected abi version " + KotlinJavascriptMetadataUtils.ABI_VERSION + ", but metadata.abiVersion = " + metadata.getAbiVersion();
        ModuleDescriptorImpl moduleDescriptor = TargetPlatformKt.createModule(JsPlatform.INSTANCE, Name.special("<" + metadata.getModuleName() + ">"), this.storageManager);
        JsModuleDescriptor<PackageFragmentProvider> rawDescriptor = KotlinJavascriptSerializationUtil.readModule(metadata.getBody(), this.storageManager, moduleDescriptor);
        PackageFragmentProvider provider2 = rawDescriptor.getData();
        moduleDescriptor.initialize(provider2 != null ? provider2 : PackageFragmentProvider.Empty.INSTANCE);
        return rawDescriptor.copy(moduleDescriptor);
    }

    private static void setDependencies(ModuleDescriptorImpl module, List<ModuleDescriptorImpl> modules) {
        module.setDependencies(CollectionsKt.plus(modules, (Object)JsPlatform.INSTANCE.getBuiltIns().getBuiltInsModule()));
    }

    @NotNull
    public static Collection<KtFile> withJsLibAdded(@NotNull Collection<KtFile> files, @NotNull JsConfig config2) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/js/config/JsConfig", "withJsLibAdded"));
        }
        if (config2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/kotlin/js/config/JsConfig", "withJsLibAdded"));
        }
        ArrayList allFiles2 = Lists.newArrayList();
        allFiles2.addAll(files);
        allFiles2.addAll(config2.getSourceFilesFromLibraries());
        ArrayList arrayList = allFiles2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "withJsLibAdded"));
        }
        return arrayList;
    }
}

