/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.descriptors;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.FunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.UtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorChecks;

public class JavaMethodDescriptor
extends SimpleFunctionDescriptorImpl
implements JavaCallableMemberDescriptor {
    private ParameterNamesStatus parameterNamesStatus;

    protected JavaMethodDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @Nullable SimpleFunctionDescriptor original, @NotNull Annotations annotations2, @NotNull Name name2, @NotNull CallableMemberDescriptor.Kind kind2, @NotNull SourceElement source) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/kotlin/load/java/descriptors/JavaMethodDescriptor", "<init>"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/load/java/descriptors/JavaMethodDescriptor", "<init>"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/java/descriptors/JavaMethodDescriptor", "<init>"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/load/java/descriptors/JavaMethodDescriptor", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/kotlin/load/java/descriptors/JavaMethodDescriptor", "<init>"));
        }
        super(containingDeclaration, original, annotations2, name2, kind2, source);
        this.parameterNamesStatus = null;
    }

    @NotNull
    public static JavaMethodDescriptor createJavaMethod(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations2, @NotNull Name name2, @NotNull SourceElement source) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/kotlin/load/java/descriptors/JavaMethodDescriptor", "createJavaMethod"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/load/java/descriptors/JavaMethodDescriptor", "createJavaMethod"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/java/descriptors/JavaMethodDescriptor", "createJavaMethod"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/kotlin/load/java/descriptors/JavaMethodDescriptor", "createJavaMethod"));
        }
        JavaMethodDescriptor javaMethodDescriptor = new JavaMethodDescriptor(containingDeclaration, null, annotations2, name2, CallableMemberDescriptor.Kind.DECLARATION, source);
        if (javaMethodDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/descriptors/JavaMethodDescriptor", "createJavaMethod"));
        }
        return javaMethodDescriptor;
    }

    @Override
    @NotNull
    public SimpleFunctionDescriptorImpl initialize(@Nullable KotlinType receiverParameterType, @Nullable ReceiverParameterDescriptor dispatchReceiverParameter, @NotNull List<? extends TypeParameterDescriptor> typeParameters, @NotNull List<ValueParameterDescriptor> unsubstitutedValueParameters, @Nullable KotlinType unsubstitutedReturnType, @Nullable Modality modality, @NotNull Visibility visibility) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/load/java/descriptors/JavaMethodDescriptor", "initialize"));
        }
        if (unsubstitutedValueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unsubstitutedValueParameters", "org/jetbrains/kotlin/load/java/descriptors/JavaMethodDescriptor", "initialize"));
        }
        if (visibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "org/jetbrains/kotlin/load/java/descriptors/JavaMethodDescriptor", "initialize"));
        }
        FunctionDescriptorImpl descriptor2 = super.initialize(receiverParameterType, dispatchReceiverParameter, (List)typeParameters, (List)unsubstitutedValueParameters, unsubstitutedReturnType, modality, visibility);
        this.setOperator(OperatorChecks.INSTANCE.check(descriptor2).isSuccess());
        FunctionDescriptorImpl functionDescriptorImpl = descriptor2;
        if (functionDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/descriptors/JavaMethodDescriptor", "initialize"));
        }
        return functionDescriptorImpl;
    }

    @Override
    public boolean hasStableParameterNames() {
        assert (this.parameterNamesStatus != null) : "Parameter names status was not set: " + this;
        return this.parameterNamesStatus.isStable;
    }

    @Override
    public boolean hasSynthesizedParameterNames() {
        assert (this.parameterNamesStatus != null) : "Parameter names status was not set: " + this;
        return this.parameterNamesStatus.isSynthesized;
    }

    public void setParameterNamesStatus(boolean hasStableParameterNames, boolean hasSynthesizedParameterNames) {
        this.parameterNamesStatus = ParameterNamesStatus.get(hasStableParameterNames, hasSynthesizedParameterNames);
    }

    @Override
    @NotNull
    protected JavaMethodDescriptor createSubstitutedCopy(@NotNull DeclarationDescriptor newOwner, @Nullable FunctionDescriptor original, @NotNull CallableMemberDescriptor.Kind kind2, @Nullable Name newName2, boolean preserveSource) {
        if (newOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newOwner", "org/jetbrains/kotlin/load/java/descriptors/JavaMethodDescriptor", "createSubstitutedCopy"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/load/java/descriptors/JavaMethodDescriptor", "createSubstitutedCopy"));
        }
        JavaMethodDescriptor result2 = new JavaMethodDescriptor(newOwner, (SimpleFunctionDescriptor)original, this.getAnnotations(), newName2 != null ? newName2 : this.getName(), kind2, this.getSourceToUseForCopy(preserveSource, original));
        result2.setParameterNamesStatus(this.hasStableParameterNames(), this.hasSynthesizedParameterNames());
        JavaMethodDescriptor javaMethodDescriptor = result2;
        if (javaMethodDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/descriptors/JavaMethodDescriptor", "createSubstitutedCopy"));
        }
        return javaMethodDescriptor;
    }

    @Override
    @NotNull
    public JavaMethodDescriptor enhance(@Nullable KotlinType enhancedReceiverType, @NotNull List<KotlinType> enhancedValueParametersTypes, @NotNull KotlinType enhancedReturnType) {
        if (enhancedValueParametersTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enhancedValueParametersTypes", "org/jetbrains/kotlin/load/java/descriptors/JavaMethodDescriptor", "enhance"));
        }
        if (enhancedReturnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enhancedReturnType", "org/jetbrains/kotlin/load/java/descriptors/JavaMethodDescriptor", "enhance"));
        }
        List<ValueParameterDescriptor> enhancedValueParameters = UtilKt.copyValueParameters(enhancedValueParametersTypes, this.getValueParameters(), this);
        JavaMethodDescriptor enhancedMethod = (JavaMethodDescriptor)this.newCopyBuilder().setValueParameters(enhancedValueParameters).setReturnType(enhancedReturnType).setExtensionReceiverType(enhancedReceiverType).setDropOriginalInContainingParts().setPreserveSourceElement().build();
        assert (enhancedMethod != null) : "null after substitution while enhancing " + this.toString();
        JavaMethodDescriptor javaMethodDescriptor = enhancedMethod;
        if (javaMethodDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/descriptors/JavaMethodDescriptor", "enhance"));
        }
        return javaMethodDescriptor;
    }

    private static enum ParameterNamesStatus {
        NON_STABLE_DECLARED(false, false),
        STABLE_DECLARED(true, false),
        NON_STABLE_SYNTHESIZED(false, true),
        STABLE_SYNTHESIZED(true, true);

        public final boolean isStable;
        public final boolean isSynthesized;

        private ParameterNamesStatus(boolean isStable, boolean isSynthesized) {
            this.isStable = isStable;
            this.isSynthesized = isSynthesized;
        }

        @NotNull
        public static ParameterNamesStatus get(boolean stable, boolean synthesized) {
            ParameterNamesStatus parameterNamesStatus = stable ? (synthesized ? STABLE_SYNTHESIZED : STABLE_DECLARED) : (synthesized ? NON_STABLE_SYNTHESIZED : NON_STABLE_DECLARED);
            if (parameterNamesStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/descriptors/JavaMethodDescriptor$ParameterNamesStatus", "get"));
            }
            return parameterNamesStatus;
        }
    }
}

