/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.IfNotParsed;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtExpressionImplStub;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinUserTypeStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

public class KtUserType
extends KtElementImplStub<KotlinUserTypeStub>
implements KtTypeElement {
    public KtUserType(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/KtUserType", "<init>"));
        }
        super(node);
    }

    public KtUserType(@NotNull KotlinUserTypeStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/KtUserType", "<init>"));
        }
        super(stub, KtStubElementTypes.USER_TYPE);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtUserType", "accept"));
        }
        return visitor2.visitUserType(this, data);
    }

    @Nullable
    public KtTypeArgumentList getTypeArgumentList() {
        return (KtTypeArgumentList)this.getStubOrPsiChild(KtStubElementTypes.TYPE_ARGUMENT_LIST);
    }

    @NotNull
    public List<KtTypeProjection> getTypeArguments() {
        KtTypeArgumentList typeArgumentList = this.getTypeArgumentList();
        List<Object> list2 = typeArgumentList == null ? Collections.emptyList() : typeArgumentList.getArguments();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtUserType", "getTypeArguments"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<KtTypeReference> getTypeArgumentsAsTypes() {
        ArrayList result2 = Lists.newArrayList();
        for (KtTypeProjection projection : this.getTypeArguments()) {
            result2.add(projection.getTypeReference());
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtUserType", "getTypeArgumentsAsTypes"));
        }
        return arrayList;
    }

    @IfNotParsed
    @Nullable
    public KtSimpleNameExpression getReferenceExpression() {
        KtNameReferenceExpression nameRefExpr = (KtNameReferenceExpression)this.getStubOrPsiChild(KtStubElementTypes.REFERENCE_EXPRESSION);
        return (KtSimpleNameExpression)((Object)(nameRefExpr != null ? nameRefExpr : (KtExpressionImplStub)this.getStubOrPsiChild(KtStubElementTypes.ENUM_ENTRY_SUPERCLASS_REFERENCE_EXPRESSION)));
    }

    @Nullable
    public KtUserType getQualifier() {
        return (KtUserType)this.getStubOrPsiChild(KtStubElementTypes.USER_TYPE);
    }

    public void deleteQualifier() {
        KtUserType qualifier = this.getQualifier();
        assert (qualifier != null);
        PsiElement dot = this.findChildByType(KtTokens.DOT);
        assert (dot != null);
        qualifier.delete();
        dot.delete();
    }

    @Nullable
    public String getReferencedName() {
        KtSimpleNameExpression referenceExpression = this.getReferenceExpression();
        return referenceExpression == null ? null : referenceExpression.getReferencedName();
    }
}

