/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.util.OperatorNameConventions;

class InlineChecker
implements CallChecker {
    private final FunctionDescriptor descriptor;
    private final Set<CallableDescriptor> inlinableParameters;
    private final boolean isEffectivelyPublicApiFunction;
    private final boolean isEffectivelyPrivateApiFunction;

    public InlineChecker(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "<init>"));
        }
        this.inlinableParameters = new LinkedHashSet<CallableDescriptor>();
        assert (InlineUtil.isInline(descriptor2)) : "This extension should be created only for inline functions: " + descriptor2;
        this.descriptor = descriptor2;
        this.isEffectivelyPublicApiFunction = DescriptorUtilsKt.isEffectivelyPublicApi(descriptor2);
        this.isEffectivelyPrivateApiFunction = DescriptorUtilsKt.isEffectivelyPrivateApi(descriptor2);
        for (ValueParameterDescriptor param : descriptor2.getValueParameters()) {
            if (!InlineChecker.isInlinableParameter(param)) continue;
            this.inlinableParameters.add(param);
        }
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "check"));
        }
        if (reportOn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reportOn", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "check"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "check"));
        }
        KtExpression expression2 = resolvedCall2.getCall().getCalleeExpression();
        if (expression2 == null) {
            return;
        }
        Object targetDescriptor = resolvedCall2.getResultingDescriptor();
        this.checkCallWithReceiver(context, (CallableDescriptor)targetDescriptor, resolvedCall2.getDispatchReceiver(), expression2);
        this.checkCallWithReceiver(context, (CallableDescriptor)targetDescriptor, resolvedCall2.getExtensionReceiver(), expression2);
        if (this.inlinableParameters.contains(targetDescriptor) && !InlineChecker.isInsideCall(expression2)) {
            context.getTrace().report(Errors.USAGE_IS_NOT_INLINABLE.on(expression2, expression2, this.descriptor));
        }
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : resolvedCall2.getValueArguments().entrySet()) {
            ResolvedValueArgument value2 = entry.getValue();
            ValueParameterDescriptor valueDescriptor = entry.getKey();
            if (value2 instanceof DefaultValueArgument) continue;
            for (ValueArgument argument2 : value2.getArguments()) {
                this.checkValueParameter(context, (CallableDescriptor)targetDescriptor, argument2, valueDescriptor);
            }
        }
        this.checkVisibilityAndAccess((CallableDescriptor)targetDescriptor, expression2, context);
        this.checkRecursion(context, (CallableDescriptor)targetDescriptor, expression2);
    }

    private static boolean isInsideCall(KtExpression expression2) {
        KtToken token;
        KtExpression parent2 = KtPsiUtil.getParentCallIfPresent(expression2);
        if (parent2 instanceof KtBinaryExpression && ((token = KtPsiUtil.getOperationToken((KtOperationExpression)parent2)) == KtTokens.EQ || token == KtTokens.ANDAND || token == KtTokens.OROR)) {
            return false;
        }
        if (parent2 != null) {
            for (KtExpression current = expression2; current != parent2; current = current.getParent()) {
                if (!(current instanceof KtBinaryExpressionWithTypeRHS)) continue;
                return false;
            }
        }
        return parent2 != null;
    }

    private void checkValueParameter(@NotNull CallCheckerContext context, @NotNull CallableDescriptor targetDescriptor, @NotNull ValueArgument targetArgument, @NotNull ValueParameterDescriptor targetParameterDescriptor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkValueParameter"));
        }
        if (targetDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkValueParameter"));
        }
        if (targetArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetArgument", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkValueParameter"));
        }
        if (targetParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetParameterDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkValueParameter"));
        }
        KtExpression argumentExpression = targetArgument.getArgumentExpression();
        if (argumentExpression == null) {
            return;
        }
        CallableDescriptor argumentCallee = InlineChecker.getCalleeDescriptor(context, argumentExpression, false);
        if (argumentCallee != null && this.inlinableParameters.contains(argumentCallee)) {
            if (InlineUtil.isInline(targetDescriptor) && InlineChecker.isInlinableParameter(targetParameterDescriptor)) {
                if (InlineUtil.allowsNonLocalReturns(argumentCallee) && !InlineUtil.allowsNonLocalReturns(targetParameterDescriptor)) {
                    context.getTrace().report(Errors.NON_LOCAL_RETURN_NOT_ALLOWED.on(argumentExpression, argumentExpression));
                } else {
                    this.checkNonLocalReturn(context, argumentCallee, argumentExpression);
                }
            } else {
                context.getTrace().report(Errors.USAGE_IS_NOT_INLINABLE.on(argumentExpression, argumentExpression, this.descriptor));
            }
        }
    }

    private void checkCallWithReceiver(@NotNull CallCheckerContext context, @NotNull CallableDescriptor targetDescriptor, @Nullable ReceiverValue receiver, @Nullable KtExpression expression2) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkCallWithReceiver"));
        }
        if (targetDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkCallWithReceiver"));
        }
        if (receiver == null) {
            return;
        }
        CallableDescriptor varDescriptor = null;
        KtExpression receiverExpression = null;
        if (receiver instanceof ExpressionReceiver) {
            receiverExpression = ((ExpressionReceiver)receiver).getExpression();
            varDescriptor = InlineChecker.getCalleeDescriptor(context, receiverExpression, true);
        } else if (receiver instanceof ExtensionReceiver) {
            ExtensionReceiver extensionReceiver = (ExtensionReceiver)receiver;
            CallableDescriptor extension = extensionReceiver.getDeclarationDescriptor();
            varDescriptor = extension.getExtensionReceiverParameter();
            assert (varDescriptor != null) : "Extension should have receiverParameterDescriptor: " + extension;
            receiverExpression = expression2;
        }
        if (this.inlinableParameters.contains(varDescriptor)) {
            this.checkLambdaInvokeOrExtensionCall(context, varDescriptor, targetDescriptor, receiverExpression);
        }
    }

    @Nullable
    private static CallableDescriptor getCalleeDescriptor(@NotNull CallCheckerContext context, @NotNull KtExpression expression2, boolean unwrapVariableAsFunction) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "getCalleeDescriptor"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "getCalleeDescriptor"));
        }
        if (!(expression2 instanceof KtSimpleNameExpression) && !(expression2 instanceof KtThisExpression)) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> thisCall = CallUtilKt.getResolvedCall(expression2, context.getTrace().getBindingContext());
        if (unwrapVariableAsFunction && thisCall instanceof VariableAsFunctionResolvedCall) {
            return ((VariableAsFunctionResolvedCall)((Object)thisCall)).getVariableCall().getResultingDescriptor();
        }
        return thisCall != null ? thisCall.getResultingDescriptor() : null;
    }

    private void checkLambdaInvokeOrExtensionCall(@NotNull CallCheckerContext context, @NotNull CallableDescriptor lambdaDescriptor, @NotNull CallableDescriptor callDescriptor2, @NotNull KtExpression receiverExpression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkLambdaInvokeOrExtensionCall"));
        }
        if (lambdaDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambdaDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkLambdaInvokeOrExtensionCall"));
        }
        if (callDescriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkLambdaInvokeOrExtensionCall"));
        }
        if (receiverExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverExpression", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkLambdaInvokeOrExtensionCall"));
        }
        boolean inlinableCall = InlineChecker.isInvokeOrInlineExtension(callDescriptor2);
        if (!inlinableCall) {
            context.getTrace().report(Errors.USAGE_IS_NOT_INLINABLE.on(receiverExpression, receiverExpression, this.descriptor));
        } else {
            this.checkNonLocalReturn(context, lambdaDescriptor, receiverExpression);
        }
    }

    private void checkRecursion(@NotNull CallCheckerContext context, @NotNull CallableDescriptor targetDescriptor, @NotNull KtElement expression2) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkRecursion"));
        }
        if (targetDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkRecursion"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkRecursion"));
        }
        if (targetDescriptor.getOriginal() == this.descriptor) {
            context.getTrace().report(Errors.RECURSION_IN_INLINE.on(expression2, expression2, this.descriptor));
        }
    }

    private static boolean isInlinableParameter(@NotNull ParameterDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "isInlinableParameter"));
        }
        return InlineUtil.isInlineLambdaParameter(descriptor2) && !descriptor2.getType().isMarkedNullable();
    }

    private static boolean isInvokeOrInlineExtension(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "isInvokeOrInlineExtension"));
        }
        if (!(descriptor2 instanceof SimpleFunctionDescriptor)) {
            return false;
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        boolean isInvoke = descriptor2.getName().equals(OperatorNameConventions.INVOKE) && containingDeclaration instanceof ClassDescriptor && FunctionTypesKt.isFunctionType(((ClassDescriptor)containingDeclaration).getDefaultType());
        return isInvoke || InlineUtil.isInline(descriptor2);
    }

    private void checkVisibilityAndAccess(@NotNull CallableDescriptor declarationDescriptor, @NotNull KtElement expression2, @NotNull CallCheckerContext context) {
        boolean declarationDescriptorIsPublicApi;
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkVisibilityAndAccess"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkVisibilityAndAccess"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkVisibilityAndAccess"));
        }
        boolean bl = declarationDescriptorIsPublicApi = DescriptorUtilsKt.isEffectivelyPublicApi(declarationDescriptor) || this.isDefinedInInlineFunction(declarationDescriptor);
        if (this.isEffectivelyPublicApiFunction && !declarationDescriptorIsPublicApi && declarationDescriptor.getVisibility() != Visibilities.LOCAL) {
            context.getTrace().report(Errors.NON_PUBLIC_CALL_FROM_PUBLIC_INLINE.on(expression2, declarationDescriptor, this.descriptor));
        } else {
            this.checkPrivateClassMemberAccess(declarationDescriptor, expression2, context);
        }
    }

    private void checkPrivateClassMemberAccess(@NotNull DeclarationDescriptor declarationDescriptor, @NotNull KtElement expression2, @NotNull CallCheckerContext context) {
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkPrivateClassMemberAccess"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkPrivateClassMemberAccess"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkPrivateClassMemberAccess"));
        }
        if (!this.isEffectivelyPrivateApiFunction && DescriptorUtilsKt.isInsidePrivateClass(declarationDescriptor)) {
            context.getTrace().report(Errors.PRIVATE_CLASS_MEMBER_FROM_INLINE.on(expression2, declarationDescriptor, this.descriptor));
        }
    }

    private boolean isDefinedInInlineFunction(@NotNull DeclarationDescriptorWithVisibility startDescriptor) {
        if (startDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "isDefinedInInlineFunction"));
        }
        DeclarationDescriptorWithVisibility parent2 = startDescriptor;
        while (parent2 != null) {
            if (parent2.getContainingDeclaration() == this.descriptor) {
                return true;
            }
            parent2 = DescriptorUtils.getParentOfType(parent2, DeclarationDescriptorWithVisibility.class);
        }
        return false;
    }

    private void checkNonLocalReturn(@NotNull CallCheckerContext context, @NotNull CallableDescriptor inlinableParameterDescriptor, @NotNull KtExpression parameterUsage) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkNonLocalReturn"));
        }
        if (inlinableParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlinableParameterDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkNonLocalReturn"));
        }
        if (parameterUsage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterUsage", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkNonLocalReturn"));
        }
        if (!InlineUtil.allowsNonLocalReturns(inlinableParameterDescriptor)) {
            return;
        }
        if (!InlineUtil.checkNonLocalReturnUsage(this.descriptor, parameterUsage, context.getTrace())) {
            context.getTrace().report(Errors.NON_LOCAL_RETURN_NOT_ALLOWED.on(parameterUsage, parameterUsage));
        }
    }
}

