/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.types.DelegatingType;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.FlexibleTypeFactory;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SubtypingRepresentatives;
import org.jetbrains.kotlin.types.TypeCapability;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0001\u001fB\u001f\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ'\u0010\u0012\u001a\u0004\u0018\u0001H\u0013\"\b\b\u0000\u0010\u0013*\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0004H\u0004J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\nH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/types/DelegatingFlexibleType;", "Lorg/jetbrains/kotlin/types/DelegatingType;", "Lorg/jetbrains/kotlin/types/Flexibility;", "lowerBound", "Lorg/jetbrains/kotlin/types/KotlinType;", "upperBound", "factory", "Lorg/jetbrains/kotlin/types/FlexibleTypeFactory;", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/FlexibleTypeFactory;)V", "assertionsDone", "", "delegateType", "getDelegateType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "getFactory", "()Lorg/jetbrains/kotlin/types/FlexibleTypeFactory;", "getLowerBound", "getUpperBound", "getCapability", "T", "Lorg/jetbrains/kotlin/types/TypeCapability;", "capabilityClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Lorg/jetbrains/kotlin/types/TypeCapability;", "getDelegate", "makeNullableAsSpecified", "nullable", "runAssertions", "", "toString", "", "Companion", "descriptors"})
public abstract class DelegatingFlexibleType
extends DelegatingType
implements Flexibility {
    private boolean assertionsDone;
    @NotNull
    private final KotlinType lowerBound;
    @NotNull
    private final KotlinType upperBound;
    @NotNull
    private final FlexibleTypeFactory factory;
    @JvmField
    public static boolean RUN_SLOW_ASSERTIONS;
    public static final Companion Companion;

    private final void runAssertions() {
        if (!RUN_SLOW_ASSERTIONS || this.assertionsDone) {
            return;
        }
        this.assertionsDone = true;
        boolean bl = !FlexibleTypesKt.isFlexible(this.getLowerBound());
        if (_Assertions.ENABLED && !bl) {
            String string = "Lower bound of a flexible type can not be flexible: " + this.getLowerBound();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = !FlexibleTypesKt.isFlexible(this.getUpperBound());
        if (_Assertions.ENABLED && !bl) {
            String string = "Upper bound of a flexible type can not be flexible: " + this.getUpperBound();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = Intrinsics.areEqual((Object)this.getLowerBound(), (Object)this.getUpperBound()) ^ true;
        if (_Assertions.ENABLED && !bl) {
            String string = "Lower and upper bounds are equal: " + this.getLowerBound() + " == " + this.getUpperBound();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = KotlinTypeChecker.DEFAULT.isSubtypeOf(this.getLowerBound(), this.getUpperBound());
        if (_Assertions.ENABLED && !bl) {
            String string = "Lower bound " + this.getLowerBound() + " of a flexible type must be a subtype of the upper bound " + this.getUpperBound();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    @NotNull
    protected abstract KotlinType getDelegateType();

    @Override
    @Nullable
    public <T extends TypeCapability> T getCapability(@NotNull Class<T> capabilityClass) {
        TypeCapability typeCapability;
        Intrinsics.checkParameterIsNotNull(capabilityClass, (String)"capabilityClass");
        Class<T> clazz = capabilityClass;
        if (Intrinsics.areEqual(clazz, Flexibility.class) || Intrinsics.areEqual(clazz, SubtypingRepresentatives.class)) {
            DelegatingFlexibleType delegatingFlexibleType = this;
            if (delegatingFlexibleType == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            typeCapability = delegatingFlexibleType;
        } else {
            typeCapability = super.getCapability(capabilityClass);
        }
        return (T)typeCapability;
    }

    @Override
    @NotNull
    public KotlinType makeNullableAsSpecified(boolean nullable2) {
        FlexibleTypeFactory flexibleTypeFactory = this.getFactory();
        KotlinType kotlinType = TypeUtils.makeNullableAsSpecified(this.getLowerBound(), nullable2);
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"TypeUtils.makeNullableAs\u2026ied(lowerBound, nullable)");
        KotlinType kotlinType2 = TypeUtils.makeNullableAsSpecified(this.getUpperBound(), nullable2);
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"TypeUtils.makeNullableAs\u2026ied(upperBound, nullable)");
        return flexibleTypeFactory.create(kotlinType, kotlinType2);
    }

    @Override
    @NotNull
    protected final KotlinType getDelegate() {
        this.runAssertions();
        return this.getDelegateType();
    }

    @Override
    @NotNull
    public String toString() {
        return "('" + this.getLowerBound() + "'..'" + this.getUpperBound() + "')";
    }

    @Override
    @NotNull
    public KotlinType getLowerBound() {
        return this.lowerBound;
    }

    @Override
    @NotNull
    public KotlinType getUpperBound() {
        return this.upperBound;
    }

    @Override
    @NotNull
    public FlexibleTypeFactory getFactory() {
        return this.factory;
    }

    protected DelegatingFlexibleType(@NotNull KotlinType lowerBound, @NotNull KotlinType upperBound, @NotNull FlexibleTypeFactory factory2) {
        Intrinsics.checkParameterIsNotNull((Object)lowerBound, (String)"lowerBound");
        Intrinsics.checkParameterIsNotNull((Object)upperBound, (String)"upperBound");
        Intrinsics.checkParameterIsNotNull((Object)factory2, (String)"factory");
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.factory = factory2;
    }

    static {
        Companion = new Companion(null);
    }

    @Override
    @NotNull
    public KotlinType getSubTypeRepresentative() {
        return Flexibility.DefaultImpls.getSubTypeRepresentative(this);
    }

    @Override
    @NotNull
    public KotlinType getSuperTypeRepresentative() {
        return Flexibility.DefaultImpls.getSuperTypeRepresentative(this);
    }

    @Override
    public boolean sameTypeConstructor(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        return Flexibility.DefaultImpls.sameTypeConstructor(this, type2);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/types/DelegatingFlexibleType$Companion;", "", "()V", "RUN_SLOW_ASSERTIONS", "", "descriptors"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

