/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.LocalVariableResolver;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.dataClassUtils.DataClassUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.FakeCallKind;
import org.jetbrains.kotlin.types.expressions.FakeCallResolver;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ2\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J4\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/types/expressions/DestructuringDeclarationResolver;", "", "fakeCallResolver", "Lorg/jetbrains/kotlin/types/expressions/FakeCallResolver;", "localVariableResolver", "Lorg/jetbrains/kotlin/resolve/LocalVariableResolver;", "typeResolver", "Lorg/jetbrains/kotlin/resolve/TypeResolver;", "(Lorg/jetbrains/kotlin/types/expressions/FakeCallResolver;Lorg/jetbrains/kotlin/resolve/LocalVariableResolver;Lorg/jetbrains/kotlin/resolve/TypeResolver;)V", "defineLocalVariablesFromMultiDeclaration", "", "writableScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope;", "destructuringDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "initializer", "Lorg/jetbrains/kotlin/psi/KtExpression;", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "getExpectedTypeForComponent", "Lorg/jetbrains/kotlin/types/KotlinType;", "entry", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclarationEntry;", "resolveComponentFunctionAndGetType", "componentName", "Lorg/jetbrains/kotlin/name/Name;", "frontend"})
public final class DestructuringDeclarationResolver {
    private final FakeCallResolver fakeCallResolver;
    private final LocalVariableResolver localVariableResolver;
    private final TypeResolver typeResolver;

    public final void defineLocalVariablesFromMultiDeclaration(@NotNull LexicalWritableScope writableScope, @NotNull KtDestructuringDeclaration destructuringDeclaration, @Nullable ReceiverValue receiver, @Nullable KtExpression initializer2, @NotNull ExpressionTypingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)writableScope, (String)"writableScope");
        Intrinsics.checkParameterIsNotNull((Object)destructuringDeclaration, (String)"destructuringDeclaration");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)destructuringDeclaration.getEntries())) {
            int componentIndex = indexedValue.component1();
            KtDestructuringDeclarationEntry entry = (KtDestructuringDeclarationEntry)indexedValue.component2();
            Name componentName = DataClassUtilsKt.createComponentName(componentIndex + 1);
            KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = entry;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktDestructuringDeclarationEntry, (String)"entry");
            KotlinType componentType = this.resolveComponentFunctionAndGetType(componentName, context, ktDestructuringDeclarationEntry, receiver, initializer2);
            LexicalScope lexicalScope = writableScope;
            KtVariableDeclaration ktVariableDeclaration = entry;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktVariableDeclaration, (String)"entry");
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
            LocalVariableDescriptor variableDescriptor = this.localVariableResolver.resolveLocalVariableDescriptorWithType$frontend(lexicalScope, ktVariableDeclaration, componentType, bindingTrace);
            ExpressionTypingUtils.checkVariableShadowing(writableScope, context.trace, variableDescriptor);
            writableScope.addVariableDescriptor(variableDescriptor);
        }
    }

    private final KotlinType resolveComponentFunctionAndGetType(Name componentName, ExpressionTypingContext context, KtDestructuringDeclarationEntry entry, ReceiverValue receiver, KtExpression initializer2) {
        Object object;
        Function0<KotlinType> errorType$ = new Function0<KotlinType>(componentName){
            final /* synthetic */ Name $componentName;

            @NotNull
            public final KotlinType invoke() {
                return ErrorUtils.createErrorType(this.$componentName + "() return type");
            }
            {
                this.$componentName = name2;
                super(0);
            }
        };
        if (receiver == null || initializer2 == null) {
            Object object2 = errorType$.invoke();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"errorType()");
            return object2;
        }
        KotlinType expectedType = this.getExpectedTypeForComponent(context, entry);
        ExpressionTypingContext expressionTypingContext = (ExpressionTypingContext)context.replaceExpectedType(expectedType);
        Intrinsics.checkExpressionValueIsNotNull((Object)expressionTypingContext, (String)"context.replaceExpectedType(expectedType)");
        OverloadResolutionResults results2 = FakeCallResolver.resolveFakeCall$default(this.fakeCallResolver, expressionTypingContext, receiver, componentName, (KtExpression)entry, initializer2, FakeCallKind.COMPONENT, null, 64, null);
        if (!results2.isSuccess()) {
            Object object3 = errorType$.invoke();
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"errorType()");
            return object3;
        }
        context.trace.record(BindingContext.COMPONENT_RESOLVED_CALL, entry, results2.getResultingCall());
        KotlinType functionReturnType = ((FunctionDescriptor)results2.getResultingDescriptor()).getReturnType();
        if (functionReturnType != null && !TypeUtils.noExpectedType(expectedType) && !KotlinTypeChecker.DEFAULT.isSubtypeOf(functionReturnType, expectedType)) {
            context.trace.report(Errors.COMPONENT_FUNCTION_RETURN_TYPE_MISMATCH.on((KtExpression)((PsiElement)initializer2), componentName, functionReturnType, expectedType));
        }
        if ((object = functionReturnType) == null) {
            Object object4 = errorType$.invoke();
            object = object4;
            Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"errorType()");
        }
        return object;
    }

    private final KotlinType getExpectedTypeForComponent(ExpressionTypingContext context, KtDestructuringDeclarationEntry entry) {
        KtTypeReference ktTypeReference = entry.getTypeReference();
        if (ktTypeReference == null) {
            KotlinType kotlinType = TypeUtils.NO_EXPECTED_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"TypeUtils.NO_EXPECTED_TYPE");
            return kotlinType;
        }
        KtTypeReference entryTypeRef = ktTypeReference;
        LexicalScope lexicalScope = context.scope;
        Intrinsics.checkExpressionValueIsNotNull((Object)lexicalScope, (String)"context.scope");
        KtTypeReference ktTypeReference2 = entryTypeRef;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference2, (String)"entryTypeRef");
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
        return this.typeResolver.resolveType(lexicalScope, ktTypeReference2, bindingTrace, true);
    }

    public DestructuringDeclarationResolver(@NotNull FakeCallResolver fakeCallResolver, @NotNull LocalVariableResolver localVariableResolver, @NotNull TypeResolver typeResolver) {
        Intrinsics.checkParameterIsNotNull((Object)fakeCallResolver, (String)"fakeCallResolver");
        Intrinsics.checkParameterIsNotNull((Object)localVariableResolver, (String)"localVariableResolver");
        Intrinsics.checkParameterIsNotNull((Object)typeResolver, (String)"typeResolver");
        this.fakeCallResolver = fakeCallResolver;
        this.localVariableResolver = localVariableResolver;
        this.typeResolver = typeResolver;
    }
}

