/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entry
implements Comparable<Entry> {
    private final int myTotal;
    private final int myCovered;

    public Entry(int total, int covered) {
        this.myTotal = total;
        this.myCovered = total > 0 && covered < 0 ? 0 : covered;
    }

    public int getTotal() {
        return this.myTotal;
    }

    public int getCovered() {
        return this.myCovered;
    }

    public float getPercent() {
        if (this.getTotal() <= 0 || this.getCovered() < 0) {
            return -1.0f;
        }
        return 100.0f * Math.max(0.0f, Math.min(1.0f, (float)this.getCovered() / (float)this.getTotal()));
    }

    @Override
    public int compareTo(Entry o) {
        return (int)Math.signum(this.getPercent() - o.getPercent());
    }

    public String toString() {
        return "Entry{myTotal=" + this.myTotal + ", myCovered=" + this.myCovered + '}';
    }
}

