/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report;

import jetbrains.coverage.report.ClassInfo;
import org.jetbrains.annotations.NotNull;

public abstract class JavaClassInfo
implements ClassInfo {
    private CharSequence myName;
    private CharSequence myNamespace;
    private String myFQClassName;
    private static final String EMPTY = "";

    public JavaClassInfo(@NotNull String fqClassName) {
        if (fqClassName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/JavaClassInfo.<init> must not be null");
        }
        this.myFQClassName = fqClassName;
        int lastDot = fqClassName.lastIndexOf(".");
        if (lastDot == -1) {
            this.myName = fqClassName;
            this.myNamespace = EMPTY;
        } else {
            this.myName = fqClassName.substring(lastDot + 1);
            this.myNamespace = fqClassName.substring(0, lastDot);
        }
    }

    public String getModule() {
        return null;
    }

    @NotNull
    public String getName() {
        String string = ((Object)this.myName).toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/JavaClassInfo.getName must not return null");
        }
        return string;
    }

    @NotNull
    public String getNamespace() {
        String string = ((Object)this.myNamespace).toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/JavaClassInfo.getNamespace must not return null");
        }
        return string;
    }

    @NotNull
    public String getFQName() {
        String string = this.myFQClassName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/JavaClassInfo.getFQName must not return null");
        }
        return string;
    }
}

