/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.SingleAlarm;
import com.intellij.util.SystemProperties;
import java.io.InputStream;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jgit.lib.Repository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.keychain.CredentialsStore;
import org.jetbrains.keychain.FileCredentialsStore;
import org.jetbrains.keychain.OSXKeychainLibraryKt;
import org.jetbrains.keychain.OsXCredentialsStore;
import org.jetbrains.settingsRepository.AutoSyncManager;
import org.jetbrains.settingsRepository.IcsBundleKt;
import org.jetbrains.settingsRepository.IcsManager;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.IcsSettings;
import org.jetbrains.settingsRepository.IcsSettingsKt;
import org.jetbrains.settingsRepository.IcsUrlBuilderKt;
import org.jetbrains.settingsRepository.ReadOnlySourcesManager;
import org.jetbrains.settingsRepository.RepositoryManager;
import org.jetbrains.settingsRepository.RepositoryService;
import org.jetbrains.settingsRepository.SyncManager;
import org.jetbrains.settingsRepository.SyncType;
import org.jetbrains.settingsRepository.UpdateResult;
import org.jetbrains.settingsRepository.git.GitExKt;
import org.jetbrains.settingsRepository.git.GitRepositoryManager;
import org.jetbrains.settingsRepository.git.GitRepositoryService;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002=>B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200J\b\u00101\u001a\u00020.H\u0002J\u0014\u00102\u001a\u00020.2\f\u00103\u001a\b\u0012\u0004\u0012\u00020.04J\b\u00105\u001a\u00020.H\u0002J.\u00106\u001a\u0004\u0018\u0001072\u0006\u00108\u001a\u0002092\n\b\u0002\u0010:\u001a\u0004\u0018\u00010;2\u0010\b\u0002\u0010<\u001a\n\u0012\u0004\u0012\u00020.\u0018\u000104R\u0012\u0010\u0005\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0019\u0010'\u001a\n (*\u0004\u0018\u00010\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/jetbrains/settingsRepository/IcsManager;", "", "dir", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "autoCommitEnabled", "", "autoSyncManager", "Lorg/jetbrains/settingsRepository/AutoSyncManager;", "getAutoSyncManager$settings_repository", "()Lorg/jetbrains/settingsRepository/AutoSyncManager;", "commitAlarm", "Lcom/intellij/util/SingleAlarm;", "credentialsStore", "Lcom/intellij/openapi/util/AtomicNotNullLazyValue;", "Lorg/jetbrains/keychain/CredentialsStore;", "getCredentialsStore", "()Lcom/intellij/openapi/util/AtomicNotNullLazyValue;", "readOnlySourcesManager", "Lorg/jetbrains/settingsRepository/ReadOnlySourcesManager;", "getReadOnlySourcesManager", "()Lorg/jetbrains/settingsRepository/ReadOnlySourcesManager;", "repositoryActive", "getRepositoryActive", "()Z", "setRepositoryActive", "(Z)V", "repositoryManager", "Lorg/jetbrains/settingsRepository/RepositoryManager;", "getRepositoryManager", "()Lorg/jetbrains/settingsRepository/RepositoryManager;", "repositoryService", "Lorg/jetbrains/settingsRepository/RepositoryService;", "getRepositoryService", "()Lorg/jetbrains/settingsRepository/RepositoryService;", "settings", "Lorg/jetbrains/settingsRepository/IcsSettings;", "getSettings", "()Lorg/jetbrains/settingsRepository/IcsSettings;", "settingsFile", "kotlin.jvm.PlatformType", "getSettingsFile", "()Ljava/nio/file/Path;", "syncManager", "Lorg/jetbrains/settingsRepository/SyncManager;", "beforeApplicationLoaded", "", "application", "Lcom/intellij/openapi/application/Application;", "cancelAndDisableAutoCommit", "runInAutoCommitDisabledMode", "task", "Lkotlin/Function0;", "scheduleCommit", "sync", "Lorg/jetbrains/settingsRepository/UpdateResult;", "syncType", "Lorg/jetbrains/settingsRepository/SyncType;", "project", "Lcom/intellij/openapi/project/Project;", "localRepositoryInitializer", "ApplicationLevelProvider", "IcsStreamProvider", "settings-repository"})
public final class IcsManager {
    @NotNull
    private final AtomicNotNullLazyValue<CredentialsStore> credentialsStore;
    private final Path settingsFile;
    @NotNull
    private final IcsSettings settings;
    @NotNull
    private final RepositoryManager repositoryManager;
    @NotNull
    private final ReadOnlySourcesManager readOnlySourcesManager;
    @NotNull
    private final RepositoryService repositoryService;
    private final SingleAlarm commitAlarm;
    private volatile boolean autoCommitEnabled;
    private volatile boolean repositoryActive;
    @NotNull
    private final AutoSyncManager autoSyncManager;
    private final SyncManager syncManager;

    @NotNull
    public final AtomicNotNullLazyValue<CredentialsStore> getCredentialsStore() {
        return this.credentialsStore;
    }

    public final Path getSettingsFile() {
        return this.settingsFile;
    }

    @NotNull
    public final IcsSettings getSettings() {
        return this.settings;
    }

    @NotNull
    public final RepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    @NotNull
    public final ReadOnlySourcesManager getReadOnlySourcesManager() {
        return this.readOnlySourcesManager;
    }

    @NotNull
    public final RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public final boolean getRepositoryActive() {
        return this.repositoryActive;
    }

    public final void setRepositoryActive(boolean bl) {
        this.repositoryActive = bl;
    }

    @NotNull
    public final AutoSyncManager getAutoSyncManager$settings_repository() {
        return this.autoSyncManager;
    }

    private final void scheduleCommit() {
        if (this.autoCommitEnabled) {
            Application application = ApplicationManager.getApplication();
            if (application == null) {
                Intrinsics.throwNpe();
            }
            if (!application.isUnitTestMode()) {
                this.commitAlarm.cancelAndRequest();
            }
        }
    }

    @Nullable
    public final UpdateResult sync(@NotNull SyncType syncType, @Nullable Project project, @Nullable Function0<Unit> localRepositoryInitializer) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)syncType), (String)"syncType");
        return this.syncManager.sync(syncType, project, localRepositoryInitializer);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ UpdateResult sync$default(IcsManager icsManager2, SyncType syncType, Project project, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sync");
        }
        if ((n & 2) != 0) {
            project = null;
        }
        if ((n & 4) != 0) {
            function0 = null;
        }
        return icsManager2.sync(syncType, project, (Function0<Unit>)function0);
    }

    private final void cancelAndDisableAutoCommit() {
        if (this.autoCommitEnabled) {
            this.autoCommitEnabled = false;
            this.commitAlarm.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runInAutoCommitDisabledMode(@NotNull Function0<Unit> task) {
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        this.cancelAndDisableAutoCommit();
        try {
            task.invoke();
        }
        finally {
            this.autoCommitEnabled = true;
            this.repositoryActive = this.repositoryManager.isRepositoryExists();
        }
    }

    public final void beforeApplicationLoaded(@NotNull Application application) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        this.repositoryActive = this.repositoryManager.isRepositoryExists();
        StateStorageManager stateStorageManager = ServiceKt.getStateStore((ComponentManager)((ComponentManager)application)).getStateStorageManager();
        if (stateStorageManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.StateStorageManagerImpl");
        }
        ((StateStorageManagerImpl)stateStorageManager).setStreamProvider((StreamProvider)new ApplicationLevelProvider());
        this.autoSyncManager.registerListeners(application);
        application.getMessageBus().connect().subscribe(ProjectLifecycleListener.TOPIC, (Object)new ProjectLifecycleListener.Adapter(this){
            final /* synthetic */ IcsManager this$0;

            public void beforeProjectLoaded(@NotNull Project project) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                if (project.isDefault()) {
                    return;
                }
                this.this$0.getAutoSyncManager$settings_repository().registerListeners(project);
            }

            public void afterProjectClosed(@NotNull Project project) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                AutoSyncManager.autoSync$default(this.this$0.getAutoSyncManager$settings_repository(), false, false, 3, null);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public IcsManager(@NotNull Path dir) {
        IcsSettings icsSettings;
        IcsManager icsManager2;
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        this.credentialsStore = (AtomicNotNullLazyValue)new AtomicNotNullLazyValue<CredentialsStore>(dir){
            final /* synthetic */ Path $dir;

            @NotNull
            protected CredentialsStore compute() {
                if (OSXKeychainLibraryKt.isOSXCredentialsStoreSupported() && SystemProperties.getBooleanProperty((String)"ics.use.osx.keychain", (boolean)true)) {
                    try {
                        return new OsXCredentialsStore("IntelliJ Platform Settings Repository");
                    }
                    catch (Throwable e) {
                        IcsManagerKt.getLOG().error(e);
                    }
                }
                Path path = this.$dir.resolve(".git_auth");
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"dir.resolve(\".git_auth\")");
                return new FileCredentialsStore(path);
            }
            {
                this.$dir = $captured_local_variable$0;
            }
        };
        this.settingsFile = dir.resolve("config.json");
        NotNullLazyValue notNullLazyValue = (NotNullLazyValue)this.credentialsStore;
        Path path = dir.resolve("repository");
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"dir.resolve(\"repository\")");
        this.repositoryManager = new GitRepositoryManager((NotNullLazyValue<CredentialsStore>)notNullLazyValue, path);
        IcsManager icsManager3 = this;
        try {
            icsManager2 = icsManager3;
            Path path2 = this.settingsFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"settingsFile");
            icsSettings = IcsSettingsKt.loadSettings(path2);
        }
        catch (Exception e) {
            icsManager2 = icsManager3;
            IcsManagerKt.getLOG().error((Throwable)e);
            icsSettings = new IcsSettings();
        }
        icsManager2.settings = icsSettings;
        this.readOnlySourcesManager = new ReadOnlySourcesManager(this.settings, dir);
        this.repositoryService = new GitRepositoryService();
        this.commitAlarm = new SingleAlarm(new Runnable(this){
            final /* synthetic */ IcsManager this$0;

            public final void run() {
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, null, IcsBundleKt.icsMessage("task.commit.title", new Object[0])){
                    final /* synthetic */ commitAlarm.1 this$0;

                    public void run(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                        try {
                            RepositoryManager.DefaultImpls.commit$default(this.this$0.this$0.getRepositoryManager(), indicator, null, false, 2, null);
                        }
                        catch (Throwable e) {
                            IcsManagerKt.getLOG().error(e);
                        }
                    }
                    {
                        this.this$0 = $outer;
                        super($super_call_param$1, $super_call_param$2);
                    }
                });
            }
            {
                this.this$0 = icsManager2;
            }
        }, this.settings.getCommitDelay());
        this.autoCommitEnabled = true;
        this.autoSyncManager = new AutoSyncManager(this);
        this.syncManager = new SyncManager(this, this.autoSyncManager);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/settingsRepository/IcsManager$ApplicationLevelProvider;", "Lorg/jetbrains/settingsRepository/IcsManager$IcsStreamProvider;", "Lorg/jetbrains/settingsRepository/IcsManager;", "(Lorg/jetbrains/settingsRepository/IcsManager;)V", "delete", "", "fileSpec", "", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "settings-repository"})
    public final class ApplicationLevelProvider
    extends IcsStreamProvider {
        @Override
        public void delete(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            if (IcsManager.this.syncManager.getWriteAndDeleteProhibited()) {
                throw (Throwable)new IllegalStateException("Delete is prohibited now");
            }
            IcsManager.this.getRepositoryManager().delete(IcsUrlBuilderKt.toRepositoryPath$default(fileSpec, roamingType, null, 4, null));
            IcsManager.this.scheduleCommit();
        }

        public ApplicationLevelProvider() {
            super(null);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0096\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0015\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0014JL\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u00192\u001e\u0010\u001a\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u001bH\u0016J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u001e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/settingsRepository/IcsManager$IcsStreamProvider;", "Lcom/intellij/configurationStore/StreamProvider;", "projectId", "", "(Lorg/jetbrains/settingsRepository/IcsManager;Ljava/lang/String;)V", "enabled", "", "getEnabled", "()Z", "getProjectId", "()Ljava/lang/String;", "delete", "", "fileSpec", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "doSave", "content", "", "size", "", "isAutoCommit", "processChildren", "path", "filter", "Lkotlin/Function1;", "processor", "Lkotlin/Function3;", "Ljava/io/InputStream;", "read", "write", "settings-repository"})
    public class IcsStreamProvider
    implements StreamProvider {
        @Nullable
        private final String projectId;

        public boolean getEnabled() {
            return IcsManager.this.getRepositoryActive();
        }

        public void processChildren(@NotNull String path, @NotNull RoamingType roamingType, @NotNull Function1<? super String, Boolean> filter, @NotNull Function3<? super String, ? super InputStream, ? super Boolean, Boolean> processor) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
            Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
            String fullPath = IcsUrlBuilderKt.toRepositoryPath(path, roamingType, null);
            for (Repository repository2 : IcsManager.this.getReadOnlySourcesManager().getRepositories()) {
                GitExKt.processChildren(repository2, fullPath, filter, (Function2<? super String, ? super InputStream, Boolean>)((Function2)new Function2<String, InputStream, Boolean>(processor){
                    final /* synthetic */ Function3 $processor;

                    public final boolean invoke(@NotNull String name, @NotNull InputStream input) {
                        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
                        return (Boolean)this.$processor.invoke((Object)name, (Object)input, (Object)true);
                    }
                    {
                        this.$processor = function3;
                        super(2);
                    }
                }));
            }
            IcsManager.this.getRepositoryManager().processChildren(fullPath, filter, (Function2<? super String, ? super InputStream, Boolean>)((Function2)new Function2<String, InputStream, Boolean>(processor){
                final /* synthetic */ Function3 $processor;

                public final boolean invoke(@NotNull String name, @NotNull InputStream input) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
                    return (Boolean)this.$processor.invoke((Object)name, (Object)input, (Object)false);
                }
                {
                    this.$processor = function3;
                    super(2);
                }
            }));
        }

        public void write(@NotNull String fileSpec, @NotNull byte[] content, int size, @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            if (IcsManager.this.syncManager.getWriteAndDeleteProhibited()) {
                throw (Throwable)new IllegalStateException("Save is prohibited now");
            }
            if (this.doSave(fileSpec, content, size, roamingType) && this.isAutoCommit(fileSpec, roamingType)) {
                IcsManager.this.scheduleCommit();
            }
        }

        public final boolean doSave(@NotNull String fileSpec, @NotNull byte[] content, int size, @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            return IcsManager.this.getRepositoryManager().write(IcsUrlBuilderKt.toRepositoryPath(fileSpec, roamingType, this.projectId), content, size);
        }

        protected boolean isAutoCommit(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            return true;
        }

        @Nullable
        public InputStream read(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            return IcsManager.this.getRepositoryManager().read(IcsUrlBuilderKt.toRepositoryPath(fileSpec, roamingType, this.projectId));
        }

        public void delete(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        }

        @Nullable
        protected final String getProjectId() {
            return this.projectId;
        }

        public IcsStreamProvider(String projectId) {
            this.projectId = projectId;
        }

        public boolean isApplicable(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            return StreamProvider.DefaultImpls.isApplicable((StreamProvider)this, (String)fileSpec, (RoamingType)roamingType);
        }
    }
}

