/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.actions;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.actions.CommonCheckinFilesAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.checkin.BeforeCheckinDialogHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsBundleKt;
import org.jetbrains.settingsRepository.actions.CommitToIcsAction;
import org.jetbrains.settingsRepository.actions.CommitToIcsActionKt;
import org.jetbrains.settingsRepository.actions.ProjectChangeCollectConsumer;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J-\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013H\u0014\u00a2\u0006\u0002\u0010\u0015J)\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0014\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/settingsRepository/actions/CommitToIcsAction;", "Lcom/intellij/openapi/vcs/actions/CommonCheckinFilesAction;", "()V", "getActionName", "", "dataContext", "Lcom/intellij/openapi/vcs/actions/VcsContext;", "isApplicableRoot", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "status", "Lcom/intellij/openapi/vcs/FileStatus;", "performCheckIn", "", "context", "project", "Lcom/intellij/openapi/project/Project;", "roots", "", "Lcom/intellij/openapi/vcs/FilePath;", "(Lcom/intellij/openapi/vcs/actions/VcsContext;Lcom/intellij/openapi/project/Project;[Lcom/intellij/openapi/vcs/FilePath;)V", "prepareRootsForCommit", "([Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/openapi/project/Project;)[Lcom/intellij/openapi/vcs/FilePath;", "IcsBeforeCommitDialogHandler", "settings-repository"})
public final class CommitToIcsAction
extends CommonCheckinFilesAction {
    @NotNull
    protected String getActionName(@NotNull VcsContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        return IcsBundleKt.icsMessage("action.CommitToIcs.text", new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isApplicableRoot(@NotNull VirtualFile file, @NotNull FileStatus status, @NotNull VcsContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        Project project = dataContext.getProject();
        if (!(project instanceof ProjectEx)) return false;
        IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)((ComponentManager)project));
        if (iComponentStore == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.components.impl.stores.IProjectStore");
        }
        if (!Intrinsics.areEqual((Object)((IProjectStore)iComponentStore).getStorageScheme(), (Object)StorageScheme.DIRECTORY_BASED)) return false;
        if (!super.isApplicableRoot(file, status, dataContext)) return false;
        if (file.isDirectory()) return false;
        Project project2 = dataContext.getProject();
        if (project2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"dataContext.project!!");
        if (!CommitToIcsActionKt.access$isProjectConfigFile(file, project2)) return false;
        return true;
    }

    @NotNull
    protected FilePath[] prepareRootsForCommit(@NotNull FilePath[] roots, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)roots, (String)"roots");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return roots;
    }

    /*
     * Unable to fully structure code
     */
    protected void performCheckIn(@NotNull VcsContext context, @NotNull Project project, @NotNull FilePath[] roots) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)roots, (String)"roots");
        v0 = CommitToIcsActionKt.access$getProjectId(project);
        if (v0 == null) {
            return;
        }
        projectId = v0;
        changes = context.getSelectedChanges();
        collectConsumer = new ProjectChangeCollectConsumer(project);
        if (changes == null) ** GOTO lbl-1000
        var7_7 = changes;
        var8_8 = var7_7;
        if (var8_8.length == 0 == false) {
            for (var8_9 = 0; var8_9 < changes.length; ++var8_9) {
                v1 = change = changes[var8_9];
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"change");
                collectConsumer.consume(v1);
            }
        } else lbl-1000:
        // 2 sources

        {
            manager = ChangeListManager.getInstance((Project)project);
            var10_10 = this.getRoots(context);
            for (var9_11 = 0; var9_11 < var10_10.length; ++var9_11) {
                path = var10_10[var9_11];
                v2 = manager.getChangesIn(path);
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"manager.getChangesIn(path)");
                CommitToIcsActionKt.access$collectProjectChanges(v2, collectConsumer);
            }
        }
        CommitToIcsActionKt.access$showDialog(project, collectConsumer, projectId);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/settingsRepository/actions/CommitToIcsAction$IcsBeforeCommitDialogHandler;", "Lcom/intellij/openapi/vcs/checkin/CheckinHandlerFactory;", "()V", "createHandler", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler;", "panel", "Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "commitContext", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "createSystemReadyHandler", "Lcom/intellij/openapi/vcs/checkin/BeforeCheckinDialogHandler;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "settings-repository"})
    public static final class IcsBeforeCommitDialogHandler
    extends CheckinHandlerFactory {
        private static final Companion.BEFORE_CHECKIN_DIALOG_HANDLER.1 BEFORE_CHECKIN_DIALOG_HANDLER;
        public static final Companion Companion;

        @NotNull
        public CheckinHandler createHandler(@NotNull CheckinProjectPanel panel, @NotNull CommitContext commitContext) {
            Intrinsics.checkParameterIsNotNull((Object)panel, (String)"panel");
            Intrinsics.checkParameterIsNotNull((Object)commitContext, (String)"commitContext");
            CheckinHandler checkinHandler = CheckinHandler.DUMMY;
            Intrinsics.checkExpressionValueIsNotNull((Object)checkinHandler, (String)"CheckinHandler.DUMMY");
            return checkinHandler;
        }

        @Nullable
        public BeforeCheckinDialogHandler createSystemReadyHandler(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return IcsBeforeCommitDialogHandler.Companion.getBEFORE_CHECKIN_DIALOG_HANDLER();
        }

        static {
            Companion = new Companion(null);
            BEFORE_CHECKIN_DIALOG_HANDLER = new BeforeCheckinDialogHandler(){

                public boolean beforeCommitDialogShown(@NotNull Project project, @NotNull List<? extends Change> changes, @NotNull Iterable<? extends CommitExecutor> executors, boolean showVcsCommit) {
                    Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                    Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
                    Intrinsics.checkParameterIsNotNull(executors, (String)"executors");
                    ProjectChangeCollectConsumer collectConsumer = new ProjectChangeCollectConsumer(project);
                    CommitToIcsActionKt.access$collectProjectChanges(changes, collectConsumer);
                    CommitToIcsActionKt.access$showDialog(project, collectConsumer, null);
                    return true;
                }
            };
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0013\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0005*\u0001\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lorg/jetbrains/settingsRepository/actions/CommitToIcsAction$IcsBeforeCommitDialogHandler$Companion;", "", "()V", "BEFORE_CHECKIN_DIALOG_HANDLER", "org/jetbrains/settingsRepository/actions/CommitToIcsAction$IcsBeforeCommitDialogHandler$Companion$BEFORE_CHECKIN_DIALOG_HANDLER$1", "getBEFORE_CHECKIN_DIALOG_HANDLER", "()Lorg/jetbrains/settingsRepository/actions/CommitToIcsAction$IcsBeforeCommitDialogHandler$Companion$BEFORE_CHECKIN_DIALOG_HANDLER$1;", "Lorg/jetbrains/settingsRepository/actions/CommitToIcsAction$IcsBeforeCommitDialogHandler$Companion$BEFORE_CHECKIN_DIALOG_HANDLER$1;", "settings-repository"})
        public static final class Companion {
            private final BEFORE_CHECKIN_DIALOG_HANDLER.1 getBEFORE_CHECKIN_DIALOG_HANDLER() {
                return BEFORE_CHECKIN_DIALOG_HANDLER;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

