/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.execution.Executor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class CoverageExecutor
extends Executor {
    public static final String EXECUTOR_ID = "Coverage";

    @NotNull
    public String getStartActionText() {
        if ("Run with Co_verage" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/CoverageExecutor", "getStartActionText"));
        }
        return "Run with Co_verage";
    }

    public String getStartActionText(String configurationName) {
        String name = configurationName != null ? CoverageExecutor.escapeMnemonicsInConfigurationName(StringUtil.first((String)configurationName, (int)30, (boolean)true)) : null;
        return "Run" + (StringUtil.isEmpty((String)name) ? "" : " '" + name + "'") + " with Co_verage";
    }

    private static String escapeMnemonicsInConfigurationName(String configurationName) {
        return configurationName.replace("_", "__");
    }

    public String getToolWindowId() {
        return ToolWindowId.RUN;
    }

    public Icon getToolWindowIcon() {
        return AllIcons.General.RunWithCoverage;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.General.RunWithCoverage;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/CoverageExecutor", "getIcon"));
        }
        return icon;
    }

    public Icon getDisabledIcon() {
        return null;
    }

    public String getDescription() {
        return "Run selected configuration with coverage enabled";
    }

    @NotNull
    public String getActionName() {
        if ("Cover" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/CoverageExecutor", "getActionName"));
        }
        return "Cover";
    }

    @NotNull
    public String getId() {
        if (EXECUTOR_ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/CoverageExecutor", "getId"));
        }
        return EXECUTOR_ID;
    }

    public String getContextActionId() {
        return "RunCoverage";
    }

    public String getHelpId() {
        return null;
    }
}

