/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge.svg12;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.event.EventListenerList;
import org.apache.batik.anim.dom.XBLEventSupport;
import org.apache.batik.anim.dom.XBLOMContentElement;
import org.apache.batik.anim.dom.XBLOMShadowTreeElement;
import org.apache.batik.bridge.svg12.AbstractContentSelector;
import org.apache.batik.bridge.svg12.ContentSelectionChangedEvent;
import org.apache.batik.bridge.svg12.ContentSelectionChangedListener;
import org.apache.batik.bridge.svg12.DefaultContentSelector;
import org.apache.batik.bridge.svg12.DefaultXBLManager;
import org.apache.batik.dom.AbstractElement;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.xbl.XBLManager;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public class ContentManager {
    protected XBLOMShadowTreeElement shadowTree;
    protected Element boundElement;
    protected DefaultXBLManager xblManager;
    protected HashMap selectors = new HashMap();
    protected HashMap selectedNodes = new HashMap();
    protected LinkedList contentElementList = new LinkedList();
    protected Node removedNode;
    protected HashMap listeners = new HashMap();
    protected ContentElementDOMAttrModifiedEventListener contentElementDomAttrModifiedEventListener;
    protected DOMAttrModifiedEventListener domAttrModifiedEventListener;
    protected DOMNodeInsertedEventListener domNodeInsertedEventListener;
    protected DOMNodeRemovedEventListener domNodeRemovedEventListener;
    protected DOMSubtreeModifiedEventListener domSubtreeModifiedEventListener;
    protected ShadowTreeNodeInsertedListener shadowTreeNodeInsertedListener;
    protected ShadowTreeNodeRemovedListener shadowTreeNodeRemovedListener;
    protected ShadowTreeSubtreeModifiedListener shadowTreeSubtreeModifiedListener;

    public ContentManager(XBLOMShadowTreeElement xBLOMShadowTreeElement, XBLManager xBLManager) {
        this.shadowTree = xBLOMShadowTreeElement;
        this.xblManager = (DefaultXBLManager)xBLManager;
        this.xblManager.setContentManager(xBLOMShadowTreeElement, this);
        this.boundElement = this.xblManager.getXblBoundElement(xBLOMShadowTreeElement);
        this.contentElementDomAttrModifiedEventListener = new ContentElementDOMAttrModifiedEventListener();
        XBLEventSupport xBLEventSupport = (XBLEventSupport)this.shadowTree.initializeEventSupport();
        this.shadowTreeNodeInsertedListener = new ShadowTreeNodeInsertedListener();
        this.shadowTreeNodeRemovedListener = new ShadowTreeNodeRemovedListener();
        this.shadowTreeSubtreeModifiedListener = new ShadowTreeSubtreeModifiedListener();
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", this.shadowTreeNodeInsertedListener, true);
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", this.shadowTreeNodeRemovedListener, true);
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", this.shadowTreeSubtreeModifiedListener, true);
        xBLEventSupport = (XBLEventSupport)((AbstractNode)((Object)this.boundElement)).initializeEventSupport();
        this.domAttrModifiedEventListener = new DOMAttrModifiedEventListener();
        this.domNodeInsertedEventListener = new DOMNodeInsertedEventListener();
        this.domNodeRemovedEventListener = new DOMNodeRemovedEventListener();
        this.domSubtreeModifiedEventListener = new DOMSubtreeModifiedEventListener();
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", this.domAttrModifiedEventListener, true);
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", this.domNodeInsertedEventListener, true);
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", this.domNodeRemovedEventListener, true);
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", this.domSubtreeModifiedEventListener, false);
        this.update(true);
    }

    public void dispose() {
        this.xblManager.setContentManager(this.shadowTree, null);
        for (Map.Entry object2 : this.selectedNodes.entrySet()) {
            NodeList nodeList = (NodeList)object2.getValue();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                this.xblManager.getRecord((Node)node).contentElement = null;
            }
        }
        for (NodeEventTarget nodeEventTarget : this.contentElementList) {
            nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", this.contentElementDomAttrModifiedEventListener, false);
        }
        this.contentElementList.clear();
        this.selectedNodes.clear();
        XBLEventSupport xBLEventSupport = (XBLEventSupport)((AbstractNode)((Object)this.boundElement)).getEventSupport();
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", this.domAttrModifiedEventListener, true);
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", this.domNodeInsertedEventListener, true);
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", this.domNodeRemovedEventListener, true);
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", this.domSubtreeModifiedEventListener, false);
    }

    public NodeList getSelectedContent(XBLOMContentElement xBLOMContentElement) {
        return (NodeList)this.selectedNodes.get(xBLOMContentElement);
    }

    protected XBLOMContentElement getContentElement(Node node) {
        return this.xblManager.getXblContentElement(node);
    }

    public void addContentSelectionChangedListener(XBLOMContentElement xBLOMContentElement, ContentSelectionChangedListener contentSelectionChangedListener) {
        EventListenerList eventListenerList = (EventListenerList)this.listeners.get(xBLOMContentElement);
        if (eventListenerList == null) {
            eventListenerList = new EventListenerList();
            this.listeners.put(xBLOMContentElement, eventListenerList);
        }
        eventListenerList.add(ContentSelectionChangedListener.class, contentSelectionChangedListener);
    }

    public void removeContentSelectionChangedListener(XBLOMContentElement xBLOMContentElement, ContentSelectionChangedListener contentSelectionChangedListener) {
        EventListenerList eventListenerList = (EventListenerList)this.listeners.get(xBLOMContentElement);
        if (eventListenerList != null) {
            eventListenerList.remove(ContentSelectionChangedListener.class, contentSelectionChangedListener);
        }
    }

    protected void dispatchContentSelectionChangedEvent(XBLOMContentElement xBLOMContentElement) {
        ContentSelectionChangedListener contentSelectionChangedListener;
        int n;
        Object[] objectArray;
        this.xblManager.invalidateChildNodes(xBLOMContentElement.getXblParentNode());
        ContentSelectionChangedEvent contentSelectionChangedEvent = new ContentSelectionChangedEvent(xBLOMContentElement);
        EventListenerList eventListenerList = (EventListenerList)this.listeners.get(xBLOMContentElement);
        if (eventListenerList != null) {
            objectArray = eventListenerList.getListenerList();
            for (n = objectArray.length - 2; n >= 0; n -= 2) {
                contentSelectionChangedListener = (ContentSelectionChangedListener)objectArray[n + 1];
                contentSelectionChangedListener.contentSelectionChanged(contentSelectionChangedEvent);
            }
        }
        objectArray = this.xblManager.getContentSelectionChangedListeners();
        for (n = objectArray.length - 2; n >= 0; n -= 2) {
            contentSelectionChangedListener = (ContentSelectionChangedListener)objectArray[n + 1];
            contentSelectionChangedListener.contentSelectionChanged(contentSelectionChangedEvent);
        }
    }

    protected void update(boolean bl) {
        boolean bl2;
        HashSet hashSet;
        Object object;
        HashSet<Node> hashSet2 = new HashSet<Node>();
        for (Map.Entry object2 : this.selectedNodes.entrySet()) {
            object = (NodeList)object2.getValue();
            for (int hashSet3 = 0; hashSet3 < object.getLength(); ++hashSet3) {
                hashSet = object.item(hashSet3);
                this.xblManager.getRecord((Node)((Object)hashSet)).contentElement = null;
                hashSet2.add((Node)((Object)hashSet));
            }
        }
        for (NodeEventTarget nodeEventTarget : this.contentElementList) {
            nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", this.contentElementDomAttrModifiedEventListener, false);
        }
        this.contentElementList.clear();
        this.selectedNodes.clear();
        boolean bl3 = false;
        for (object = this.shadowTree.getFirstChild(); object != null; object = object.getNextSibling()) {
            if (!this.update(bl, (Node)object)) continue;
            bl2 = true;
        }
        if (bl2) {
            object = new HashSet();
            for (Map.Entry entry : this.selectedNodes.entrySet()) {
                hashSet = (NodeList)entry.getValue();
                for (int i = 0; i < hashSet.getLength(); ++i) {
                    Node node = hashSet.item(i);
                    ((HashSet)object).add(node);
                }
            }
            HashSet<Node> hashSet3 = new HashSet<Node>();
            hashSet3.addAll(hashSet2);
            hashSet3.removeAll((Collection<?>)object);
            hashSet = new HashSet();
            hashSet.addAll(object);
            hashSet.removeAll(hashSet2);
            if (!bl) {
                this.xblManager.shadowTreeSelectedContentChanged(hashSet3, hashSet);
            }
        }
    }

    protected boolean update(boolean bl, Node node) {
        Node node2;
        boolean bl2 = false;
        for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (!this.update(bl, node2)) continue;
            bl2 = true;
        }
        if (node instanceof XBLOMContentElement) {
            boolean bl3;
            Object object;
            this.contentElementList.add(node);
            node2 = (XBLOMContentElement)node;
            ((AbstractNode)node2).addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", this.contentElementDomAttrModifiedEventListener, false, null);
            AbstractContentSelector abstractContentSelector = (AbstractContentSelector)this.selectors.get(node);
            if (abstractContentSelector == null) {
                if (((AbstractElement)node2).hasAttributeNS(null, "includes")) {
                    object = this.getContentSelectorLanguage((Element)node2);
                    String string = ((AbstractElement)node2).getAttributeNS(null, "includes");
                    abstractContentSelector = AbstractContentSelector.createSelector((String)object, this, (XBLOMContentElement)node2, this.boundElement, string);
                } else {
                    abstractContentSelector = new DefaultContentSelector(this, (XBLOMContentElement)node2, this.boundElement);
                }
                this.selectors.put(node, abstractContentSelector);
                bl3 = true;
            } else {
                bl3 = abstractContentSelector.update();
            }
            object = abstractContentSelector.getSelectedContent();
            this.selectedNodes.put(node, object);
            for (int i = 0; i < object.getLength(); ++i) {
                Node node3 = object.item(i);
                this.xblManager.getRecord((Node)node3).contentElement = node2;
            }
            if (bl3) {
                bl2 = true;
                this.dispatchContentSelectionChangedEvent((XBLOMContentElement)node2);
            }
        }
        return bl2;
    }

    protected String getContentSelectorLanguage(Element element) {
        String string = element.getAttributeNS("http://xml.apache.org/batik/ext", "selectorLanguage");
        if (string.length() != 0) {
            return string;
        }
        string = element.getOwnerDocument().getDocumentElement().getAttributeNS("http://xml.apache.org/batik/ext", "selectorLanguage");
        if (string.length() != 0) {
            return string;
        }
        return null;
    }

    protected class ShadowTreeSubtreeModifiedListener
    implements EventListener {
        protected ShadowTreeSubtreeModifiedListener() {
        }

        @Override
        public void handleEvent(Event event) {
            if (ContentManager.this.removedNode != null) {
                ContentManager.this.removedNode = null;
                ContentManager.this.update(false);
            }
        }
    }

    protected class ShadowTreeNodeRemovedListener
    implements EventListener {
        protected ShadowTreeNodeRemovedListener() {
        }

        @Override
        public void handleEvent(Event event) {
            EventTarget eventTarget = event.getTarget();
            if (eventTarget instanceof XBLOMContentElement) {
                ContentManager.this.removedNode = (Node)((Object)event.getTarget());
            }
        }
    }

    protected class ShadowTreeNodeInsertedListener
    implements EventListener {
        protected ShadowTreeNodeInsertedListener() {
        }

        @Override
        public void handleEvent(Event event) {
            if (event.getTarget() instanceof XBLOMContentElement) {
                ContentManager.this.update(false);
            }
        }
    }

    protected class DOMSubtreeModifiedEventListener
    implements EventListener {
        protected DOMSubtreeModifiedEventListener() {
        }

        @Override
        public void handleEvent(Event event) {
            if (ContentManager.this.removedNode != null) {
                ContentManager.this.removedNode = null;
                ContentManager.this.update(false);
            }
        }
    }

    protected class DOMNodeRemovedEventListener
    implements EventListener {
        protected DOMNodeRemovedEventListener() {
        }

        @Override
        public void handleEvent(Event event) {
            ContentManager.this.removedNode = (Node)((Object)event.getTarget());
        }
    }

    protected class DOMNodeInsertedEventListener
    implements EventListener {
        protected DOMNodeInsertedEventListener() {
        }

        @Override
        public void handleEvent(Event event) {
            ContentManager.this.update(false);
        }
    }

    protected class DOMAttrModifiedEventListener
    implements EventListener {
        protected DOMAttrModifiedEventListener() {
        }

        @Override
        public void handleEvent(Event event) {
            if (event.getTarget() != ContentManager.this.boundElement) {
                ContentManager.this.update(false);
            }
        }
    }

    protected class ContentElementDOMAttrModifiedEventListener
    implements EventListener {
        protected ContentElementDOMAttrModifiedEventListener() {
        }

        @Override
        public void handleEvent(Event event) {
            MutationEvent mutationEvent = (MutationEvent)event;
            Attr attr = (Attr)mutationEvent.getRelatedNode();
            Element element = (Element)((Object)event.getTarget());
            if (element instanceof XBLOMContentElement) {
                String string = attr.getNamespaceURI();
                String string2 = attr.getLocalName();
                if (string2 == null) {
                    string2 = attr.getNodeName();
                }
                if (string == null && "includes".equals(string2) || "http://xml.apache.org/batik/ext".equals(string) && "selectorLanguage".equals(string2)) {
                    ContentManager.this.selectors.remove(element);
                    ContentManager.this.update(false);
                }
            }
        }
    }
}

