/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.api.Interface;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class XmlChem3dReader
extends XmlReader {
    private Lst<Map<String, Object>> orbitals = new Lst();
    private Map<String, Object> moData;

    @Override
    protected void processXml(XmlReader parent, Object saxReader) throws Exception {
        this.processXml2(parent, saxReader);
        this.finalizeMOData(this.moData);
    }

    @Override
    public void processStartElement(String localName, String nodeName) {
        String[] tokens;
        if ("model".equals(localName)) {
            this.asc.newAtomSet();
            return;
        }
        if ("atom".equals(localName)) {
            this.atom = new Atom();
            this.atom.atomName = (String)this.atts.get("id");
            this.atom.elementSymbol = (String)this.atts.get("symbol");
            if (this.atts.containsKey("cartcoords")) {
                String xyz = (String)this.atts.get("cartcoords");
                String[] tokens2 = PT.getTokens((String)xyz);
                this.atom.set(this.parseFloatStr(tokens2[0]), this.parseFloatStr(tokens2[1]), this.parseFloatStr(tokens2[2]));
            }
            return;
        }
        if ("bond".equals(localName)) {
            String atom1 = (String)this.atts.get("bondatom1");
            String atom2 = (String)this.atts.get("bondatom2");
            int order = 1;
            if (this.atts.containsKey("bondorder")) {
                order = this.parseIntStr((String)this.atts.get("bondorder"));
            }
            this.asc.addNewBondFromNames(atom1, atom2, order);
            return;
        }
        if ("electronicstructurecalculation".equals(localName)) {
            tokens = PT.getTokens((String)((String)this.atts.get("calcpartialcharges")));
            String[] tokens2 = PT.getTokens((String)((String)this.atts.get("calcatoms")));
            int i = this.parseIntStr(tokens[0]);
            while (--i >= 0) {
                this.asc.mapPartialCharge(tokens2[i + 1], this.parseFloatStr(tokens[i + 1]));
            }
        }
        if ("griddata".equals(localName)) {
            int x;
            int y;
            int z;
            int nPointsX = this.parseIntStr((String)this.atts.get("griddatxdim"));
            int nPointsY = this.parseIntStr((String)this.atts.get("griddatydim"));
            int nPointsZ = this.parseIntStr((String)this.atts.get("griddatzdim"));
            float xStep = this.parseFloatStr((String)this.atts.get("griddatxsize")) / (float)nPointsX;
            float yStep = this.parseFloatStr((String)this.atts.get("griddatysize")) / (float)nPointsY;
            float zStep = this.parseFloatStr((String)this.atts.get("griddatzsize")) / (float)nPointsZ;
            tokens = PT.getTokens((String)((String)this.atts.get("griddatorigin")));
            float ox = this.parseFloatStr(tokens[0]);
            float oy = this.parseFloatStr(tokens[1]);
            float oz = this.parseFloatStr(tokens[2]);
            tokens = PT.getTokens((String)((String)this.atts.get("griddatdata")));
            int pt = 1;
            float[][][] voxelData = new float[nPointsX][nPointsY][nPointsZ];
            float sum = 0.0f;
            for (z = 0; z < nPointsZ; ++z) {
                for (y = 0; y < nPointsY; ++y) {
                    for (x = 0; x < nPointsX; ++x) {
                        float f;
                        voxelData[x][y][z] = f = this.parseFloatStr(tokens[pt++]);
                        sum += f * f;
                    }
                }
            }
            sum = (float)(1.0 / Math.sqrt(sum));
            for (z = 0; z < nPointsZ; ++z) {
                for (y = 0; y < nPointsY; ++y) {
                    for (x = 0; x < nPointsX; ++x) {
                        float[] fArray = voxelData[x][y];
                        int n = z;
                        fArray[n] = fArray[n] * sum;
                    }
                }
            }
            VolumeData vd = (VolumeData)Interface.getOption((String)"jvxl.data.VolumeData", (Viewer)this.vwr, (String)"file");
            vd.setVoxelCounts(nPointsX, nPointsY, nPointsZ);
            vd.setVolumetricVector(0, xStep, 0.0f, 0.0f);
            vd.setVolumetricVector(1, 0.0f, yStep, 0.0f);
            vd.setVolumetricVector(2, 0.0f, 0.0f, zStep);
            vd.setVolumetricOrigin(ox, oy, oz);
            vd.setVoxelDataAsArray(voxelData);
            if (this.moData == null) {
                this.moData = new Hashtable<String, Object>();
                this.moData.put("defaultCutoff", Float.valueOf(0.01f));
                this.moData.put("haveVolumeData", Boolean.TRUE);
                this.moData.put("calculationType", "Chem3D");
                this.orbitals = new Lst();
                this.moData.put("mos", this.orbitals);
            }
            Hashtable<String, VolumeData> mo = new Hashtable<String, VolumeData>();
            mo.put("volumeData", vd);
            this.orbitals.addLast(mo);
            Logger.info((String)("Chem3D molecular orbital data displayable using ISOSURFACE MO " + this.orbitals.size()));
            return;
        }
    }

    @Override
    void processEndElement(String localName) {
        if ("atom".equals(localName)) {
            if (this.atom.elementSymbol != null && !Float.isNaN(this.atom.z)) {
                this.parent.setAtomCoord(this.atom);
                this.asc.addAtomWithMappedName(this.atom);
            }
            this.atom = null;
            return;
        }
        this.setKeepChars(false);
    }
}

