/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionTypeCalculator;
import org.openstreetmap.josm.tools.I18n;

public class PublicTransportRouteTest
extends Test {
    private final WayConnectionTypeCalculator connectionTypeCalculator = new WayConnectionTypeCalculator();

    public PublicTransportRouteTest() {
        super(I18n.tr("Public Transport Route", new Object[0]));
    }

    @Override
    public void visit(Relation relation) {
        boolean bl;
        boolean bl2 = bl = relation.hasIncompleteMembers() || !relation.hasTag("type", "route") || !relation.hasKey("route") || !relation.hasTag("public_transport:version", "2");
        if (bl) {
            return;
        }
        ArrayList<RelationMember> arrayList = new ArrayList<RelationMember>();
        HashSet<Node> hashSet = new HashSet<Node>();
        for (RelationMember relationMember : relation.getMembers()) {
            if (relationMember.hasRole("forward", "backward")) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 3601).message(I18n.tr("Route relation contains a ''{0}'' role", "forward/backward")).primitives(relation).build());
                return;
            }
            if (!relationMember.hasRole("") || !OsmPrimitiveType.WAY.equals((Object)relationMember.getType())) continue;
            arrayList.add(relationMember);
            hashSet.addAll(relationMember.getWay().getNodes());
        }
        if (arrayList.isEmpty()) {
            return;
        }
        List<WayConnectionType> list = this.connectionTypeCalculator.updateLinks(arrayList);
        for (int i = 0; i < list.size(); ++i) {
            boolean bl3;
            WayConnectionType object = (WayConnectionType)list.get(i);
            boolean bl4 = bl3 = i != 0 && !object.linkPrev || i != list.size() - 1 && !object.linkNext || object.direction == null || WayConnectionType.Direction.NONE.equals((Object)object.direction);
            if (!bl3) continue;
            this.errors.add(TestError.builder(this, Severity.WARNING, 3602).message(I18n.tr("Route relation contains a gap", new Object[0])).primitives(relation).build());
            return;
        }
        for (RelationMember relationMember : relation.getMembers()) {
            if (!relationMember.hasRole("stop", "stop_exit_only", "stop_entry_only") || !OsmPrimitiveType.NODE.equals((Object)relationMember.getType()) || hashSet.contains(relationMember.getNode())) continue;
            this.errors.add(TestError.builder(this, Severity.WARNING, 3603).message(I18n.tr("Stop position not part of route", new Object[0])).primitives(relationMember.getMember(), relation).build());
        }
    }
}

