/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.relation;

import java.util.List;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.command.conflict.RelationMemberConflictResolverCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.conflict.pair.ListMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.ListRole;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class RelationMemberListMergeModel
extends ListMergeModel<RelationMember> {
    @Override
    public boolean isEqualEntry(RelationMember relationMember, RelationMember relationMember2) {
        return relationMember.equals(relationMember2);
    }

    @Override
    protected void buildMergedEntriesTableModel() {
        this.mergedEntriesTableModel = new ListMergeModel.EntriesTableModel(this, ListRole.MERGED_ENTRIES){
            {
                RelationMemberListMergeModel relationMemberListMergeModel3 = relationMemberListMergeModel2;
                relationMemberListMergeModel3.getClass();
                super(relationMemberListMergeModel3, listRole);
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                switch (n2) {
                    case 1: {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    @Override
    protected void setValueAt(DefaultTableModel defaultTableModel, Object object, int n, int n2) {
        if (defaultTableModel == this.getMergedTableModel() && n2 == 1) {
            RelationMember relationMember = (RelationMember)this.getMergedEntries().get(n);
            RelationMember relationMember2 = new RelationMember((String)object, relationMember.getMember());
            this.getMergedEntries().remove(n);
            this.getMergedEntries().add(n, relationMember2);
            this.fireModelDataChanged();
        }
    }

    public void populate(Relation relation, Relation relation2, Map<PrimitiveId, PrimitiveId> map) {
        this.initPopulate(relation, relation2, map);
        for (RelationMember relationMember : relation.getMembers()) {
            this.getMyEntries().add(relationMember);
        }
        for (RelationMember relationMember : relation2.getMembers()) {
            this.getTheirEntries().add(relationMember);
        }
        if (this.myAndTheirEntriesEqual()) {
            for (RelationMember relationMember : this.getMyEntries()) {
                this.getMergedEntries().add(this.cloneEntryForMergedList(relationMember));
            }
            this.setFrozen(true);
        } else {
            this.setFrozen(false);
        }
        this.fireModelDataChanged();
    }

    @Override
    protected RelationMember cloneEntryForMergedList(RelationMember relationMember) {
        return new RelationMember(relationMember.getRole(), this.getMyPrimitive(relationMember));
    }

    @Override
    public OsmPrimitive getMyPrimitive(RelationMember relationMember) {
        return this.getMyPrimitiveById(relationMember.getMember());
    }

    public RelationMemberConflictResolverCommand buildResolveCommand(Relation relation, Relation relation2) {
        CheckParameterUtil.ensureParameterNotNull(relation, "my");
        CheckParameterUtil.ensureParameterNotNull(relation2, "their");
        if (!this.isFrozen()) {
            throw new IllegalArgumentException(I18n.tr("Merged nodes not frozen yet. Cannot build resolution command", new Object[0]));
        }
        List<RelationMember> list = this.getMergedEntries();
        return new RelationMemberConflictResolverCommand(relation, relation2, list);
    }
}

