/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.ivars;

import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.runtime.ivars.VariableTableManager;

public class VariableAccessor {
    protected final String name;
    protected final int index;
    protected final int classId;
    protected final RubyClass realClass;
    public static final VariableAccessor DUMMY_ACCESSOR = new VariableAccessor(null, null, -1, -1);

    public VariableAccessor(RubyClass realClass, String name2, int index2, int classId) {
        this.index = index2;
        this.classId = classId;
        this.name = name2;
        this.realClass = realClass;
    }

    public int getClassId() {
        return this.classId;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public Object get(Object object) {
        return VariableAccessor.getVariable((RubyBasicObject)object, this.index);
    }

    public static Object getVariable(RubyBasicObject object, int index2) {
        Object[] ivarTable;
        block5: {
            block4: {
                if (index2 < 0) break block4;
                ivarTable = object.varTable;
                if (object.varTable != null) break block5;
            }
            return null;
        }
        if (ivarTable.length > index2) {
            return ivarTable[index2];
        }
        return null;
    }

    public void set(Object object, Object value2) {
        ((RubyBasicObject)object).checkFrozen();
        VariableTableManager.setVariableInternal(this.realClass, (RubyBasicObject)object, this.index, value2);
    }

    public boolean verify(Object object) {
        return ((RubyBasicObject)object).getMetaClass().getRealClass() == this.realClass;
    }

    public String toString() {
        return "ivar:" + this.getName() + ":" + this.index;
    }
}

