/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrument;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.instrument.Instrumenter;
import com.oracle.truffle.api.instrument.ProbeInstrument;
import com.oracle.truffle.api.instrument.ProbeNode;
import com.oracle.truffle.api.instrument.SyntaxTag;
import com.oracle.truffle.api.instrument.TagInstrument;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.CyclicAssumption;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@Deprecated
public final class Probe {
    private final Class<? extends TruffleLanguage> language;
    private static final boolean TRACE = false;
    private static final String TRACE_PREFIX = "PROBE: ";
    private static final PrintStream OUT = System.out;
    private final Instrumenter instrumenter;
    private final SourceSection sourceSection;
    private final ArrayList<SyntaxTag> tags = new ArrayList();
    private final List<WeakReference<ProbeNode>> probeNodeClones = new ArrayList<WeakReference<ProbeNode>>();
    private final CyclicAssumption probeStateUnchangedCyclic = new CyclicAssumption("Probe state unchanged");
    @CompilerDirectives.CompilationFinal
    private Assumption probeStateUnchangedAssumption = this.probeStateUnchangedCyclic.getAssumption();
    @CompilerDirectives.CompilationFinal
    private boolean isBeforeTagInstrumentActive = false;
    @CompilerDirectives.CompilationFinal
    private boolean isAfterTagInstrumentActive = false;

    private static void trace(String format, Object ... args) {
    }

    Probe(Instrumenter instrumenter, Class<? extends TruffleLanguage> l, ProbeNode probeNode, SourceSection sourceSection) {
        this.instrumenter = instrumenter;
        this.sourceSection = sourceSection;
        this.registerProbeNodeClone(probeNode);
        this.language = l;
    }

    public void tagAs(SyntaxTag tag, Object tagValue) {
        assert (tag != null);
        if (!this.tags.contains(tag)) {
            TagInstrument.AfterTagInstrument afterTagInstrument;
            this.tags.add(tag);
            this.instrumenter.tagAdded(this, tag, tagValue);
            boolean tagInstrumentsChanged = false;
            TagInstrument.BeforeTagInstrument beforeTagInstrument = this.instrumenter.getBeforeTagInstrument();
            if (beforeTagInstrument != null && tag == beforeTagInstrument.getTag()) {
                this.isBeforeTagInstrumentActive = true;
                tagInstrumentsChanged = true;
            }
            if ((afterTagInstrument = this.instrumenter.getAfterTagInstrument()) != null && tag == afterTagInstrument.getTag()) {
                this.isAfterTagInstrumentActive = true;
                tagInstrumentsChanged = true;
            }
            if (tagInstrumentsChanged) {
                this.invalidateProbeUnchanged();
            }
        }
    }

    public boolean isTaggedAs(SyntaxTag tag) {
        assert (tag != null);
        return this.tags.contains(tag);
    }

    public Collection<SyntaxTag> getSyntaxTags() {
        return Collections.unmodifiableCollection(this.tags);
    }

    void attach(ProbeInstrument instrument) throws IllegalStateException {
        if (instrument.isDisposed()) {
            throw new IllegalStateException("Attempt to attach disposed instrument");
        }
        if (instrument.getProbe() != null) {
            throw new IllegalStateException("Attampt to attach an already attached instrument");
        }
        instrument.setAttachedTo(this);
        for (WeakReference<ProbeNode> ref : this.probeNodeClones) {
            ProbeNode probeNode = (ProbeNode)ref.get();
            if (probeNode == null) continue;
            probeNode.addInstrument(instrument);
        }
        this.invalidateProbeUnchanged();
    }

    public SourceSection getProbedSourceSection() {
        return this.sourceSection;
    }

    public String getShortDescription() {
        String location = this.sourceSection == null ? "<unknown>" : this.sourceSection.getShortDescription();
        return "Probe@" + location + this.getTagsDescription();
    }

    void disposeInstrument(ProbeInstrument instrument) throws IllegalStateException {
        for (WeakReference<ProbeNode> ref : this.probeNodeClones) {
            ProbeNode probeNode = (ProbeNode)ref.get();
            if (probeNode == null) continue;
            probeNode.removeInstrument(instrument);
        }
        this.invalidateProbeUnchanged();
    }

    void registerProbeNodeClone(ProbeNode probeNode) {
        this.probeNodeClones.add(new WeakReference<ProbeNode>(probeNode));
    }

    TagInstrument.BeforeTagInstrument getBeforeTagInstrument() {
        this.checkProbeUnchanged();
        return this.isBeforeTagInstrumentActive ? this.instrumenter.getBeforeTagInstrument() : null;
    }

    TagInstrument.AfterTagInstrument getAfterTagInstrument() {
        this.checkProbeUnchanged();
        return this.isAfterTagInstrumentActive ? this.instrumenter.getAfterTagInstrument() : null;
    }

    Class<? extends TruffleLanguage> getLanguage() {
        return this.language;
    }

    void checkProbeUnchanged() {
        try {
            this.probeStateUnchangedAssumption.check();
        }
        catch (InvalidAssumptionException ex) {
            this.probeStateUnchangedAssumption = this.probeStateUnchangedCyclic.getAssumption();
        }
    }

    void invalidateProbeUnchanged() {
        this.probeStateUnchangedCyclic.invalidate();
    }

    void notifyTagInstrumentsChanged() {
        TagInstrument.BeforeTagInstrument beforeTagInstrument = this.instrumenter.getBeforeTagInstrument();
        this.isBeforeTagInstrumentActive = beforeTagInstrument != null && this.isTaggedAs(beforeTagInstrument.getTag());
        TagInstrument.AfterTagInstrument afterTagInstrument = this.instrumenter.getAfterTagInstrument();
        this.isAfterTagInstrumentActive = afterTagInstrument != null && this.isTaggedAs(afterTagInstrument.getTag());
        this.invalidateProbeUnchanged();
    }

    String getTagsDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        String prefix = "";
        for (SyntaxTag tag : this.tags) {
            sb.append(prefix);
            prefix = ",";
            sb.append(tag.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    Instrumenter getInstrumenter() {
        return this.instrumenter;
    }
}

