/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.format;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.nio.charset.StandardCharsets;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.LiteralFormatNode;
import org.jruby.truffle.core.format.convert.ToIntegerNode;
import org.jruby.truffle.core.format.convert.ToIntegerNodeGen;
import org.jruby.truffle.core.format.convert.ToStringNode;
import org.jruby.truffle.core.format.convert.ToStringNodeGen;
import org.jruby.truffle.core.format.exceptions.NoImplicitConversionException;
import org.jruby.truffle.core.format.write.bytes.WriteByteNodeGen;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.util.StringUtils;

@NodeChildren(value={@NodeChild(value="width", type=FormatNode.class), @NodeChild(value="value", type=FormatNode.class)})
public abstract class FormatCharacterNode
extends FormatNode {
    private final boolean hasMinusFlag;
    @Node.Child
    private ToIntegerNode toIntegerNode;
    @Node.Child
    private ToStringNode toStringNode;

    public FormatCharacterNode(RubyContext context, boolean hasMinusFlag) {
        super(context);
        this.hasMinusFlag = hasMinusFlag;
    }

    @Specialization(guards={"width == cachedWidth"}, limit="getLimit()")
    byte[] formatCached(VirtualFrame frame, int width, Object value, @Cached(value="width") int cachedWidth, @Cached(value="makeFormatString(width)") String cachedFormatString) {
        String charString = this.getCharString(frame, value);
        return this.doFormat(charString, cachedFormatString);
    }

    @Specialization(contains={"formatCached"})
    protected byte[] format(VirtualFrame frame, int width, Object value) {
        String charString = this.getCharString(frame, value);
        return this.doFormat(charString, this.makeFormatString(width));
    }

    protected String getCharString(VirtualFrame frame, Object value) {
        String charString;
        Object toStrResult;
        if (this.toStringNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toStringNode = this.insert(ToStringNodeGen.create(this.getContext(), false, "to_str", false, null, WriteByteNodeGen.create(this.getContext(), new LiteralFormatNode(this.getContext(), value))));
        }
        try {
            toStrResult = this.toStringNode.executeToString(frame, value);
        }
        catch (NoImplicitConversionException e) {
            toStrResult = null;
        }
        if (toStrResult == null || this.isNil(toStrResult)) {
            if (this.toIntegerNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toIntegerNode = this.insert(ToIntegerNodeGen.create(this.getContext(), null));
            }
            int charValue = (Integer)this.toIntegerNode.executeToInteger(frame, value);
            charString = Character.toString((char)charValue);
        } else {
            String resultString = StringUtils.create((byte[])toStrResult);
            int size = resultString.length();
            if (size > 1) {
                throw new RaiseException(this.getContext().getCoreExceptions().argumentErrorCharacterRequired(this));
            }
            charString = resultString;
        }
        return charString;
    }

    @CompilerDirectives.TruffleBoundary
    protected String makeFormatString(int width) {
        boolean leftJustified;
        boolean bl = leftJustified = this.hasMinusFlag || width < 0;
        if (width < 0) {
            width = -width;
        }
        return "%" + (leftJustified ? "-" : "") + width + "." + width + "s";
    }

    @CompilerDirectives.TruffleBoundary
    private byte[] doFormat(String charString, String formatString) {
        return StringUtils.format(formatString, charString).getBytes(StandardCharsets.US_ASCII);
    }

    protected int getLimit() {
        return this.getContext().getOptions().PACK_CACHE;
    }
}

