/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.locals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.language.RubyGuards;

@ImportStatic(value={RubyGuards.class})
public abstract class WriteFrameSlotNode
extends Node {
    private final FrameSlot frameSlot;

    public WriteFrameSlotNode(FrameSlot frameSlot) {
        this.frameSlot = frameSlot;
    }

    public abstract Object executeWrite(Frame var1, Object var2);

    @Specialization(guards={"checkBooleanKind(frame)"})
    public boolean writeBoolean(Frame frame, boolean value) {
        frame.setBoolean(this.frameSlot, value);
        return value;
    }

    @Specialization(guards={"checkIntegerKind(frame)"})
    public int writeInteger(Frame frame, int value) {
        frame.setInt(this.frameSlot, value);
        return value;
    }

    @Specialization(guards={"checkLongKind(frame)"})
    public long writeLong(Frame frame, long value) {
        frame.setLong(this.frameSlot, value);
        return value;
    }

    @Specialization(guards={"checkDoubleKind(frame)"})
    public double writeDouble(Frame frame, double value) {
        frame.setDouble(this.frameSlot, value);
        return value;
    }

    @Specialization(guards={"checkObjectKind(frame)"}, contains={"writeBoolean", "writeInteger", "writeLong", "writeDouble"})
    public Object writeObject(Frame frame, Object value) {
        assert (RubyGuards.wasProvided(value));
        frame.setObject(this.frameSlot, value);
        return value;
    }

    protected boolean checkBooleanKind(Frame frame) {
        return this.checkKind(FrameSlotKind.Boolean);
    }

    protected boolean checkIntegerKind(Frame frame) {
        return this.checkKind(FrameSlotKind.Int);
    }

    protected boolean checkLongKind(Frame frame) {
        return this.checkKind(FrameSlotKind.Long);
    }

    protected boolean checkDoubleKind(Frame frame) {
        return this.checkKind(FrameSlotKind.Double);
    }

    protected boolean checkObjectKind(Frame frame) {
        if (this.frameSlot.getKind() != FrameSlotKind.Object) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.frameSlot.setKind(FrameSlotKind.Object);
        }
        return true;
    }

    private boolean checkKind(FrameSlotKind kind) {
        if (this.frameSlot.getKind() == kind) {
            return true;
        }
        return this.initialSetKind(kind);
    }

    private boolean initialSetKind(FrameSlotKind kind) {
        if (this.frameSlot.getKind() == FrameSlotKind.Illegal) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.frameSlot.setKind(kind);
            return true;
        }
        return false;
    }

    public final FrameSlot getFrameSlot() {
        return this.frameSlot;
    }
}

