/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.framework.ToolListener;
import CH.ifa.draw.standard.AbstractTool;
import CH.ifa.draw.util.Undoable;
import CH.ifa.draw.util.UndoableAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;

public class UndoableTool
implements Tool,
ToolListener {
    private Tool myWrappedTool;
    private AbstractTool.EventDispatcher myEventDispatcher;

    public UndoableTool(Tool newWrappedTool) {
        this.setEventDispatcher(this.createEventDispatcher());
        this.setWrappedTool(newWrappedTool);
        this.getWrappedTool().addToolListener(this);
    }

    public void activate() {
        this.getWrappedTool().activate();
    }

    public void deactivate() {
        this.getWrappedTool().deactivate();
        Undoable undoActivity = this.getWrappedTool().getUndoActivity();
        if (undoActivity != null && undoActivity.isUndoable()) {
            this.editor().getUndoManager().pushUndo(undoActivity);
            this.editor().getUndoManager().clearRedos();
            this.editor().figureSelectionChanged(this.view());
        }
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        this.getWrappedTool().mouseDown(e, x, y);
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
        this.getWrappedTool().mouseDrag(e, x, y);
    }

    public void mouseUp(MouseEvent e, int x, int y) {
        this.getWrappedTool().mouseUp(e, x, y);
    }

    public void mouseMove(MouseEvent evt, int x, int y) {
        this.getWrappedTool().mouseMove(evt, x, y);
    }

    public void keyDown(KeyEvent evt, int key) {
        this.getWrappedTool().keyDown(evt, key);
    }

    public boolean isUsable() {
        return this.getWrappedTool().isUsable();
    }

    public boolean isActive() {
        return this.editor().tool() == this;
    }

    public boolean isEnabled() {
        return this.getWrappedTool().isEnabled();
    }

    public void setUsable(boolean newIsUsable) {
        this.getWrappedTool().setUsable(newIsUsable);
    }

    public void setEnabled(boolean newIsEnabled) {
        this.getWrappedTool().setEnabled(newIsEnabled);
    }

    protected void setWrappedTool(Tool newWrappedTool) {
        this.myWrappedTool = newWrappedTool;
    }

    protected Tool getWrappedTool() {
        return this.myWrappedTool;
    }

    public DrawingEditor editor() {
        return this.getWrappedTool().editor();
    }

    public DrawingView view() {
        return this.editor().view();
    }

    public Undoable getUndoActivity() {
        return new UndoableAdapter(this.view());
    }

    public void setUndoActivity(Undoable newUndoableActivity) {
    }

    public void toolUsable(EventObject toolEvent) {
        this.getEventDispatcher().fireToolUsableEvent();
    }

    public void toolUnusable(EventObject toolEvent) {
        this.getEventDispatcher().fireToolUnusableEvent();
    }

    public void toolActivated(EventObject toolEvent) {
        this.getEventDispatcher().fireToolActivatedEvent();
    }

    public void toolDeactivated(EventObject toolEvent) {
        this.getEventDispatcher().fireToolDeactivatedEvent();
    }

    public void toolEnabled(EventObject toolEvent) {
        this.getEventDispatcher().fireToolEnabledEvent();
    }

    public void toolDisabled(EventObject toolEvent) {
        this.getEventDispatcher().fireToolDisabledEvent();
    }

    public void addToolListener(ToolListener newToolListener) {
        this.getEventDispatcher().addToolListener(newToolListener);
    }

    public void removeToolListener(ToolListener oldToolListener) {
        this.getEventDispatcher().removeToolListener(oldToolListener);
    }

    private void setEventDispatcher(AbstractTool.EventDispatcher newEventDispatcher) {
        this.myEventDispatcher = newEventDispatcher;
    }

    protected AbstractTool.EventDispatcher getEventDispatcher() {
        return this.myEventDispatcher;
    }

    public AbstractTool.EventDispatcher createEventDispatcher() {
        return new AbstractTool.EventDispatcher(this);
    }
}

