/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.application;

import ch.ehi.interlis.attributes.AttributeDef;
import ch.ehi.interlis.modeltopicclass.ClassDef;
import ch.ehi.uml1_4.foundation.core.Element;
import ch.ehi.uml1_4.foundation.core.ModelElement;
import ch.ehi.uml1_4.modelmanagement.Package;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class TreeDropTarget
implements DropTargetListener {
    DropTarget target;
    JTree targetTree;

    public TreeDropTarget(JTree tree) {
        this.targetTree = tree;
        this.target = new DropTarget(this.targetTree, this);
    }

    private Element getNodeForEvent(DropTargetDragEvent dtde) {
        Point p = dtde.getLocation();
        DropTargetContext dtc = dtde.getDropTargetContext();
        JTree tree = (JTree)dtc.getComponent();
        TreePath path = tree.getClosestPathForLocation(p.x, p.y);
        return (Element)path.getLastPathComponent();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        Element node = this.getNodeForEvent(dtde);
        dtde.acceptDrag(2);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        Element node = this.getNodeForEvent(dtde);
        dtde.acceptDrag(2);
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Point pt = dtde.getLocation();
        DropTargetContext dtc = dtde.getDropTargetContext();
        JTree tree = (JTree)dtc.getComponent();
        TreePath parentpath = tree.getClosestPathForLocation(pt.x, pt.y);
        Element parent = (Element)parentpath.getLastPathComponent();
        dtde.acceptDrop(2);
        try {
            Transferable tr = dtde.getTransferable();
            DataFlavor[] flavors = tr.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!tr.isDataFlavorSupported(flavors[i])) continue;
                TreePath p = (TreePath)tr.getTransferData(flavors[i]);
                Element node = (Element)p.getLastPathComponent();
                Element ele = node;
                if (ele instanceof AttributeDef) {
                    AttributeDef attr = (AttributeDef)ele;
                    ele = parent;
                    ClassDef aclass = (ClassDef)ele;
                    attr.detachOwner();
                    aclass.addFeature(attr);
                } else if (ele instanceof ModelElement) {
                    ModelElement aclass = (ModelElement)ele;
                    ele = parent;
                    Package apackage = (Package)ele;
                    aclass.detachNamespace();
                    apackage.addOwnedElement(aclass);
                }
                dtde.dropComplete(true);
                return;
            }
            dtde.rejectDrop();
        }
        catch (Exception e) {
            e.printStackTrace();
            dtde.rejectDrop();
        }
    }
}

