/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.alert;

import java.awt.EventQueue;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordAlert;
import org.parosproxy.paros.db.RecordScan;
import org.parosproxy.paros.db.TableAlert;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.extension.ViewDelegate;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.MainFooterPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.ZAP;
import org.zaproxy.zap.eventBus.Event;
import org.zaproxy.zap.extension.XmlReporterExtension;
import org.zaproxy.zap.extension.alert.AlertEventPublisher;
import org.zaproxy.zap.extension.alert.AlertNode;
import org.zaproxy.zap.extension.alert.AlertPanel;
import org.zaproxy.zap.extension.alert.AlertParam;
import org.zaproxy.zap.extension.alert.AlertTreeModel;
import org.zaproxy.zap.extension.alert.OptionsAlertPanel;
import org.zaproxy.zap.extension.alert.PopupMenuAlertDelete;
import org.zaproxy.zap.extension.alert.PopupMenuAlertEdit;
import org.zaproxy.zap.extension.alert.PopupMenuAlertsRefresh;
import org.zaproxy.zap.extension.alert.PopupMenuShowAlerts;
import org.zaproxy.zap.extension.help.ExtensionHelp;
import org.zaproxy.zap.model.SessionStructure;
import org.zaproxy.zap.model.Target;

public class ExtensionAlert
extends ExtensionAdaptor
implements SessionChangedListener,
XmlReporterExtension {
    public static final String NAME = "ExtensionAlert";
    private Map<Integer, HistoryReference> hrefs = new HashMap<Integer, HistoryReference>();
    private AlertTreeModel treeModel = null;
    private AlertTreeModel filteredTreeModel = null;
    private AlertPanel alertPanel = null;
    private RecordScan recordScan = null;
    private PopupMenuAlertEdit popupMenuAlertEdit = null;
    private PopupMenuAlertDelete popupMenuAlertDelete = null;
    private PopupMenuAlertsRefresh popupMenuAlertsRefresh = null;
    private PopupMenuShowAlerts popupMenuShowAlerts = null;
    private Logger logger = Logger.getLogger(ExtensionAlert.class);
    private AlertParam alertParam = null;
    private OptionsAlertPanel optionsPanel = null;

    public ExtensionAlert() {
        this.initialize();
    }

    public ExtensionAlert(String string) {
        super(string);
    }

    private void initialize() {
        this.setName(NAME);
        this.setOrder(27);
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        extensionHook.addOptionsParamSet(this.getAlertParam());
        if (this.getView() != null) {
            extensionHook.getHookView().addOptionPanel(this.getOptionsPanel());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuAlertEdit());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuAlertDelete());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuAlertsRefresh());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuShowAlerts());
            extensionHook.getHookView().addStatusPanel(this.getAlertPanel());
            ExtensionHelp.enableHelpKey(this.getAlertPanel(), "ui.tabs.alerts");
        }
        extensionHook.addSessionListener(this);
    }

    private OptionsAlertPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new OptionsAlertPanel();
        }
        return this.optionsPanel;
    }

    private AlertParam getAlertParam() {
        if (this.alertParam == null) {
            this.alertParam = new AlertParam();
        }
        return this.alertParam;
    }

    public void alertFound(Alert alert, HistoryReference historyReference) {
        try {
            this.logger.debug((Object)("alertFound " + alert.getName() + " " + alert.getUri()));
            if (historyReference == null) {
                historyReference = alert.getHistoryRef();
            }
            if (historyReference == null) {
                historyReference = new HistoryReference(this.getModel().getSession(), 3, alert.getMessage());
                alert.setHistoryRef(historyReference);
            }
            alert.setSourceHistoryId(historyReference.getHistoryId());
            this.hrefs.put(historyReference.getHistoryId(), historyReference);
            this.writeAlertToDB(alert, historyReference);
            try {
                if (this.getView() == null || EventQueue.isDispatchThread()) {
                    SessionStructure.addPath(Model.getSingleton().getSession(), historyReference, alert.getMessage());
                } else {
                    final HistoryReference historyReference2 = historyReference;
                    final HttpMessage httpMessage = alert.getMessage();
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            SessionStructure.addPath(Model.getSingleton().getSession(), historyReference2, httpMessage);
                        }
                    });
                }
                historyReference.addAlert(alert);
            }
            catch (Exception exception) {
                this.logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
            this.addAlertToTree(alert);
            alert.setMessage(null);
            this.publishAlertEvent(alert, "alert.added");
        }
        catch (Exception exception) {
            this.logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    private void publishAlertEvent(Alert alert, String string) {
        HistoryReference historyReference = this.hrefs.get(alert.getSourceHistoryId());
        if (historyReference == null) {
            historyReference = Control.getSingleton().getExtensionLoader().getExtension(ExtensionHistory.class).getHistoryReference(alert.getSourceHistoryId());
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("alertId", Integer.toString(alert.getAlertId()));
        hashMap.put("historyId", Integer.toString(alert.getSourceHistoryId()));
        ZAP.getEventBus().publishSyncEvent(AlertEventPublisher.getPublisher(), new Event(AlertEventPublisher.getPublisher(), string, new Target(historyReference.getSiteNode()), hashMap));
    }

    private void addAlertToTree(final Alert alert) {
        if (Constant.isLowMemoryOptionSet()) {
            return;
        }
        if (!View.isInitialised() || EventQueue.isDispatchThread()) {
            this.addAlertToTreeEventHandler(alert);
        } else {
            try {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExtensionAlert.this.addAlertToTreeEventHandler(alert);
                    }
                });
            }
            catch (Exception exception) {
                this.logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private boolean isInFilter(Alert alert) {
        return this.getModel().getSession().isInScope(alert.getHistoryRef());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAlertToTreeEventHandler(Alert alert) {
        AlertTreeModel alertTreeModel = this.getTreeModel();
        synchronized (alertTreeModel) {
            this.getTreeModel().addPath(alert);
            if (this.isInFilter(alert)) {
                this.getFilteredTreeModel().addPath(alert);
            }
            if (this.getView() != null) {
                this.getAlertPanel().expandRoot();
                this.recalcAlerts();
            }
        }
    }

    AlertPanel getAlertPanel() {
        if (this.alertPanel == null) {
            this.alertPanel = new AlertPanel(this);
            this.alertPanel.setView(this.getView());
            this.alertPanel.setSize(345, 122);
            this.setMainTreeModel();
        }
        return this.alertPanel;
    }

    @Override
    public void initView(ViewDelegate viewDelegate) {
        super.initView(viewDelegate);
        this.getAlertPanel().setView(viewDelegate);
    }

    AlertTreeModel getTreeModel() {
        if (this.treeModel == null) {
            this.treeModel = new AlertTreeModel();
        }
        return this.treeModel;
    }

    private AlertTreeModel getFilteredTreeModel() {
        if (this.filteredTreeModel == null) {
            this.filteredTreeModel = new AlertTreeModel();
        }
        return this.filteredTreeModel;
    }

    private void writeAlertToDB(Alert alert, HistoryReference historyReference) throws HttpMalformedHeaderException, DatabaseException {
        TableAlert tableAlert = this.getModel().getDb().getTableAlert();
        int n = 0;
        if (this.recordScan != null) {
            n = this.recordScan.getScanId();
        }
        RecordAlert recordAlert = tableAlert.write(n, alert.getPluginId(), alert.getName(), alert.getRisk(), alert.getConfidence(), alert.getDescription(), alert.getUri(), alert.getParam(), alert.getAttack(), alert.getOtherInfo(), alert.getSolution(), alert.getReference(), alert.getEvidence(), alert.getCweId(), alert.getWascId(), historyReference.getHistoryId(), alert.getSourceHistoryId());
        alert.setAlertId(recordAlert.getAlertId());
    }

    public void updateAlert(Alert alert) throws HttpMalformedHeaderException, DatabaseException {
        this.logger.debug((Object)("updateAlert " + alert.getName() + " " + alert.getUri()));
        HistoryReference historyReference = this.hrefs.get(alert.getSourceHistoryId());
        if (historyReference != null) {
            this.updateAlertInDB(alert);
            historyReference.updateAlert(alert);
            this.publishAlertEvent(alert, "alert.changed");
            this.updateAlertInTree(alert, alert);
        }
    }

    private void updateAlertInDB(Alert alert) throws HttpMalformedHeaderException, DatabaseException {
        TableAlert tableAlert = this.getModel().getDb().getTableAlert();
        tableAlert.update(alert.getAlertId(), alert.getName(), alert.getRisk(), alert.getConfidence(), alert.getDescription(), alert.getUri(), alert.getParam(), alert.getAttack(), alert.getOtherInfo(), alert.getSolution(), alert.getReference(), alert.getEvidence(), alert.getCweId(), alert.getWascId(), alert.getSourceHistoryId());
    }

    public void displayAlert(Alert alert) {
        this.logger.debug((Object)("displayAlert " + alert.getName() + " " + alert.getUri()));
        this.alertPanel.getAlertViewPanel().displayAlert(alert);
    }

    public void updateAlertInTree(Alert alert, Alert alert2) {
        if (Constant.isLowMemoryOptionSet()) {
            return;
        }
        this.getTreeModel().updatePath(alert, alert2);
        if (this.isInFilter(alert2)) {
            this.getFilteredTreeModel().updatePath(alert, alert2);
        }
        this.recalcAlerts();
    }

    @Override
    public void sessionChanged(final Session session) {
        if (EventQueue.isDispatchThread()) {
            this.sessionChangedEventHandler(session);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExtensionAlert.this.sessionChangedEventHandler(session);
                    }
                });
            }
            catch (Exception exception) {
                this.logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private void sessionChangedEventHandler(Session session) {
        this.setTreeModel(new AlertTreeModel());
        this.treeModel = null;
        this.filteredTreeModel = null;
        this.hrefs = new HashMap<Integer, HistoryReference>();
        if (session == null) {
            return;
        }
        try {
            this.refreshAlert(session);
        }
        catch (DatabaseException databaseException) {
            this.logger.error((Object)databaseException.getMessage(), (Throwable)databaseException);
        }
        this.setTreeModel(this.getTreeModel());
    }

    private void refreshAlert(Session session) throws DatabaseException {
        if (Constant.isLowMemoryOptionSet()) {
            return;
        }
        SiteMap siteMap = this.getModel().getSession().getSiteTree();
        TableAlert tableAlert = this.getModel().getDb().getTableAlert();
        Vector<Integer> vector = tableAlert.getAlertList();
        ExtensionHistory extensionHistory = (ExtensionHistory)Control.getSingleton().getExtensionLoader().getExtension("ExtensionHistory");
        for (int i = 0; i < vector.size(); ++i) {
            Alert alert;
            int n = vector.get(i);
            RecordAlert recordAlert = tableAlert.read(n);
            int n2 = recordAlert.getHistoryId();
            HistoryReference historyReference = null;
            if (extensionHistory != null) {
                historyReference = extensionHistory.getHistoryReference(n2);
            }
            if (historyReference == null) {
                historyReference = this.hrefs.get(n2);
            }
            if ((historyReference = (alert = historyReference != null ? new Alert(recordAlert, historyReference) : new Alert(recordAlert)).getHistoryRef()) == null) continue;
            this.addAlertToTree(alert);
            Integer n3 = n2;
            if (this.hrefs.containsKey(n3)) continue;
            this.hrefs.put(n3, alert.getHistoryRef());
        }
        siteMap.nodeStructureChanged((SiteNode)siteMap.getRoot());
    }

    private PopupMenuAlertEdit getPopupMenuAlertEdit() {
        if (this.popupMenuAlertEdit == null) {
            this.popupMenuAlertEdit = new PopupMenuAlertEdit();
            this.popupMenuAlertEdit.setExtension(this);
        }
        return this.popupMenuAlertEdit;
    }

    private PopupMenuAlertDelete getPopupMenuAlertDelete() {
        if (this.popupMenuAlertDelete == null) {
            this.popupMenuAlertDelete = new PopupMenuAlertDelete();
            this.popupMenuAlertDelete.setExtension(this);
        }
        return this.popupMenuAlertDelete;
    }

    private PopupMenuAlertsRefresh getPopupMenuAlertsRefresh() {
        if (this.popupMenuAlertsRefresh == null) {
            this.popupMenuAlertsRefresh = new PopupMenuAlertsRefresh();
            this.popupMenuAlertsRefresh.setExtension(this);
        }
        return this.popupMenuAlertsRefresh;
    }

    private PopupMenuShowAlerts getPopupMenuShowAlerts() {
        if (this.popupMenuShowAlerts == null) {
            this.popupMenuShowAlerts = new PopupMenuShowAlerts(Constant.messages.getString("alerts.view.popup"));
        }
        return this.popupMenuShowAlerts;
    }

    public void deleteAlert(Alert alert) {
        this.logger.debug((Object)("deleteAlert " + alert.getName() + " " + alert.getUri()));
        try {
            this.getModel().getDb().getTableAlert().deleteAlert(alert.getAlertId());
        }
        catch (DatabaseException databaseException) {
            this.logger.error((Object)databaseException.getMessage(), (Throwable)databaseException);
        }
        this.deleteAlertFromDisplay(alert);
        this.publishAlertEvent(alert, "alert.removed");
    }

    public void deleteAllAlerts() {
        try {
            this.getModel().getDb().getTableAlert().deleteAllAlerts();
        }
        catch (DatabaseException databaseException) {
            this.logger.error((Object)databaseException.getMessage(), (Throwable)databaseException);
        }
        SiteMap siteMap = this.getModel().getSession().getSiteTree();
        ((SiteNode)siteMap.getRoot()).deleteAllAlerts();
        for (HistoryReference historyReference : this.hrefs.values()) {
            historyReference.deleteAllAlerts();
        }
        ZAP.getEventBus().publishSyncEvent(AlertEventPublisher.getPublisher(), new Event(AlertEventPublisher.getPublisher(), "alert.all.removed", null));
        this.hrefs = new HashMap<Integer, HistoryReference>();
        this.treeModel = null;
        this.filteredTreeModel = null;
        this.setTreeModel(this.getTreeModel());
    }

    private void deleteAlertFromDisplay(final Alert alert) {
        if (this.getView() == null || Constant.isLowMemoryOptionSet()) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            this.deleteAlertFromDisplayEventHandler(alert);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExtensionAlert.this.deleteAlertFromDisplayEventHandler(alert);
                    }
                });
            }
            catch (Exception exception) {
                this.logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAlertFromDisplayEventHandler(Alert alert) {
        AlertTreeModel alertTreeModel = this.getTreeModel();
        synchronized (alertTreeModel) {
            this.getTreeModel().deletePath(alert);
            this.getFilteredTreeModel().deletePath(alert);
            ArrayList<HistoryReference> arrayList = new ArrayList<HistoryReference>();
            for (HistoryReference historyReference : this.hrefs.values()) {
                if (!historyReference.getAlerts().contains(alert)) continue;
                historyReference.deleteAlert(alert);
                if (historyReference.getAlerts().size() != 0) continue;
                arrayList.add(historyReference);
            }
            for (HistoryReference historyReference : arrayList) {
                this.hrefs.remove(historyReference.getHistoryId());
            }
        }
        this.recalcAlerts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteHistoryReferenceAlerts(HistoryReference historyReference) {
        List<Alert> list = historyReference.getAlerts();
        SiteMap siteMap = this.getModel().getSession().getSiteTree();
        AlertTreeModel alertTreeModel = this.getTreeModel();
        synchronized (alertTreeModel) {
            for (int i = 0; i < list.size(); ++i) {
                Alert alert = list.get(i);
                this.getTreeModel().deletePath(alert);
                this.getFilteredTreeModel().deletePath(alert);
                try {
                    this.getModel().getDb().getTableAlert().deleteAlert(alert.getAlertId());
                    continue;
                }
                catch (DatabaseException databaseException) {
                    this.logger.error((Object)("Failed to delete alert with ID: " + alert.getAlertId()), (Throwable)databaseException);
                }
            }
            SiteNode siteNode = historyReference.getSiteNode();
            if (siteNode == null) {
                siteNode = siteMap.findNode(historyReference.getURI(), historyReference.getMethod(), historyReference.getRequestBody());
            }
            if (siteNode != null) {
                siteNode.deleteAlerts(list);
            }
            list.clear();
            this.recalcAlerts();
        }
        this.hrefs.remove(historyReference.getHistoryId());
    }

    void recalcAlerts() {
        if (!View.isInitialised()) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        AlertNode alertNode = (AlertNode)this.getAlertPanel().getTreeAlert().getModel().getRoot();
        if (alertNode != null) {
            block6: for (int i = 0; i < alertNode.getChildCount(); ++i) {
                AlertNode alertNode2 = alertNode.getChildAt(i);
                switch (alertNode2.getRisk()) {
                    case 0: {
                        ++n;
                        continue block6;
                    }
                    case 1: {
                        ++n2;
                        continue block6;
                    }
                    case 2: {
                        ++n3;
                        continue block6;
                    }
                    case 3: {
                        ++n4;
                    }
                }
            }
        }
        MainFooterPanel mainFooterPanel = View.getSingleton().getMainFrame().getMainFooterPanel();
        mainFooterPanel.setAlertInfo(n);
        mainFooterPanel.setAlertLow(n2);
        mainFooterPanel.setAlertMedium(n3);
        mainFooterPanel.setAlertHigh(n4);
    }

    public List<Alert> getAllAlerts() {
        ArrayList<Alert> arrayList = new ArrayList<Alert>();
        TableAlert tableAlert = this.getModel().getDb().getTableAlert();
        try {
            Vector<Integer> vector = tableAlert.getAlertList();
            for (int i = 0; i < vector.size(); ++i) {
                int n = vector.get(i);
                RecordAlert recordAlert = tableAlert.read(n);
                Alert alert = new Alert(recordAlert);
                if (arrayList.contains(alert)) continue;
                arrayList.add(alert);
            }
        }
        catch (DatabaseException databaseException) {
            this.logger.error((Object)databaseException.getMessage(), (Throwable)databaseException);
        }
        return arrayList;
    }

    @Override
    public String getXml(SiteNode siteNode) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<alerts>");
        List<Alert> list = siteNode.getAlerts();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < list.size(); ++i) {
            String string;
            Alert alert = list.get(i);
            if (alert.getConfidence() == 0) continue;
            if (this.getAlertParam().isMergeRelatedIssues()) {
                string = this.alertFingerprint(alert);
                if (!treeSet.add(string)) continue;
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.append("  <instances>\n");
                int n = 0;
                for (int j = i; j < list.size(); ++j) {
                    Alert alert2 = list.get(j);
                    if (!string.equals(this.alertFingerprint(alert2))) continue;
                    if (this.getAlertParam().getMaximumInstances() == 0 || n < this.getAlertParam().getMaximumInstances()) {
                        stringBuilder2.append("  <instance>\n");
                        stringBuilder2.append(alert2.getUrlParamXML());
                        stringBuilder2.append("  </instance>\n");
                    }
                    ++n;
                }
                stringBuilder2.append("  </instances>\n");
                stringBuilder2.append("  <count>");
                stringBuilder2.append(n);
                stringBuilder2.append("</count>\n");
                stringBuilder.append(alert.toPluginXML(stringBuilder2.toString()));
                continue;
            }
            string = alert.getUrlParamXML();
            stringBuilder.append(alert.toPluginXML(string));
        }
        stringBuilder.append("</alerts>");
        return stringBuilder.toString();
    }

    private String alertFingerprint(Alert alert) {
        return alert.getPluginId() + "/" + alert.getName() + "/" + alert.getRisk() + "/" + alert.getConfidence();
    }

    @Override
    public void sessionAboutToChange(Session session) {
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("alerts.desc");
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sessionScopeChanged(Session session) {
        AlertTreeModel alertTreeModel = this.getTreeModel();
        synchronized (alertTreeModel) {
            ((AlertNode)this.getFilteredTreeModel().getRoot()).removeAllChildren();
            AlertNode alertNode = (AlertNode)this.getTreeModel().getRoot();
            this.filterTree(alertNode);
            this.getFilteredTreeModel().nodeStructureChanged(alertNode);
        }
        this.recalcAlerts();
    }

    private void filterTree(AlertNode alertNode) {
        Alert alert;
        if (alertNode.getUserObject() != null && this.isInFilter(alert = alertNode.getUserObject())) {
            this.getFilteredTreeModel().addPath(alert);
        }
        for (int i = 0; i < alertNode.getChildCount(); ++i) {
            this.filterTree(alertNode.getChildAt(i));
        }
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
    }

    public void setAlertTabFocus() {
        this.getAlertPanel().setTabFocus();
    }

    public void setShowJustInScope(boolean bl) {
        if (bl) {
            this.setLinkWithSitesTreeSelection(false);
            this.setTreeModel(this.getFilteredTreeModel());
        } else {
            this.setMainTreeModel();
        }
    }

    void setMainTreeModel() {
        this.setTreeModel(this.getTreeModel());
    }

    private void setTreeModel(AlertTreeModel alertTreeModel) {
        if (this.getView() == null) {
            return;
        }
        this.getAlertPanel().getTreeAlert().setModel(alertTreeModel);
        this.recalcAlerts();
    }

    public void setLinkWithSitesTreeSelection(boolean bl) {
        this.getAlertPanel().setLinkWithSitesTreeSelection(bl);
    }

    @Override
    public boolean supportsDb(String string) {
        return true;
    }

    @Override
    public boolean supportsLowMemory() {
        return true;
    }
}

