/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import java.util.Collection;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.fielddata.AtomicOrdinalsFieldData;
import org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalMapping;
import org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalsIndexFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractAtomicOrdinalsFieldData;

final class InternalGlobalOrdinalsIndexFieldData
extends GlobalOrdinalsIndexFieldData {
    private final Atomic[] atomicReaders;

    InternalGlobalOrdinalsIndexFieldData(IndexSettings indexSettings, String fieldName, AtomicOrdinalsFieldData[] segmentAfd, MultiDocValues.OrdinalMap ordinalMap, long memorySizeInBytes) {
        super(indexSettings, fieldName, memorySizeInBytes);
        this.atomicReaders = new Atomic[segmentAfd.length];
        for (int i = 0; i < segmentAfd.length; ++i) {
            this.atomicReaders[i] = new Atomic(segmentAfd[i], ordinalMap, i);
        }
    }

    @Override
    public AtomicOrdinalsFieldData load(LeafReaderContext context) {
        return this.atomicReaders[context.ord];
    }

    private final class Atomic
    extends AbstractAtomicOrdinalsFieldData {
        private final AtomicOrdinalsFieldData afd;
        private final MultiDocValues.OrdinalMap ordinalMap;
        private final int segmentIndex;

        private Atomic(AtomicOrdinalsFieldData afd, MultiDocValues.OrdinalMap ordinalMap, int segmentIndex) {
            this.afd = afd;
            this.ordinalMap = ordinalMap;
            this.segmentIndex = segmentIndex;
        }

        @Override
        public RandomAccessOrds getOrdinalsValues() {
            RandomAccessOrds values = this.afd.getOrdinalsValues();
            if (values.getValueCount() == this.ordinalMap.getValueCount()) {
                return values;
            }
            RandomAccessOrds[] bytesValues = new RandomAccessOrds[InternalGlobalOrdinalsIndexFieldData.this.atomicReaders.length];
            for (int i = 0; i < bytesValues.length; ++i) {
                bytesValues[i] = ((InternalGlobalOrdinalsIndexFieldData)InternalGlobalOrdinalsIndexFieldData.this).atomicReaders[i].afd.getOrdinalsValues();
            }
            return new GlobalOrdinalMapping(this.ordinalMap, bytesValues, this.segmentIndex);
        }

        public long ramBytesUsed() {
            return this.afd.ramBytesUsed();
        }

        public Collection<Accountable> getChildResources() {
            return this.afd.getChildResources();
        }

        @Override
        public void close() {
        }
    }
}

