/*
 * Decompiled with CFR 0.152.
 */
package esmska.persistence;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.Validate;

public class BackupManager {
    private static final Logger logger = Logger.getLogger(BackupManager.class.getName());
    private final File backupRoot;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);

    public BackupManager(File backupRoot) {
        Validate.notNull(backupRoot);
        this.backupRoot = backupRoot;
    }

    public boolean backupFiles(Collection<File> files, boolean overwrite) throws IOException {
        Validate.notNull(files);
        String today = this.dateFormat.format(new Date());
        File backupDir = new File(this.backupRoot, today);
        if (backupDir.exists()) {
            if (!overwrite) {
                logger.fine("Backup already exists in '" + backupDir.getAbsolutePath() + "', skipping backup");
                return false;
            }
        } else {
            FileUtils.forceMkdir(backupDir);
        }
        for (File file : files) {
            if (!file.exists()) continue;
            FileUtils.copyFileToDirectory(file, backupDir);
        }
        logger.fine("Files backed up to '" + backupDir.getAbsolutePath() + "'");
        return true;
    }

    public void removeOldBackups(int backupsPreserved) throws IOException {
        if (backupsPreserved < 0) {
            backupsPreserved = 0;
        }
        File[] subdirs = this.backupRoot.listFiles();
        HashMap<Date, File> dateFiles = new HashMap<Date, File>();
        for (File dir : subdirs) {
            if (!dir.isDirectory()) continue;
            try {
                Date date = this.dateFormat.parse(dir.getName());
                dateFiles.put(date, dir);
            }
            catch (ParseException ex) {
                logger.log(Level.WARNING, "Unknown unparsable dir found in backups folder: '" + dir.getAbsolutePath() + "'", ex);
            }
        }
        ArrayList dates = new ArrayList(dateFiles.keySet());
        Collections.sort(dates);
        Collections.reverse(dates);
        if (dates.size() > backupsPreserved) {
            Date[] toRemove;
            Date[] datesArray = dates.toArray(new Date[0]);
            for (Date d : toRemove = Arrays.copyOfRange(datesArray, backupsPreserved, datesArray.length)) {
                File dir = (File)dateFiles.get(d);
                FileUtils.deleteDirectory(dir);
            }
        }
    }
}

