/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

public class BitUtil {
    public static boolean isSet(byte value, byte mask) {
        BitUtil.assertOneBitMask(mask);
        return (value & mask) == mask;
    }

    public static boolean isSet(int value, int mask) {
        BitUtil.assertOneBitMask(mask);
        return (value & mask) == mask;
    }

    private static void assertOneBitMask(long mask) {
        assert ((mask & mask - 1L) == 0L) : "Mask must have only one bit set, but got: " + Long.toBinaryString(mask);
    }

    public static boolean notSet(int value, int mask) {
        return (value & mask) != mask;
    }

    public static byte set(byte value, byte mask, boolean setBit) {
        BitUtil.assertOneBitMask(mask);
        return (byte)(setBit ? value | mask : value & ~mask);
    }

    public static int set(int value, int mask, boolean setBit) {
        BitUtil.assertOneBitMask(mask);
        return setBit ? value | mask : value & ~mask;
    }
}

