/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentWeakKeySoftValueHashMap;
import org.jetbrains.kotlin.gnu.trove.TObjectHashingStrategy;

class ConcurrentWeakKeyWeakValueHashMap<K, V>
extends ConcurrentWeakKeySoftValueHashMap<K, V> {
    ConcurrentWeakKeyWeakValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentWeakKeyWeakValueHashMap", "<init>"));
        }
        super(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    @Override
    @NotNull
    protected ConcurrentWeakKeySoftValueHashMap.KeyReference<K, V> createKeyReference(@NotNull K k, @NotNull V v) {
        if (k == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k", "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentWeakKeyWeakValueHashMap", "createKeyReference"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentWeakKeyWeakValueHashMap", "createKeyReference"));
        }
        ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> valueReference = this.createValueReference(v, this.myValueQueue);
        ConcurrentWeakKeySoftValueHashMap.WeakKey<K, V> keyReference = new ConcurrentWeakKeySoftValueHashMap.WeakKey<K, V>(k, valueReference, this.myHashingStrategy, this.myKeyQueue);
        if (valueReference instanceof WeakValue) {
            ((WeakValue)valueReference).myKeyReference = keyReference;
        }
        ConcurrentWeakKeySoftValueHashMap.WeakKey<K, V> weakKey = keyReference;
        if (weakKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentWeakKeyWeakValueHashMap", "createKeyReference"));
        }
        return weakKey;
    }

    @Override
    @NotNull
    protected ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> createValueReference(@NotNull V value, @NotNull ReferenceQueue<V> queue) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentWeakKeyWeakValueHashMap", "createValueReference"));
        }
        if (queue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentWeakKeyWeakValueHashMap", "createValueReference"));
        }
        WeakValue weakValue = new WeakValue(value, queue);
        if (weakValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentWeakKeyWeakValueHashMap", "createValueReference"));
        }
        return weakValue;
    }

    private static class WeakValue<K, V>
    extends WeakReference<V>
    implements ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> {
        @NotNull
        private volatile ConcurrentWeakKeySoftValueHashMap.KeyReference<K, V> myKeyReference;

        private WeakValue(@NotNull V value, @NotNull ReferenceQueue<V> queue) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentWeakKeyWeakValueHashMap$WeakValue", "<init>"));
            }
            if (queue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentWeakKeyWeakValueHashMap$WeakValue", "<init>"));
            }
            super(value, queue);
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            Object v = this.get();
            Object thatV = ((ConcurrentWeakKeySoftValueHashMap.ValueReference)o).get();
            return v != null && thatV != null && v.equals(thatV);
        }

        @Override
        @NotNull
        public ConcurrentWeakKeySoftValueHashMap.KeyReference<K, V> getKeyReference() {
            ConcurrentWeakKeySoftValueHashMap.KeyReference<K, V> keyReference = this.myKeyReference;
            if (keyReference == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentWeakKeyWeakValueHashMap$WeakValue", "getKeyReference"));
            }
            return keyReference;
        }
    }
}

