/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.types.CastDiagnosticsUtil;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeReconstructionResult;
import org.jetbrains.kotlin.types.TypeUtils;

public class PossiblyBareType {
    private final KotlinType actualType;
    private final TypeConstructor bareTypeConstructor;
    private final boolean nullable;

    @NotNull
    public static PossiblyBareType bare(@NotNull TypeConstructor bareTypeConstructor, boolean nullable) {
        if (bareTypeConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bareTypeConstructor", "org/jetbrains/kotlin/resolve/PossiblyBareType", "bare"));
        }
        PossiblyBareType possiblyBareType = new PossiblyBareType(null, bareTypeConstructor, nullable);
        if (possiblyBareType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/PossiblyBareType", "bare"));
        }
        return possiblyBareType;
    }

    @NotNull
    public static PossiblyBareType type(@NotNull KotlinType actualType) {
        if (actualType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actualType", "org/jetbrains/kotlin/resolve/PossiblyBareType", "type"));
        }
        PossiblyBareType possiblyBareType = new PossiblyBareType(actualType, null, false);
        if (possiblyBareType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/PossiblyBareType", "type"));
        }
        return possiblyBareType;
    }

    private PossiblyBareType(@Nullable KotlinType actualType, @Nullable TypeConstructor bareTypeConstructor, boolean nullable) {
        this.actualType = actualType;
        this.bareTypeConstructor = bareTypeConstructor;
        this.nullable = nullable;
    }

    public boolean isBare() {
        return this.actualType == null;
    }

    @NotNull
    public KotlinType getActualType() {
        KotlinType kotlinType = this.actualType;
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/PossiblyBareType", "getActualType"));
        }
        return kotlinType;
    }

    @NotNull
    public TypeConstructor getBareTypeConstructor() {
        TypeConstructor typeConstructor2 = this.bareTypeConstructor;
        if (typeConstructor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/PossiblyBareType", "getBareTypeConstructor"));
        }
        return typeConstructor2;
    }

    private boolean isBareTypeNullable() {
        return this.nullable;
    }

    public boolean isNullable() {
        if (this.isBare()) {
            return this.isBareTypeNullable();
        }
        return this.getActualType().isMarkedNullable();
    }

    public PossiblyBareType makeNullable() {
        if (this.isBare()) {
            return this.isBareTypeNullable() ? this : PossiblyBareType.bare(this.getBareTypeConstructor(), true);
        }
        return PossiblyBareType.type(TypeUtils.makeNullable(this.getActualType()));
    }

    @NotNull
    public TypeReconstructionResult reconstruct(@NotNull KotlinType subjectType) {
        if (subjectType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subjectType", "org/jetbrains/kotlin/resolve/PossiblyBareType", "reconstruct"));
        }
        if (!this.isBare()) {
            TypeReconstructionResult typeReconstructionResult = new TypeReconstructionResult(this.getActualType(), true);
            if (typeReconstructionResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/PossiblyBareType", "reconstruct"));
            }
            return typeReconstructionResult;
        }
        TypeReconstructionResult reconstructionResult = CastDiagnosticsUtil.findStaticallyKnownSubtype(TypeUtils.makeNotNullable(subjectType), this.getBareTypeConstructor());
        KotlinType type2 = reconstructionResult.getResultingType();
        if (type2 == null) {
            TypeReconstructionResult typeReconstructionResult = reconstructionResult;
            if (typeReconstructionResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/PossiblyBareType", "reconstruct"));
            }
            return typeReconstructionResult;
        }
        KotlinType resultingType = TypeUtils.makeNullableAsSpecified(type2, this.isBareTypeNullable());
        TypeReconstructionResult typeReconstructionResult = new TypeReconstructionResult(resultingType, reconstructionResult.isAllArgumentsInferred());
        if (typeReconstructionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/PossiblyBareType", "reconstruct"));
        }
        return typeReconstructionResult;
    }

    public String toString() {
        return this.isBare() ? "bare " + this.bareTypeConstructor + (this.isBareTypeNullable() ? "?" : "") : this.getActualType().toString();
    }
}

