/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.protocol.json;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.json.SdkJsonGenerator;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.dataformat.cbor.CBORGenerator;
import java.io.IOException;
import java.util.Date;

@SdkInternalApi
class SdkCborGenerator
extends SdkJsonGenerator {
    private static final int CBOR_TAG_TIMESTAP = 1;

    public SdkCborGenerator(JsonFactory factory, String contentType) {
        super(factory, contentType);
    }

    @Override
    public StructuredJsonGenerator writeValue(Date date) {
        if (!(this.getGenerator() instanceof CBORGenerator)) {
            throw new IllegalStateException("SdkCborGenerator is not created with a CBORGenerator.");
        }
        CBORGenerator generator = (CBORGenerator)this.getGenerator();
        try {
            generator.writeTag(1);
            generator.writeNumber(date.getTime());
        }
        catch (IOException e) {
            throw new SdkJsonGenerator.JsonGenerationException(e);
        }
        return this;
    }
}

