/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.openapi.wrappers.ui;

import java.awt.Font;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.gradle.gradleplugin.foundation.GradlePluginLord;
import org.gradle.gradleplugin.foundation.request.ExecutionRequest;
import org.gradle.gradleplugin.foundation.request.RefreshTaskListRequest;
import org.gradle.gradleplugin.foundation.request.Request;
import org.gradle.gradleplugin.userinterface.swing.generic.BasicGradleUI;
import org.gradle.openapi.external.foundation.GradleInterfaceVersion1;
import org.gradle.openapi.external.foundation.favorites.FavoritesEditorVersion1;
import org.gradle.openapi.external.ui.AlternateUIInteractionVersion1;
import org.gradle.openapi.external.ui.BasicGradleUIVersion1;
import org.gradle.openapi.external.ui.CommandLineArgumentAlteringListenerVersion1;
import org.gradle.openapi.external.ui.GradleTabVersion1;
import org.gradle.openapi.external.ui.OutputObserverVersion1;
import org.gradle.openapi.external.ui.OutputUILordVersion1;
import org.gradle.openapi.external.ui.SettingsNodeVersion1;
import org.gradle.openapi.wrappers.foundation.GradleInterfaceWrapperVersion1;
import org.gradle.openapi.wrappers.foundation.GradleInterfaceWrapperVersion2;
import org.gradle.openapi.wrappers.foundation.favorites.FavoritesEditorWrapper;
import org.gradle.openapi.wrappers.ui.AlternateUIInteractionVersionWrapper;
import org.gradle.openapi.wrappers.ui.GradleTabVersionWrapper;
import org.gradle.openapi.wrappers.ui.OutputUILordWrapper;
import org.gradle.openapi.wrappers.ui.SettingsNodeVersionWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOpenAPIUIWrapper<U extends BasicGradleUI> {
    private U basicGradleUI;
    private Map<GradleTabVersion1, GradleTabVersionWrapper> tabMap = new HashMap<GradleTabVersion1, GradleTabVersionWrapper>();
    protected SettingsNodeVersionWrapper settingsVersionWrapper;
    protected AlternateUIInteractionVersionWrapper alternateUIInteractionVersionWrapper;
    protected GradleInterfaceVersion1 gradleInterfaceWrapper;
    private OutputUILordWrapper outputUILordWrapper;

    public AbstractOpenAPIUIWrapper(SettingsNodeVersion1 settings, AlternateUIInteractionVersion1 alternateUIInteraction) {
        this.settingsVersionWrapper = new SettingsNodeVersionWrapper(settings);
        this.alternateUIInteractionVersionWrapper = new AlternateUIInteractionVersionWrapper(alternateUIInteraction, this.settingsVersionWrapper);
    }

    public void initialize(U basicGradleUI) {
        this.basicGradleUI = basicGradleUI;
        basicGradleUI.getGradlePluginLord().addRequestObserver(new GradlePluginLord.RequestObserver(){

            public void aboutToExecuteRequest(Request request) {
                AbstractOpenAPIUIWrapper.this.alternateUIInteractionVersionWrapper.aboutToExecuteCommand(request.getFullCommandLine());
            }

            public void executionRequestAdded(ExecutionRequest request) {
            }

            public void refreshRequestAdded(RefreshTaskListRequest request) {
            }

            public void requestExecutionComplete(Request request, int result, String output) {
            }
        }, false);
        this.outputUILordWrapper = new OutputUILordWrapper(basicGradleUI.getOutputUILord());
        this.gradleInterfaceWrapper = this.instantiateGradleInterfaceWrapper();
    }

    protected GradleInterfaceVersion1 instantiateGradleInterfaceWrapper() {
        try {
            return new GradleInterfaceWrapperVersion2(this.basicGradleUI.getGradlePluginLord());
        }
        catch (NoClassDefFoundError e) {
            return new GradleInterfaceWrapperVersion1(this.basicGradleUI.getGradlePluginLord());
        }
    }

    public U getGradleUI() {
        return this.basicGradleUI;
    }

    public void aboutToShow() {
        this.basicGradleUI.aboutToShow();
    }

    public boolean canClose(final BasicGradleUIVersion1.CloseInteraction closeInteraction) {
        return this.basicGradleUI.canClose(new BasicGradleUI.CloseInteraction(){

            public boolean promptUserToConfirmClosingWhileBusy() {
                return closeInteraction.promptUserToConfirmClosingWhileBusy();
            }
        });
    }

    public void close() {
        this.basicGradleUI.close();
    }

    public File getCurrentDirectory() {
        return this.gradleInterfaceWrapper.getCurrentDirectory();
    }

    public void setCurrentDirectory(File currentDirectory) {
        this.gradleInterfaceWrapper.setCurrentDirectory(currentDirectory);
    }

    public File getGradleHomeDirectory() {
        return this.gradleInterfaceWrapper.getGradleHomeDirectory();
    }

    public File getCustomGradleExecutable() {
        return this.gradleInterfaceWrapper.getCustomGradleExecutable();
    }

    public void addTab(int index, GradleTabVersion1 gradleTabVersion1) {
        GradleTabVersionWrapper gradleVersionWrapper = new GradleTabVersionWrapper(gradleTabVersion1);
        this.tabMap.put(gradleTabVersion1, gradleVersionWrapper);
        this.basicGradleUI.addGradleTab(index, gradleVersionWrapper);
    }

    public void removeTab(GradleTabVersion1 gradleTabVersion1) {
        GradleTabVersionWrapper gradleTabVersionWrapper = this.tabMap.remove(gradleTabVersion1);
        if (gradleTabVersionWrapper != null) {
            this.basicGradleUI.removeGradleTab(gradleTabVersionWrapper);
        }
    }

    public int getGradleTabCount() {
        return this.basicGradleUI.getGradleTabCount();
    }

    public String getGradleTabName(int index) {
        return this.basicGradleUI.getGradleTabName(index);
    }

    public int getGradleTabIndex(String name) {
        return this.basicGradleUI.getGradleTabIndex(name);
    }

    public int getCurrentGradleTab() {
        return this.basicGradleUI.getCurrentGradleTab();
    }

    public void setCurrentGradleTab(int index) {
        this.basicGradleUI.setCurrentGradleTab(index);
    }

    public void addCommandLineArgumentAlteringListener(CommandLineArgumentAlteringListenerVersion1 listener) {
        this.gradleInterfaceWrapper.addCommandLineArgumentAlteringListener(listener);
    }

    public void removeCommandLineArgumentAlteringListener(CommandLineArgumentAlteringListenerVersion1 listener) {
        this.gradleInterfaceWrapper.removeCommandLineArgumentAlteringListener(listener);
    }

    public OutputUILordVersion1 getOutputLord() {
        return new OutputUILordWrapper(this.basicGradleUI.getOutputUILord());
    }

    public void addOutputObserver(OutputObserverVersion1 observer) {
        this.outputUILordWrapper.addOutputObserver(observer);
    }

    public void removeOutputObserver(OutputObserverVersion1 observer) {
        this.outputUILordWrapper.removeOutputObserver(observer);
    }

    public void executeCommand(String commandLineArguments, String displayName) {
        this.basicGradleUI.executeCommand(commandLineArguments, displayName);
    }

    public void refreshTaskTree() {
        this.basicGradleUI.refreshTaskTree();
    }

    public boolean isBusy() {
        return this.getGradleUI().isBusy();
    }

    public boolean getOnlyShowOutputOnErrors() {
        return this.getGradleUI().getOutputUILord().getOnlyShowOutputOnErrors();
    }

    public void setCustomPanelToSetupTab(JComponent component) {
        this.getGradleUI().setCustomPanelToSetupTab(component);
    }

    public void setOutputTextFont(Font font) {
        this.getGradleUI().setOutputTextFont(font);
    }

    public GradleInterfaceVersion1 getGradleInterfaceVersion1() {
        return this.gradleInterfaceWrapper;
    }

    public FavoritesEditorVersion1 getFavoritesEditor() {
        return new FavoritesEditorWrapper(this.basicGradleUI.getGradlePluginLord().getFavoritesEditor());
    }
}

