/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.source;

import com.oracle.truffle.api.source.Content;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.util.Objects;

final class LiteralSourceImpl
extends Content
implements Content.CreateURI {
    private final String name;

    LiteralSourceImpl(String name, String code) {
        this.name = name;
        this.code = code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getShortName() {
        return this.name;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getPath() {
        return this.name;
    }

    @Override
    public URL getURL() {
        return null;
    }

    @Override
    URI getURI() {
        return this.createURIOnce(this);
    }

    @Override
    public URI createURI() {
        return this.getNamedURI(this.name, this.code.getBytes());
    }

    @Override
    public Reader getReader() {
        return new StringReader(this.code);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.code);
    }

    @Override
    String findMimeType() throws IOException {
        return null;
    }

    @Override
    Object getHashKey() {
        return this.code;
    }
}

