/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.java.model.types;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.annotation.processing.impl.DisposableRef;
import org.jetbrains.kotlin.annotation.processing.impl.DisposableRefKt;
import org.jetbrains.kotlin.java.model.internal.JeElementRegistry;
import org.jetbrains.kotlin.java.model.types.JePsiType;
import org.jetbrains.kotlin.java.model.types.JeTypeWithManager;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005B\u0015\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/java/model/types/JePsiTypeBase;", "T", "Lcom/intellij/psi/PsiType;", "Lorg/jetbrains/kotlin/java/model/types/JePsiType;", "Lorg/jetbrains/kotlin/java/model/types/JeTypeWithManager;", "Lcom/intellij/openapi/Disposable;", "psiType", "manager", "Lcom/intellij/psi/PsiManager;", "(Lcom/intellij/psi/PsiType;Lcom/intellij/psi/PsiManager;)V", "disposableManager", "Lorg/jetbrains/kotlin/annotation/processing/impl/DisposableRef;", "disposableType", "psiManager", "getPsiManager", "()Lcom/intellij/psi/PsiManager;", "getPsiType", "()Lcom/intellij/psi/PsiType;", "dispose", "", "annotation-processing"})
public abstract class JePsiTypeBase<T extends PsiType>
implements JePsiType,
JeTypeWithManager,
Disposable {
    private final DisposableRef<PsiManager> disposableManager;
    private final DisposableRef<T> disposableType;

    public void dispose() {
        DisposableRefKt.dispose(this.disposableManager, this.disposableType);
    }

    @Override
    @NotNull
    public PsiManager getPsiManager() {
        return this.disposableManager.invoke();
    }

    @NotNull
    public T getPsiType() {
        return (T)((PsiType)this.disposableType.invoke());
    }

    public JePsiTypeBase(@NotNull T psiType, @NotNull PsiManager manager) {
        Intrinsics.checkParameterIsNotNull(psiType, (String)"psiType");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        this.disposableManager = DisposableRefKt.toDisposable(manager);
        this.disposableType = DisposableRefKt.toDisposable(psiType);
        ((JeElementRegistry)ServiceManager.getService((Project)manager.getProject(), JeElementRegistry.class)).register(this);
    }

    @Override
    @NotNull
    public List<AnnotationMirror> getAnnotationMirrors() {
        return JePsiType.DefaultImpls.getAnnotationMirrors(this);
    }

    @Override
    @Nullable
    public <A extends Annotation> Void getAnnotation(@Nullable Class<A> annotationClass) {
        return JePsiType.DefaultImpls.getAnnotation(this, annotationClass);
    }

    @Override
    @NotNull
    public <A extends Annotation> A[] getAnnotationsByType(@NotNull Class<A> annotationType) {
        Intrinsics.checkParameterIsNotNull(annotationType, (String)"annotationType");
        return JePsiType.DefaultImpls.getAnnotationsByType((JePsiType)this, annotationType);
    }
}

