/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsConditional;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.JsReturn;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.StaticContext;
import org.jetbrains.kotlin.js.translate.context.TemporaryConstVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.KotlinType;

public final class TranslationUtils {
    private TranslationUtils() {
    }

    @NotNull
    public static JsPropertyInitializer translateFunctionAsEcma5PropertyDescriptor(@NotNull JsFunction function, @NotNull FunctionDescriptor descriptor2, @NotNull TranslationContext context) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateFunctionAsEcma5PropertyDescriptor"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateFunctionAsEcma5PropertyDescriptor"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateFunctionAsEcma5PropertyDescriptor"));
        }
        if (DescriptorUtils.isExtension(descriptor2) || descriptor2 instanceof PropertyAccessorDescriptor && TranslationUtils.shouldGenerateAccessors(((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty())) {
            JsPropertyInitializer jsPropertyInitializer = TranslationUtils.translateExtensionFunctionAsEcma5DataDescriptor(function, descriptor2, context);
            if (jsPropertyInitializer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateFunctionAsEcma5PropertyDescriptor"));
            }
            return jsPropertyInitializer;
        }
        JsStringLiteral getOrSet = context.program().getStringLiteral(descriptor2 instanceof PropertyGetterDescriptor ? "get" : "set");
        JsPropertyInitializer jsPropertyInitializer = new JsPropertyInitializer(getOrSet, function);
        if (jsPropertyInitializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateFunctionAsEcma5PropertyDescriptor"));
        }
        return jsPropertyInitializer;
    }

    @NotNull
    public static JsFunction simpleReturnFunction(@NotNull JsScope functionScope, @NotNull JsExpression returnExpression) {
        if (functionScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionScope", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "simpleReturnFunction"));
        }
        if (returnExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnExpression", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "simpleReturnFunction"));
        }
        JsFunction jsFunction = new JsFunction(functionScope, new JsBlock(new JsReturn(returnExpression)), "<simpleReturnFunction>");
        if (jsFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "simpleReturnFunction"));
        }
        return jsFunction;
    }

    @NotNull
    private static JsPropertyInitializer translateExtensionFunctionAsEcma5DataDescriptor(@NotNull JsFunction function, @NotNull FunctionDescriptor descriptor2, @NotNull TranslationContext context) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateExtensionFunctionAsEcma5DataDescriptor"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateExtensionFunctionAsEcma5DataDescriptor"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateExtensionFunctionAsEcma5DataDescriptor"));
        }
        JsObjectLiteral meta = JsAstUtils.createDataDescriptor(function, ModalityKt.isOverridable(descriptor2), false);
        JsPropertyInitializer jsPropertyInitializer = new JsPropertyInitializer(context.getNameForDescriptor(descriptor2).makeRef(), meta);
        if (jsPropertyInitializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateExtensionFunctionAsEcma5DataDescriptor"));
        }
        return jsPropertyInitializer;
    }

    @NotNull
    public static JsExpression translateExclForBinaryEqualLikeExpr(@NotNull JsBinaryOperation baseBinaryExpression) {
        if (baseBinaryExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseBinaryExpression", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateExclForBinaryEqualLikeExpr"));
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(TranslationUtils.notOperator(baseBinaryExpression.getOperator()), baseBinaryExpression.getArg1(), baseBinaryExpression.getArg2());
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateExclForBinaryEqualLikeExpr"));
        }
        return jsBinaryOperation;
    }

    public static boolean isEqualLikeOperator(@NotNull JsBinaryOperator operator) {
        if (operator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operator", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "isEqualLikeOperator"));
        }
        return TranslationUtils.notOperator(operator) != null;
    }

    @Nullable
    private static JsBinaryOperator notOperator(@NotNull JsBinaryOperator operator) {
        if (operator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operator", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "notOperator"));
        }
        switch (operator) {
            case REF_EQ: {
                return JsBinaryOperator.REF_NEQ;
            }
            case REF_NEQ: {
                return JsBinaryOperator.REF_EQ;
            }
            case EQ: {
                return JsBinaryOperator.NEQ;
            }
            case NEQ: {
                return JsBinaryOperator.EQ;
            }
        }
        return null;
    }

    @NotNull
    public static JsBinaryOperation isNullCheck(@NotNull JsExpression expressionToCheck) {
        if (expressionToCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToCheck", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "isNullCheck"));
        }
        JsBinaryOperation jsBinaryOperation = TranslationUtils.nullCheck(expressionToCheck, false);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "isNullCheck"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation isNotNullCheck(@NotNull JsExpression expressionToCheck) {
        if (expressionToCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToCheck", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "isNotNullCheck"));
        }
        JsBinaryOperation jsBinaryOperation = TranslationUtils.nullCheck(expressionToCheck, true);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "isNotNullCheck"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation nullCheck(@NotNull JsExpression expressionToCheck, boolean isNegated) {
        if (expressionToCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToCheck", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "nullCheck"));
        }
        JsBinaryOperator operator = isNegated ? JsBinaryOperator.NEQ : JsBinaryOperator.EQ;
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(operator, expressionToCheck, JsLiteral.NULL);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "nullCheck"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsConditional notNullConditional(@NotNull JsExpression expression, @NotNull JsExpression elseExpression, @NotNull TranslationContext context) {
        JsExpression thenExpression;
        JsBinaryOperation testExpression;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "notNullConditional"));
        }
        if (elseExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elseExpression", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "notNullConditional"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "notNullConditional"));
        }
        if (TranslationUtils.isCacheNeeded(expression)) {
            TemporaryConstVariable tempVar = context.getOrDeclareTemporaryConstVariable(expression);
            testExpression = TranslationUtils.isNotNullCheck(tempVar.value());
            thenExpression = tempVar.value();
        } else {
            testExpression = TranslationUtils.isNotNullCheck(expression);
            thenExpression = expression;
        }
        JsConditional jsConditional = new JsConditional(testExpression, thenExpression, elseExpression);
        if (jsConditional == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "notNullConditional"));
        }
        return jsConditional;
    }

    @NotNull
    public static JsNameRef backingFieldReference(@NotNull TranslationContext context, @NotNull PropertyDescriptor descriptor2) {
        DeclarationDescriptor containingDescriptor;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "backingFieldReference"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "backingFieldReference"));
        }
        JsName backingFieldName = context.getNameForDescriptor(descriptor2);
        if (!JsDescriptorUtils.isSimpleFinalProperty(descriptor2)) {
            JsName backingFieldMangledName = context.getNameForBackingField(descriptor2);
            backingFieldName = context.declarePropertyOrPropertyAccessorName(descriptor2, backingFieldMangledName.getIdent(), false);
        }
        JsExpression receiver = (containingDescriptor = descriptor2.getContainingDeclaration()) instanceof PackageFragmentDescriptor ? JsLiteral.THIS : context.getDispatchReceiver(JsDescriptorUtils.getReceiverParameterForDeclaration(containingDescriptor));
        JsNameRef jsNameRef = new JsNameRef(backingFieldName, receiver);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "backingFieldReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public static JsExpression assignmentToBackingField(@NotNull TranslationContext context, @NotNull PropertyDescriptor descriptor2, @NotNull JsExpression assignTo) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "assignmentToBackingField"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "assignmentToBackingField"));
        }
        if (assignTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignTo", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "assignmentToBackingField"));
        }
        JsNameRef backingFieldReference = TranslationUtils.backingFieldReference(context, descriptor2);
        JsBinaryOperation jsBinaryOperation = JsAstUtils.assignment(backingFieldReference, assignTo);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "assignmentToBackingField"));
        }
        return jsBinaryOperation;
    }

    @Nullable
    public static JsExpression translateInitializerForProperty(@NotNull KtProperty declaration, @NotNull TranslationContext context) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateInitializerForProperty"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateInitializerForProperty"));
        }
        JsExpression jsInitExpression = null;
        KtExpression initializer2 = declaration.getInitializer();
        if (initializer2 != null) {
            jsInitExpression = Translation.translateAsExpression(initializer2, context);
        }
        return jsInitExpression;
    }

    @NotNull
    public static JsExpression translateBaseExpression(@NotNull TranslationContext context, @NotNull KtUnaryExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateBaseExpression"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateBaseExpression"));
        }
        KtExpression baseExpression = PsiUtils.getBaseExpression(expression);
        JsExpression jsExpression = Translation.translateAsExpression(baseExpression, context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateBaseExpression"));
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression translateLeftExpression(@NotNull TranslationContext context, @NotNull KtBinaryExpression expression, @NotNull JsBlock block) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateLeftExpression"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateLeftExpression"));
        }
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateLeftExpression"));
        }
        KtExpression left = expression.getLeft();
        assert (left != null) : "Binary expression should have a left expression: " + expression.getText();
        JsExpression jsExpression = Translation.translateAsExpression(left, context, block);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateLeftExpression"));
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression translateRightExpression(@NotNull TranslationContext context, @NotNull KtBinaryExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateRightExpression"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateRightExpression"));
        }
        JsExpression jsExpression = TranslationUtils.translateRightExpression(context, expression, context.dynamicContext().jsBlock());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateRightExpression"));
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression translateRightExpression(@NotNull TranslationContext context, @NotNull KtBinaryExpression expression, @NotNull JsBlock block) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateRightExpression"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateRightExpression"));
        }
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateRightExpression"));
        }
        KtExpression rightExpression = expression.getRight();
        assert (rightExpression != null) : "Binary expression should have a right expression";
        JsExpression jsExpression = Translation.translateAsExpression(rightExpression, context, block);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateRightExpression"));
        }
        return jsExpression;
    }

    public static boolean hasCorrespondingFunctionIntrinsic(@NotNull TranslationContext context, @NotNull KtOperationExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "hasCorrespondingFunctionIntrinsic"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "hasCorrespondingFunctionIntrinsic"));
        }
        CallableDescriptor operationDescriptor = BindingUtils.getCallableDescriptorForOperationExpression(context.bindingContext(), expression);
        if (operationDescriptor == null || !(operationDescriptor instanceof FunctionDescriptor)) {
            return true;
        }
        KotlinType returnType = operationDescriptor.getReturnType();
        if (returnType != null && (KotlinBuiltIns.isChar(returnType) || KotlinBuiltIns.isLong(returnType))) {
            return false;
        }
        return context.intrinsics().getFunctionIntrinsic((FunctionDescriptor)operationDescriptor).exists();
    }

    @NotNull
    public static List<JsExpression> generateInvocationArguments(@NotNull JsExpression receiver, @NotNull List<JsExpression> arguments2) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "generateInvocationArguments"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "generateInvocationArguments"));
        }
        ArrayList<JsExpression> argumentList2 = new ArrayList<JsExpression>(1 + arguments2.size());
        argumentList2.add(receiver);
        argumentList2.addAll(arguments2);
        ArrayList<JsExpression> arrayList = argumentList2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "generateInvocationArguments"));
        }
        return arrayList;
    }

    public static boolean isCacheNeeded(@NotNull JsExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "isCacheNeeded"));
        }
        return !(expression instanceof JsLiteral.JsValueLiteral) && (!(expression instanceof JsNameRef) || ((JsNameRef)expression).getQualifier() != null);
    }

    @NotNull
    public static JsConditional sure(@NotNull JsExpression expression, @NotNull TranslationContext context) {
        JsName name;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "sure"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "sure"));
        }
        JsInvocation throwNPE = new JsInvocation(Namer.throwNPEFunctionRef(), new JsExpression[0]);
        JsConditional ensureNotNull = TranslationUtils.notNullConditional(expression, throwNPE, context);
        JsExpression thenExpression = ensureNotNull.getThenExpression();
        if (thenExpression instanceof JsNameRef && (name = ((JsNameRef)thenExpression).getName()) != null) {
            context.associateExpressionToLazyValue(ensureNotNull, new TemporaryConstVariable(name, ensureNotNull));
        }
        JsConditional jsConditional = ensureNotNull;
        if (jsConditional == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "sure"));
        }
        return jsConditional;
    }

    @NotNull
    public static String getSuggestedNameForInnerDeclaration(StaticContext context, DeclarationDescriptor descriptor2) {
        String suggestedName = "";
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        if (!(containingDeclaration == null || containingDeclaration instanceof ClassOrPackageFragmentDescriptor || containingDeclaration instanceof AnonymousFunctionDescriptor || containingDeclaration instanceof ConstructorDescriptor && DescriptorUtils.isAnonymousObject(containingDeclaration.getContainingDeclaration()))) {
            suggestedName = context.getNameForDescriptor(containingDeclaration).getIdent();
        }
        if (!suggestedName.isEmpty() && !suggestedName.endsWith("$")) {
            suggestedName = suggestedName + "$";
        }
        suggestedName = descriptor2.getName().isSpecial() ? suggestedName + "f" : suggestedName + context.getNameForDescriptor(descriptor2).getIdent();
        String string = suggestedName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "getSuggestedNameForInnerDeclaration"));
        }
        return string;
    }

    public static boolean shouldGenerateAccessors(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "shouldGenerateAccessors"));
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            return TranslationUtils.shouldGenerateAccessors((PropertyDescriptor)descriptor2);
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            return TranslationUtils.shouldGenerateAccessors(((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty());
        }
        return false;
    }

    private static boolean shouldGenerateAccessors(@NotNull PropertyDescriptor property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "shouldGenerateAccessors"));
        }
        if (AnnotationsUtils.hasJsNameInAccessors(property)) {
            return true;
        }
        for (PropertyDescriptor propertyDescriptor : property.getOverriddenDescriptors()) {
            if (!TranslationUtils.shouldGenerateAccessors(propertyDescriptor)) continue;
            return true;
        }
        return false;
    }
}

